
#ifndef __LITHIUM_WINDOW_H
#define __LITHIUM_WINDOW_H

#define LW_ACTIVE			(0x0001)	// Is window currently active? (set internally)
#define LW_MINIMIZED		(0x0002)	// NOT IMPLEMENTED
#define LW_ALWAYSTOP		(0x0004)	// NOT IMPLEMENTED
#define LW_RESIZABLE		(0x0008)	// Is window resizable (set at init)
#define LW_MOVEABLE			(0x0010)	// Is window moveable (set at init)
#define LW_TITLEBAR			(0x0020)	// Does window have a titlebar (set at init)
#define LW_SHIRNKABLE		(0x0040)	// NOT IMPLEMENTED
#define LW_VISIBLE			(0x0080)	// Is window visible? (e.g. should it be drawn)

class LithiumWindow {
	protected:	

		int m_iXPos, m_iYPos;		// Basic dimensions for a
		int m_iWidth, m_iHeight;	// LithiumWindow

		DDWORD m_dwFlags;			// Window flags
		
		char m_szTitle[32];			// Window title

		DBOOL	m_bInited;

		LWMgr	*m_pLWMgr;

		HSURFACE m_hSurface;

	public:

		LithiumWindow();
		~LithiumWindow();

		virtual DRESULT	Initialize(int x, int y, int width, int height,
							const char *title, DDWORD dwFlags, LWMgr *pLWMgr);
		virtual	void	Destroy();

		virtual DRESULT Resize(int width, int height);
		virtual DRESULT Paint(HSURFACE hSurf);
		virtual DRESULT PaintBorder();
		
		virtual DRESULT Move(int x, int y);

		virtual DRESULT Iconify(HSURFACE hIcon);

		virtual DRESULT MouseClick(int x, int y);
		virtual DRESULT MouseDrag(int x, int y, int dx, int dy);

		// Simple inlines
		int				GetX() { return m_iXPos; };
		int				GetY() { return m_iYPos; };
		int				GetWidth() { return m_iWidth; };
		int				GetHeight() { return m_iHeight; };
		DDWORD			GetFlags() { return m_dwFlags; };
		void			SetFlags(DDWORD dwFlags) { m_dwFlags = dwFlags; };
		const char *	GetTitle() { return &m_szTitle[0]; };
};

#endif // __LITHIUM_WINDOW_H