
#include "lithium.h"
#include "stdio.h"

LithiumWindow::LithiumWindow()
{
	m_iXPos = 0;
	m_iYPos = 0;
	m_iHeight = 0;
	m_iWidth = 0;
	m_dwFlags = 0;

	memset(&m_szTitle,0,sizeof(m_szTitle));

	m_hSurface = DNULL;

	m_bInited = DFALSE;
}

LithiumWindow::~LithiumWindow()
{
	if (m_bInited) {
		Destroy();
	}
}

DRESULT LithiumWindow::Initialize(int x, int y, int width, int height,
							const char *title, DDWORD dwFlags, LWMgr *pLWMgr)
{
	if (!pLWMgr) return LERR_NO_LWMGR;

	if (width < 0) width = 32;
	if (height < 0) height = 32;
	if (width > 640) width = 640;
	if (height > 480) height = 480;

	if (x > (640 - width)) x = 640 - width;
	if (y > (480 - height)) y = 480 - height;

	m_iXPos = x;
	m_iYPos = y;
	m_iHeight = height;
	m_iWidth = width;

	m_dwFlags = dwFlags;

	m_pLWMgr = pLWMgr;

	if (title)
		sprintf(m_szTitle,"%.31s",title);

	m_hSurface = pLWMgr->GetClient()->CreateSurface(m_iWidth,m_iHeight);

	m_bInited = DTRUE;

	PaintBorder();

	return LERR_NONE;
}

void LithiumWindow::Destroy()
{
	if (!m_bInited) return;

	m_pLWMgr->GetClient()->DeleteSurface(m_hSurface);

	m_iXPos = 0;
	m_iYPos = 0;
	m_iHeight = 0;
	m_iWidth = 0;
	m_dwFlags = 0;

	memset(&m_szTitle,0,sizeof(m_szTitle));

	m_hSurface = DNULL;

	m_bInited = DFALSE;

	m_pLWMgr->DeleteFromStack(this);
}

DRESULT LithiumWindow::PaintBorder()
{
	char path[256];
	HSURFACE hSrc;

	m_pLWMgr->GetClient()->FillRect(m_hSurface,DNULL,DNULL);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"bar-top.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,0,0);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"bar-bottom.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,0,m_iHeight - 4);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"bar-left.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,0,0);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"bar-right.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,m_iWidth - 4,0);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"corner-topleft.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,0,0);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"corner-topright.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,m_iWidth - 4,0);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"corner-bottomleft.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,0,m_iHeight - 4);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	sprintf(path,"lithium\\window\\%s\\%s", m_dwFlags & LW_ACTIVE ? "active" : "inactive",
		"corner-bottomright.pcx");
	hSrc = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap(path);
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(m_hSurface,hSrc,DNULL,m_iWidth - 4, m_iHeight - 4);
	m_pLWMgr->GetClient()->DeleteSurface(hSrc);

	if (m_dwFlags & LW_TITLEBAR) {

		HDECOLOR hFore, hBack;

		if (m_dwFlags & LW_ACTIVE) {
			hFore = m_pLWMgr->GetClient()->CreateColor(1.0f,1.0f,1.0f,DFALSE);
			hBack = m_pLWMgr->GetClient()->CreateColor(0.0f,0.0f,0.8f,DFALSE);
		} else {
			hFore = m_pLWMgr->GetClient()->CreateColor(0.5f,0.5f,0.5f,DFALSE);
			hBack = m_pLWMgr->GetClient()->CreateColor(0.2f,0.2f,0.2f,DFALSE);
		}

		HDEFONT hFont;

		hFont = m_pLWMgr->GetClient()->CreateFont("Small Fonts",6,10,DFALSE,DFALSE,DFALSE);

		HSTRING hStr;

		hStr = m_pLWMgr->GetClient()->CreateString(m_szTitle);

		DRect rect;
		int tempX, tempY;

		m_pLWMgr->GetClient()->GetStringDimensions(hFont,hStr,&tempX,&tempY);
	
		rect.top = 0;
		rect.bottom = tempY;
		rect.left = (m_iWidth - tempX) / 2;
		rect.right = rect.left + tempX;

		m_pLWMgr->GetClient()->DrawStringToSurface(m_hSurface,hFont,hStr,&rect,hFore,hBack);

		// Clean up after ourselves.
		m_pLWMgr->GetClient()->FreeString(hStr);
		m_pLWMgr->GetClient()->DeleteColor(hFore);
		m_pLWMgr->GetClient()->DeleteColor(hBack);
		m_pLWMgr->GetClient()->DeleteFont(hFont);
	}

	return LERR_NONE;
}

DRESULT LithiumWindow::Paint(HSURFACE hSurface)
{
	m_pLWMgr->GetClient()->DrawSurfaceToSurface(hSurface,m_hSurface,DNULL,m_iXPos,m_iYPos);

	return LERR_NONE;
}

DRESULT LithiumWindow::Resize(int width, int height)
{
	if (width < 0) width = 32;
	if (height < 0) height = 32;
	if (width > 640) width = 640;
	if (height > 480) height = 480;

	if (m_iXPos > (640 - width)) m_iXPos = 640 - width;
	if (m_iYPos > (480 - height)) m_iYPos = 480 - height;

	m_iHeight = height;
	m_iWidth = width;

	m_pLWMgr->GetClient()->DeleteSurface(m_hSurface);
	m_hSurface = m_pLWMgr->GetClient()->CreateSurface(m_iWidth,m_iHeight);

	PaintBorder();

	return LERR_NONE;
}

DRESULT LithiumWindow::Iconify(HSURFACE hIcon)
{
	return LERR_NONE;
}

DRESULT LithiumWindow::Move(int x, int y)
{
	if (!(m_dwFlags & LW_MOVEABLE)) return LERR_CANT_MOVE;

	m_iXPos = x;
	m_iYPos = y;

	if (m_iXPos < 0) m_iXPos = 0;
	if (m_iYPos < 0) m_iYPos = 0;
	if ((m_iXPos + m_iWidth) > 640) m_iXPos = 640 - m_iWidth;
	if ((m_iYPos + m_iHeight) > 480) m_iYPos = 480 - m_iHeight;

	return LERR_NONE;
}

DRESULT LithiumWindow::MouseClick(int x, int y)
{
	m_pLWMgr->GetClient()->CPrint("LWM: Got a mouse click: %d, %d",
		x, y);

	return LERR_NONE;
}

DRESULT LithiumWindow::MouseDrag(int x, int y, int dx, int dy)
{
	m_pLWMgr->GetClient()->CPrint("LWM: Got a mouse drag: %d, %d offset %d, %d",
		x, y, dx, dy);

	return LERR_NONE;
}