
#ifndef __LITHIUM_MOUSE_H
#define __LITHIUM_MOUSE_H

#define LMPTR_POINTER		(0)
#define LMPTR_MOVE			(1)
#define LMPTR_SIZEH			(2)
#define LMPTR_SIZEV			(3)
#define LMPTR_SIZELR		(4)
#define LMPTR_SIZERL		(5)
#define LMPTR_USER			(6)

class LithiumMouse {

	protected:
		HSURFACE	m_hPointer;			// Normal pointer
		HSURFACE	m_hMove;			// 'Movement' pointer
		HSURFACE	m_hSizeH;			// Horizontal resize pointer
		HSURFACE	m_hSizeV;			// Vertical resize pointer
		HSURFACE	m_hSizeLR;			// Size diagonal left -> right
		HSURFACE	m_hSizeRL;			// Size diagonal right -> left

		int			m_iXPos, m_iYPos;	// Mouse position

		DBOOL		m_bInited;

		LWMgr		*m_pLWMgr;

	public:
		LithiumMouse();
		~LithiumMouse();

		DRESULT		Initialize(LWMgr *pMgr);
		void		Destroy();

		int			GetXPos() { return m_iXPos; };
		int			GetYPos() { return m_iYPos; };
		void		SetXPos(int x);
		void		SetYPos(int y);

		DRESULT		Render(HSURFACE hSurface, DBYTE byCursor, HSURFACE hPtr);
	
};

#endif // __LITHIUM_MOUSE_H