#include "lithium.h"

LithiumMouse::LithiumMouse()
{
	m_hPointer = DNULL;
	m_hMove = DNULL;
	m_hSizeH = DNULL;
	m_hSizeV = DNULL;
	m_hSizeLR = DNULL;
	m_hSizeRL = DNULL;
	m_pLWMgr = DNULL;

	m_bInited = DFALSE;
	m_iXPos = 0; m_iYPos = 0;
}

LithiumMouse::~LithiumMouse()
{
	if (m_bInited) {
		Destroy();
	}
}

DRESULT LithiumMouse::Initialize(LWMgr *pLWMgr)
{
	if (!pLWMgr) return LERR_NO_LWMGR;
	if (m_bInited) return LERR_ALREADY_INITIALIZED;

	m_pLWMgr = pLWMgr;

	m_hPointer = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\pointer.pcx");
	if (!m_hPointer) return LERR_CANT_CREATE_SURFACE;

	m_hMove = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\move.pcx");
	if (!m_hMove) {
		m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);

		return LERR_CANT_CREATE_SURFACE;
	}

	m_hSizeH = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\sizeh.pcx");
	if (!m_hSizeH) {
		m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);
		m_pLWMgr->GetClient()->DeleteSurface(m_hMove);

		return LERR_CANT_CREATE_SURFACE;
	}

	m_hSizeV = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\sizev.pcx");
	if (!m_hSizeH) {
		m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);
		m_pLWMgr->GetClient()->DeleteSurface(m_hMove);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeH);

		return LERR_CANT_CREATE_SURFACE;
	}

	m_hSizeLR = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\sizelr.pcx");
	if (!m_hSizeLR) {
		m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);
		m_pLWMgr->GetClient()->DeleteSurface(m_hMove);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeH);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeV);

		return LERR_CANT_CREATE_SURFACE;
	}

	m_hSizeRL = m_pLWMgr->GetClient()->CreateSurfaceFromBitmap("lithium\\cursor\\sizerl.pcx");
	if (!m_hSizeRL) {
		m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);
		m_pLWMgr->GetClient()->DeleteSurface(m_hMove);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeH);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeV);
		m_pLWMgr->GetClient()->DeleteSurface(m_hSizeLR);

		return LERR_CANT_CREATE_SURFACE;
	}

	m_iXPos = 0;
	m_iYPos = 0;
	m_bInited = DTRUE;

	return LERR_NONE;
}

void LithiumMouse::Destroy()
{
	if (!m_bInited) return;

	m_pLWMgr->GetClient()->DeleteSurface(m_hPointer);
	m_pLWMgr->GetClient()->DeleteSurface(m_hMove);
	m_pLWMgr->GetClient()->DeleteSurface(m_hSizeH);
	m_pLWMgr->GetClient()->DeleteSurface(m_hSizeV);
	m_pLWMgr->GetClient()->DeleteSurface(m_hSizeLR);
	m_pLWMgr->GetClient()->DeleteSurface(m_hSizeRL);

	m_hPointer = DNULL;
	m_hMove = DNULL;
	m_hSizeH = DNULL;
	m_hSizeV = DNULL;
	m_hSizeLR = DNULL;
	m_hSizeRL = DNULL;
	m_pLWMgr = DNULL;

	m_bInited = DFALSE;
	m_iXPos = 0; m_iYPos = 0;
}

DRESULT LithiumMouse::Render(HSURFACE hSurf, DBYTE byPointer, HSURFACE hPointer)
{
	if (!m_bInited) return LERR_NO_MOUSE;

	if (!hSurf) return LERR_INVALID_HSURFACE;

	if ((byPointer == LMPTR_USER) && !hPointer) return LERR_INVALID_HSURFACE;

	HSURFACE hPtr;
	int x, y;

	switch (byPointer)
	{
		case LMPTR_POINTER:
			hPtr = m_hPointer;
			x = m_iXPos; y = m_iYPos;
			break;
		case LMPTR_MOVE:
			hPtr = m_hMove;
			x = m_iXPos - 16; y = m_iYPos - 16;
			break;
		case LMPTR_SIZEH:
			hPtr = m_hSizeH;
			x = m_iXPos - 16; y = m_iYPos - 16;
			break;
		case LMPTR_SIZEV:
			hPtr = m_hSizeV;
			x = m_iXPos - 16; y = m_iYPos - 16;
			break;
		case LMPTR_SIZELR:
			hPtr = m_hSizeLR;
			x = m_iXPos - 16; y = m_iYPos - 16;
			break;
		case LMPTR_SIZERL:
			hPtr = m_hSizeRL;
			x = m_iXPos - 16; y = m_iYPos - 16;
			break;
		case LMPTR_USER:
			hPtr = hPointer;
			break;
		default:
			return LERR_UNKNOWN_CURSOR;
	}

	HDECOLOR hCol;

	hCol = m_pLWMgr->GetClient()->CreateColor(1,0,1,DTRUE);

	m_pLWMgr->GetClient()->DrawSurfaceToSurfaceTransparent(
	  hSurf,
	  hPtr, DNULL,
	  x, y,
	  hCol);

	m_pLWMgr->GetClient()->DeleteColor(hCol);

	return LERR_NONE;
}

void LithiumMouse::SetXPos(int x)
{
	m_iXPos = x;

	if (m_iXPos < 0) m_iXPos = 0;
	if (m_iXPos > 640) m_iXPos = 640;
}

void LithiumMouse::SetYPos(int y)
{
	m_iYPos = y;

	if (m_iYPos < 0) m_iYPos = 0;
	if (m_iYPos > 480) m_iYPos = 480;
}
