#ifndef __LWM_H
#define __LWM_H

#include "l_window.h"
#include "l_mouse.h"

// Lithium Window Manager

typedef struct LWStack {
	LithiumWindow	*m_pWindow;
	LWStack			*m_pNext;
	LWStack			*m_pPrev;
} LWStack;

class LWMgr {
	protected:

		ClientDE	*m_pClient;
		LWStack		*m_pStack;

		DBOOL		m_bInited;
		DBOOL		m_bActive;

		int			m_iMode;

		LithiumMouse m_Mouse;
		DBYTE		m_byMouseCursor;

		HSURFACE	m_hDesktop;
		HSURFACE	m_hFinal;
		DBOOL		m_bNeedRedraw;

		void		DeleteFromStack(LWStack *pStack);
		void		AddToStack(LithiumWindow *pWindow);
		void		MoveToTop(LithiumWindow *pWindow);
		LWStack		*FindInStack(LithiumWindow *pWindow);
		LWStack		*GetWindowFromLocation(int x, int y);

	public:

					LWMgr();
					~LWMgr();

		void		Initialize(ClientDE *pClient);
		void		Destroy();
		
		ClientDE	*GetClient() { return m_pClient; };

		void		AddWindow(LithiumWindow *pWindow);
		void		DeleteWindow(LithiumWindow *pWindow);
		void		DeleteFromStack(LithiumWindow *pWindow);

		void		Activate(DBOOL bActive) { m_bActive = bActive; };
		DBOOL		IsActive() { return m_bActive; }

		void		HandleMouse(DFLOAT *offsets);
		void		HandleCommand(int command);

		void		GenerateDesktop();
		void		Render();
};

#endif // __LWM_H