#include "lithium.h"

#define COMMAND_MOUSEBUTTON2	51
#define COMMAND_MOUSEBUTTON0	52

LWMgr::LWMgr()
{
	m_pStack = DNULL;
	m_pClient = DNULL;
	m_bInited = DFALSE;
	m_bActive = DFALSE;
	m_iMode = 0;
	m_hDesktop = DNULL;
	m_hFinal = DNULL;
	m_bNeedRedraw = DTRUE;
}

LWMgr::~LWMgr()
{
	if (m_bInited)
		Destroy();
}

void LWMgr::Initialize(ClientDE *pClient)
{
	m_pClient = pClient;

	m_pClient->CPrint("LWM: Initializing Lithium...");

	m_Mouse.Initialize(this);

	m_pClient->CPrint("LWM: Mouse cursors allocated/initialized...");

	m_bInited = DTRUE;

	m_hDesktop = m_pClient->CreateSurface(640,480);
	m_hFinal = m_pClient->CreateSurface(640,480);

	m_pClient->CPrint("LWM: Desktop buffer surfaces allocated...");

	m_pClient->CPrint("LWM: Lithium Window Manager v%s initialized.", LITHIUM_VERSION);
}

void LWMgr::Destroy()
{
	LWStack *temp, *temp2;

	m_pClient->CPrint("LWM: Terminating Lithium.");

	temp = m_pStack;

	while (temp)
	{
		temp2 = temp->m_pNext;
		temp->m_pWindow->Destroy();
		free(temp);
		temp = temp2;
	}

	if (m_hDesktop)
		m_pClient->DeleteSurface(m_hDesktop);

	if (m_hFinal)
		m_pClient->DeleteSurface(m_hFinal);

	m_hDesktop = DNULL;
	m_hFinal = DNULL;

	m_Mouse.Destroy();

	m_pClient = DNULL;
	m_bInited = DFALSE;
}

LWStack *LWMgr::FindInStack(LithiumWindow *pWindow)
{
	LWStack *temp;

	temp = m_pStack;

	while(temp) {
		if (pWindow == temp->m_pWindow)
			break;
		temp = temp->m_pNext;
	}

	return temp;
}

void LWMgr::DeleteFromStack(LWStack *pStack)
{
	if (pStack->m_pNext)
		pStack->m_pNext->m_pPrev = pStack->m_pPrev;

	if (pStack->m_pPrev)
		pStack->m_pPrev->m_pNext = pStack->m_pNext;
	else
		m_pStack = pStack->m_pNext;

	free(pStack);
}

void LWMgr::DeleteFromStack(LithiumWindow *pWindow)
{
	LWStack *pStack;

	pStack = FindInStack(pWindow);

	if (pStack) DeleteFromStack(pStack);
}

void LWMgr::AddToStack(LithiumWindow *pWindow)
{
	LWStack *pStack;

	pStack = (LWStack *)malloc(sizeof(LWStack));

	pStack->m_pNext = DNULL;
	pStack->m_pPrev = DNULL;
	pStack->m_pWindow = pWindow;

	if (m_pStack) {
		LWStack *tStack, *tsOld;

		tStack = m_pStack;

		while(tStack) {
			tsOld = tStack;
			tStack = tStack->m_pNext;
		}

		pStack->m_pPrev = tsOld;

		if (tsOld)
			tsOld->m_pNext = pStack;

	} else {
		m_pStack = pStack;
	}
}

void LWMgr::AddWindow(LithiumWindow *pWindow)
{
	AddToStack(pWindow);

	GenerateDesktop();
}

void LWMgr::GenerateDesktop()
{
	HDECOLOR hColor;
	LWStack *pStack;

	hColor = m_pClient->CreateColor(1.0f,0.0f,1.0f,DFALSE);

	m_pClient->FillRect(m_hDesktop,DNULL,hColor);

	pStack = m_pStack;

	int total, drawn;

	total = drawn = 0;

	while(pStack) {
		total++;
		if (pStack->m_pWindow->GetFlags() & LW_VISIBLE) {
			pStack->m_pWindow->Paint(m_hDesktop);
			drawn++;
		}
		pStack = pStack->m_pNext;
	}

	m_bNeedRedraw = DTRUE;
}

void LWMgr::DeleteWindow(LithiumWindow *pWindow)
{
	DeleteFromStack(pWindow);
	pWindow->Destroy();
	delete pWindow;

	GenerateDesktop();
}

void LWMgr::MoveToTop(LithiumWindow *pWindow)
{
	DeleteFromStack(pWindow);

	LWStack *pStack;

	pStack = m_pStack;

	DDWORD dwFlags;

	while(pStack) {
		if (pStack->m_pWindow->GetFlags() & LW_ACTIVE) {
			dwFlags = pStack->m_pWindow->GetFlags();
			dwFlags &= ~LW_ACTIVE;
			pStack->m_pWindow->SetFlags(dwFlags);
			pStack->m_pWindow->PaintBorder();
		}
		pStack = pStack->m_pNext;
	}

	dwFlags = pWindow->GetFlags();
	pWindow->SetFlags(dwFlags | LW_ACTIVE);

	AddToStack(pWindow);
	pWindow->PaintBorder();

	GenerateDesktop();
}

void LWMgr::Render()
{
	if (IsActive()) {
		HDECOLOR hColor;

		if (m_bNeedRedraw) {

			m_pClient->DrawSurfaceToSurface(m_hFinal, m_hDesktop, DNULL, 0, 0);

			m_Mouse.Render(m_hFinal,m_byMouseCursor,DNULL);

			m_bNeedRedraw = DFALSE;
		}

		hColor = m_pClient->CreateColor(1.0f,0.0f,1.0f,DTRUE);

		m_pClient->DrawSurfaceToSurfaceTransparent(
			m_pClient->GetScreenSurface(),
			m_hFinal, DNULL, 0, 0, hColor);

		m_pClient->DeleteColor(hColor);
	}
}	

LWStack *LWMgr::GetWindowFromLocation(int x, int y)
{
	LWStack *pStack, *fStack;
	LithiumWindow *lwin;

	fStack = DNULL;

	pStack = m_pStack;

	while(pStack) {
		lwin = pStack->m_pWindow;

		if ((lwin->GetX() <= x) && (lwin->GetY() <= y) &&
			((lwin->GetX() + lwin->GetWidth()) >= x) &&
			((lwin->GetY() + lwin->GetHeight()) >= y))
			fStack = pStack;

		pStack = pStack->m_pNext;
	}

	return fStack;
}

void LWMgr::HandleMouse(DFLOAT *axis)
{
	m_pClient->GetAxisOffsets(axis);

	if (IsActive()) {
		int x, y;

		x = (int)axis[0];
		y = (int)axis[1];

		if (x || y) m_bNeedRedraw = DTRUE;

		LWStack *pStack = GetWindowFromLocation(m_Mouse.GetXPos(), m_Mouse.GetYPos());

		if (pStack ? !(pStack->m_pWindow->GetFlags() & LW_ACTIVE) : 0)
			pStack = DNULL;

		int winX, winY, winW, winH;

		if (pStack) {
			winX = pStack->m_pWindow->GetX();
			winY = pStack->m_pWindow->GetY();
			winW = pStack->m_pWindow->GetWidth();
			winH = pStack->m_pWindow->GetHeight();
		}

		if (m_pClient->IsCommandOn(COMMAND_MOUSEBUTTON0)) {
			switch (m_iMode) {
				case 0:
					m_Mouse.SetXPos(m_Mouse.GetXPos() + x);
					m_Mouse.SetYPos(m_Mouse.GetYPos() + y);
					if (pStack && (x || y))
						pStack->m_pWindow->MouseDrag(m_Mouse.GetXPos() - winX, m_Mouse.GetYPos() - winY,
							x, y);
					break;
				case 1:
					if (pStack) {
						if (pStack->m_pWindow->GetFlags() & LW_MOVEABLE)
							if (((winX + x) >= 0) && ((winX + x + winW) <= 640)) {
								m_Mouse.SetXPos(m_Mouse.GetXPos() + x);
								winX += x;
							}
							if (((winY + y) >= 0) && ((winY + y + winH) <= 480)) {
								m_Mouse.SetYPos(m_Mouse.GetYPos() + y);
								winY += y;
							}

						pStack->m_pWindow->Move(winX, winY);
					}
					break;
				case 2:
					if (pStack) {
						if (pStack->m_pWindow->GetFlags() & LW_RESIZABLE)
							if (((winX + x + winW) <= 640) && ((winY + y + winH) <= 480)) {
								m_Mouse.SetYPos(m_Mouse.GetYPos() + y);
								pStack->m_pWindow->Resize(winW, winH + y);
							}
					}
					break;
				case 3:
					if (pStack) {
						if (pStack->m_pWindow->GetFlags() & LW_RESIZABLE)
							if (m_Mouse.GetXPos() <= (winX + 7)) {
								if (((winX + x) >= 0) && ((winX + x + winW) <= 640)) {
									m_Mouse.SetXPos(m_Mouse.GetXPos() + x);
									pStack->m_pWindow->Move(winX + x, winY);
									pStack->m_pWindow->Resize(winW - x, winH);
								}
							} else {
								if (((winX + x) >= 0) && ((winX + x + winW) <= 640)) {
									m_Mouse.SetXPos(m_Mouse.GetXPos() + x);
									pStack->m_pWindow->Resize(winW + x, winH);
								}						
							}
					}
					break;
			}

			if (pStack) {
				GenerateDesktop();
			}

		} else {
			m_Mouse.SetXPos(m_Mouse.GetXPos() + x);
			m_Mouse.SetYPos(m_Mouse.GetYPos() + y);
		}

		m_byMouseCursor = LMPTR_POINTER;

		if (pStack) {

			winX = pStack->m_pWindow->GetX();
			winY = pStack->m_pWindow->GetY();
			winW = pStack->m_pWindow->GetWidth();
			winH = pStack->m_pWindow->GetHeight();

			if ((m_Mouse.GetXPos() >= winX) && (m_Mouse.GetYPos() >= winY) &&
				(m_Mouse.GetXPos() <= (winX + winW)) && (m_Mouse.GetYPos() <= (winY + 6))) {
				m_iMode = 1;
				m_byMouseCursor = LMPTR_MOVE;
			} else
			if ((m_Mouse.GetXPos() >= winX) && (m_Mouse.GetYPos() >= (winY + winH - 6)) &&
				(m_Mouse.GetXPos() <= (winX + winW)) && (m_Mouse.GetYPos() <= (winY + winH))) {
				m_iMode = 2;
				m_byMouseCursor = LMPTR_SIZEV;
			} else
			if ((((m_Mouse.GetXPos() >= winX) && (m_Mouse.GetXPos() <= (winX + 6))) ||
			    ((m_Mouse.GetXPos() >= (winX + winW - 6)) && (m_Mouse.GetXPos() <= (winX + winW)))) &&
				((m_Mouse.GetYPos() >= winY) && (m_Mouse.GetYPos() <= (winY + winH)))) {
				m_iMode = 3;
				m_byMouseCursor = LMPTR_SIZEH;
			} else m_iMode = 0;
		}

//		axis[0] = 0; axis[1] = 0; axis[2] = 0;
	}
}

void LWMgr::HandleCommand(int command)
{
	LWStack *pStack = GetWindowFromLocation(m_Mouse.GetXPos(), m_Mouse.GetYPos());

	if (command == COMMAND_MOUSEBUTTON0) {

		if (pStack) {
			if (!(pStack->m_pWindow->GetFlags() & LW_ACTIVE)) {
				MoveToTop(pStack->m_pWindow);
				pStack = m_pStack;
			} else {
				if (!m_iMode)
					pStack->m_pWindow->MouseClick(m_Mouse.GetXPos() - pStack->m_pWindow->GetX(),
						m_Mouse.GetYPos() - pStack->m_pWindow->GetY());
			}

			GenerateDesktop();
		}
	}
}