#include "lithium.h"
#include "lt_bitmapwindow.h"

LTBitmapWindow::LTBitmapWindow()
{
	m_bTransparent = DFALSE;

	LithiumWindow::LithiumWindow();
}

LTBitmapWindow::~LTBitmapWindow()
{
	if (m_bInited)
		Destroy();
}

DRESULT LTBitmapWindow::Initialize(int x, int y, int width, int height,
							const char *title, DDWORD dwFlags, LWMgr *pLWMgr, DBOOL bTransparent)
{
	if (!pLWMgr) return LERR_NO_LWMGR;

	m_bTransparent = bTransparent;

	m_iXPos = x;
	m_iYPos = y;
	m_iHeight = height;
	m_iWidth = width;

	m_dwFlags = dwFlags;

	m_dwFlags &= ~LW_RESIZABLE;
	m_dwFlags &= ~LW_MOVEABLE;

	m_pLWMgr = pLWMgr;

	m_hSurface = pLWMgr->GetClient()->CreateSurfaceFromBitmap((char *)title);

	m_bInited = DTRUE;

	return LERR_NONE;
}

DRESULT LTBitmapWindow::PaintBorder()
{
	return LERR_NONE;
}

DRESULT LTBitmapWindow::Paint(HSURFACE hSurf)
{
	if (m_bTransparent) {
		HDECOLOR hCol;

		hCol = m_pLWMgr->GetClient()->CreateColor(1,0,1,DTRUE);

		m_pLWMgr->GetClient()->DrawSurfaceToSurfaceTransparent(
		  hSurf,
		  m_hSurface, DNULL,
		  m_iXPos, m_iYPos,
		  hCol);

		m_pLWMgr->GetClient()->DeleteColor(hCol);

		return LERR_NONE;

	} else {
		return(LithiumWindow::Paint(hSurf));
	}

}