// Node.cpp: implementation of the CNode class.
//
//////////////////////////////////////////////////////////////////////
#include <string.h>
#include <malloc.h>
#include "stdafx.h"
#include "Node.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNode::CNode()
{
	m_bEOL = m_bBOL = DFALSE;
	m_sPlayerName = NULL;
	m_nId = 0;
	m_nTicks = 0;
	Next = Prev = NULL;
}

CNode::~CNode()
{
	if(m_sPlayerName != NULL)
		free(m_sPlayerName);
}

void CNode::SetPlayerName(const char *NewName)
{
	if(m_sPlayerName != NULL)
		free(m_sPlayerName);

	m_sPlayerName = (char *) malloc(strlen(NewName));
	strcpy(m_sPlayerName, NewName);

}

CName::CName()
{
	m_bEOL = m_bBOL = DFALSE;
	m_sPlayerName = NULL;
	Next = Prev = NULL;
}

CName::~CName()
{
	if(m_sPlayerName != NULL)
		free(m_sPlayerName);
}

void CName::SetName(const char *NewName)
{
	if(m_sPlayerName != NULL)
		free(m_sPlayerName);

	m_sPlayerName = (char *) malloc(strlen(NewName));
	strcpy(m_sPlayerName, NewName);

}
