// List.cpp: implementation of the CList class.
//
//////////////////////////////////////////////////////////////////////
#include <malloc.h>
#include "stdafx.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CKickList::CKickList()
{
	ListHead = new CNode;
	ListTail = new CNode;

	ListHead->Next = ListTail;
	ListTail->Prev = ListHead;

	ListTail->m_bEOL = DTRUE;
	ListHead->m_bBOL = DTRUE;
	m_CurrentNode = ListHead;
	m_bIsEmpty = DTRUE;
	m_pServer = NULL;
}

CKickList::~CKickList()
{
	CNode *CurrentNode, *NextNode;
	
	CurrentNode = ListHead;
	while(CurrentNode->EOL() != DTRUE) {
		NextNode = CurrentNode->Next;
		free(CurrentNode);
		CurrentNode = NextNode;
	}
	free(ListTail);
}

void CKickList::AddNode(char *NewName, DWORD nPlayerId)
{
	CNode *CurrentNode, *NextNode;

	CurrentNode = ListHead->Next;
	while(CurrentNode->EOL() != DTRUE) {
		NextNode = CurrentNode->Next;
		if(strcmp(CurrentNode->PlayerName(), NewName) == 0)
			return;
		CurrentNode = NextNode;
	}

	CNode *NewClient = new CNode;

	NewClient->SetPlayerName(NewName);
	NewClient->m_nId = nPlayerId;
	NewClient->Next = ListTail;
	NewClient->Prev = ListTail->Prev;
	NewClient->Prev->Next = NewClient;
	ListTail->Prev = NewClient;
	m_bIsEmpty = DFALSE;
}

void CKickList::KickPlayers(int nTime)
{
	CNode *CurrentNode, *NextNode;
	
	if(m_bIsEmpty || m_pServer == NULL) {
		return;
	}

	CurrentNode = ListHead;
	while(CurrentNode->EOL() != DTRUE) {
		NextNode = CurrentNode->Next;
		if(CurrentNode->BOL() != DTRUE) {
			if(CurrentNode->m_nTicks >= KICK_TIME ) {
				m_pServer->BootClient(CurrentNode->m_nId);
				DeleteNode(CurrentNode);
			}
			else
				CurrentNode->m_nTicks += nTime;
		}

		CurrentNode = NextNode;
	}
}

void CKickList::DeleteNode(CNode *ThisNode)
{
	ThisNode->Prev->Next = ThisNode->Next;
	ThisNode->Next->Prev = ThisNode->Prev;
	if(ListHead->Next->EOL() == DTRUE)
		m_bIsEmpty = DTRUE;
	
	delete ThisNode;
}

void CKickList::ActiveServer(ServerInterface *Server)
{
	m_pServer = Server;
}

void CKickList::PurgeList()
{
	CNode *CurrentNode, *NextNode;

	CurrentNode=ListHead->Next;
	while(CurrentNode->EOL() != DTRUE) {
		NextNode = CurrentNode->Next;
		DeleteNode(CurrentNode);
		CurrentNode = NextNode;
	}
}

DBOOL CKickList::FindPlayer(char *Name)
{
	CNode *Temp;
	DBOOL bFound;

	bFound = DFALSE;
	Temp = ListHead;
	while(Temp->m_bEOL != DTRUE && !bFound) {
		Temp = Temp->Next;
		if(strcmp(Temp->PlayerName(), Name) == 0)
			bFound = DTRUE;
		else
			bFound = DFALSE;
	}
	return bFound;

}

CPlayerList::CPlayerList()
{
	ListHead = new CName;
	ListTail = new CName;

	ListHead->m_bBOL = DTRUE;
	ListHead->Next = ListTail;

	ListTail->m_bEOL = DTRUE;
	ListTail->Prev = ListHead;
	m_bIsEmpty = DTRUE;

}

CPlayerList::~CPlayerList()
{
	CName *CurrentNode, *NextNode;
	
	CurrentNode = ListHead;
	while(CurrentNode->m_bEOL != DTRUE) {
		NextNode = CurrentNode->Next;
		free(CurrentNode);
		CurrentNode = NextNode;
	}
	free(ListTail);
}
void CPlayerList::AddNode(char *NewName)
{	CName *CurrentNode, *NextNode;

	CurrentNode = ListHead->Next;
	while(CurrentNode->m_bEOL != DTRUE) {
		NextNode = CurrentNode->Next;
		if(strcmp(CurrentNode->PlayerName(), NewName) == 0)
			return;
		CurrentNode = NextNode;
	}

	CName *NewPlayer = new CName;

	NewPlayer->SetName(NewName);
	NewPlayer->Next = ListTail;
	NewPlayer->Prev = ListTail->Prev;
	ListTail->Prev->Next = NewPlayer;
	ListTail->Prev = NewPlayer;
	m_bIsEmpty = DFALSE;
}

void CPlayerList::DeleteNode(CName *ThisName)
{
	ThisName->Prev->Next = ThisName->Next;
	ThisName->Next->Prev = ThisName->Prev;
	if(ListHead->Next->m_bEOL == DTRUE)
		m_bIsEmpty = DTRUE;
	
	delete ThisName;
}

void CPlayerList::DeletePlayer(char *Name)
{
	CName *Temp;
	DBOOL bFound;

	Temp = ListHead->Next;
	bFound = DFALSE;
	while(Temp->m_bEOL != DTRUE && bFound == DFALSE) {
		if(strcmp(Temp->PlayerName(), Name) == 0)
			bFound = DTRUE;
		else
			Temp = Temp->Next;
	}
	if(bFound)
		DeleteNode(Temp);
}

void CPlayerList::PurgeList()
{
	CName *CurrentNode, *NextNode;

	CurrentNode=ListHead->Next;
	while(CurrentNode->m_bEOL != DTRUE) {
		NextNode = CurrentNode->Next;
		DeleteNode(CurrentNode);
		CurrentNode = NextNode;
	}
}

DBOOL CPlayerList::CreateFromFile(const char *FilePath)
{
	ifstream inBanFile;
	char BannedName[MAX_PNAME_SIZE];

	inBanFile.open(FilePath, ios::in);
	if(!inBanFile)
		return DFALSE;

	
	while(inBanFile >> BannedName)
		AddNode(BannedName);

	inBanFile.close();
	return DTRUE;

}

DBOOL CPlayerList::FindPlayer(char *Name)
{
	CName *Temp;
	DBOOL bFound;

	bFound = DFALSE;
	Temp = ListHead;
	while(Temp->m_bEOL != DTRUE && !bFound) {
		Temp = Temp->Next;
		if(strcmp(Temp->PlayerName(), Name) == 0)
			bFound = DTRUE;
		else
			bFound = DFALSE;
	}
	return bFound;

}
