/****************************************************************************
;
;	 MODULE:		CDSTUFF (.CPP)
;
;	PURPOSE:		CD-ROM Functions
;
;	HISTORY:		06/26/97 [blg] This file was created
;
;	COMMENT:		Copyright (c) 1997, Monolith Productions Inc.
;
****************************************************************************/


// Includes...

#include "stdafx.h"
#include "cdstuff.h"
#include "resource.h"


// Statics...

char	s_chDrive = 0;


// Externs...

extern	HINSTANCE	g_hInst;


// Functions...

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CD_VerifyGame
//
//	PURPOSE:	Verifies that the Game CD is in the drive
//
// ----------------------------------------------------------------------- //

BOOL CD_VerifyGame(HWND hWnd)
{
	// Check if the game CD is already in the drive...

	{
		CWaitCursor wc;

		if (CD_ExistGame())
		{
			return(TRUE);
		}
	}


	// Ask the user to insert the game CD...

	BOOL bContinue = TRUE;

	while (bContinue)
	{
		char sMsg[128];
		if (!LoadString(g_hInst, IDS_INSERTCD, sMsg, 124))
		{
			strcpy(sMsg, "Please insert the game CD-ROM into the drive.");
		}

		char sTitle[64];
		if (!LoadString(g_hInst, IDS_APPNAME, sTitle, 62))
		{
			strcpy(sTitle, "Shogo");
		}

		int nRet = MessageBox(hWnd, sMsg, sTitle, MB_OKCANCEL | MB_ICONEXCLAMATION);

		if (nRet == IDOK)
		{
			CWaitCursor wc;
			if (CD_ExistGame()) return(TRUE);
			Sleep(1000);
			if (CD_ExistGame()) return(TRUE);
		}
		else
		{
			return(FALSE);
		}
	}


	// If we get here, we couldn't verify the CD...

	return(FALSE);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CD_ExistGame
//
//	PURPOSE:	Determines if the Claw CD exists
//
// ----------------------------------------------------------------------- //

BOOL CD_ExistGame()
{
	// Use the new function to search across multiple drives...

	char chDrive = CD_GetDriveLetterWithGame();
	return(chDrive != 0);


	// If we get here, it's the claw cd...

	return(TRUE);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CD_ExistFile
//
//	PURPOSE:	Determines if the given file exists
//
// ----------------------------------------------------------------------- //

BOOL CD_ExistFile(const char* sFile)
{
	if (!sFile) return(FALSE);
	if (sFile[0] == '\0') return(FALSE);

	OFSTRUCT ofs;

	HFILE hFile = OpenFile(sFile, &ofs, OF_EXIST);

	return(hFile != HFILE_ERROR);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CD_GetDriveLetter
//
//	PURPOSE:	Gets a CD ROM drive letter
//
// ----------------------------------------------------------------------- //

char CD_GetDriveLetter()
{
	// Try to find a CD ROM drive...

	char sDir[256];
	GetCurrentDirectory(255, sDir);
	sDir[3] = '\0';

	if (GetDriveType(sDir) == DRIVE_CDROM)
	{
		return(sDir[0]);
	}
	else
	{
		char cdDrive = 'A';

		for (int i = 0; i < 26; i++)
		{
			sprintf(sDir, "%c:\\", cdDrive);
			
			if (GetDriveType(sDir) == DRIVE_CDROM)
			{
				return(cdDrive);
			}

			cdDrive++;
		}
	}


	// If we get here, we didn't find one...

	return(0);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CD_GetDriveLetterWithGame
//
//	PURPOSE:	Gets the CD ROM drive letter with the game on it
//
// ----------------------------------------------------------------------- //

char CD_GetDriveLetterWithGame()
{
	// Check if we've already found the cd-rom drive...

	if (s_chDrive != 0)
	{
		return(s_chDrive);
	}


	// Try to find a CD ROM drive with the game EXE on it...

	char chDrive   = 'A';
	char sDir[256];

	while (chDrive <= 'Z')
	{
		sprintf(sDir, "%c:\\", chDrive);
			
		if (GetDriveType(sDir) == DRIVE_CDROM)
		{
			char sBuf[256];
			sprintf(sBuf, "%c:\\GAME\\SHOGO.EXE", chDrive);

			if (CD_ExistFile(sBuf))
			{
				s_chDrive = chDrive;
				return(chDrive);
			}
		}

		chDrive++;
	}


	// If we get here, we didn't find one...

	return(0);
}


