// Targetting Reticle Heads-Up Display
//
// By: Allan "Geist" Campbell
//		Greyshades
//
// December 14, 1998
// 
// Details:
//		An overlay targetting reticle for targets in the 3D world
//     
//     
// Modifications:
//		Dec 1998 LAC Adapted pseudo-code from Monolith (thanks guys!) 
//					 to current Shogo (v2.1) architecture.
//
// Developer list:
//		LAC		L. Allan Campbell (Geist)
//

// FIXME: Term/naming conventions changes.
//        Right now, animations<->modes... PICK A STANDARD NAME, geez.

#ifndef __CRETICLE_H
#define __CRETICLE_H

#include <BASEDEFS_DE.H>
#include <CPP_ClientShell_de.h>

#define	RETICLE_MAX_ANIMS		5		// Max. number of animations
#define	RETICLE_MAX_FRAMES		10		// Max. number of frames per each anim

// added because I cannot find an equivalent yet.
#define KEYPAUSERATE			0.5		// forced delay between activation keypresses


typedef struct
{
	DDWORD	Width, Height;
} SurfaceStats_t;

typedef struct
{
	DDWORD	FrameWidth, FrameHeight;
	DBYTE	NumFrames;
	DFLOAT	FrameDuration[RETICLE_MAX_FRAMES];
} Anim_t;


class cReticle
{
	//Object Properties
	HSURFACE m_hPrimaryDisplay;				// handle to screen surface
	HSURFACE m_hReticleOverlay;				// handle to reticle overlay pic

	SurfaceStats_t	m_DisplayStats, 
					m_OverlayStats;

	DBYTE		m_nNumAnims;				// number of modes/animations (1..n)
	Anim_t		m_Anims[RETICLE_MAX_ANIMS];	// anim info

	DBYTE		m_nCurrentAnim;				// current animation sequence (mode)
	DBYTE		m_nCurrentFrame;			// current animation frame (0..n-1)

	DFLOAT		m_fAnimTimer;				// used to keep track of anim frame advances

	DVector		m_vTargetPos;				// holds the 3D point you're tracking

	// The magic function -- transforms 3D to 2D
	DBOOL WorldToScreen(DVector &World, int &nScreenX, int &nScreenY, HLOCALOBJ hCamera);

  public:
	// Method Definitions
	cReticle();										//Default Constructor

	DBOOL Init(char *szFilename,					//Initialize the HUD
			   HSURFACE hDisplaySurf,
			   DBYTE nNumAnims, Anim_t* pAnims);

	DRESULT Render();								//Render the HUD to the Screen

	void	SetTargetPos(DVector *NewPos)	{ m_vTargetPos = *NewPos; }
	DBYTE	SetMode(DBYTE newmode);
	DBYTE	PrevMode();
	DBYTE	NextMode();
};

#endif
