/****************************************************************************
;
;	 MODULE:		MidiMgr (.H)
;
;	PURPOSE:		Midi Music Manager Class
;
;	HISTORY:		01/20/96  [blg]  This file was created
;
;	COMMENT:		Copyright (c) 1995, MONOLITH, Inc.
;
****************************************************************************/


#ifndef _MIDIMGR_H_
#define _MIDIMGR_H_


// Includes...

#include "stdafx.h"
#include "..\incs\midi.h"
//#include "..\midimgr\midi.h"


// Libs...

#pragma comment (lib, "midimgr.lib")

// Classes...

class CMidiMgr
{
	// Member functions...

public:
	CMidiMgr();
	~CMidiMgr();

	BOOL				Init(HINSTANCE hInst, HWND hWnd, BOOL bForceNoMidi = FALSE);
	void				Term();

	BOOL				IsValid() { return(m_hWnd != NULL); }

	CMidi*				AddMidi(char* sFile, char* sName = NULL);
	CMidi*				AddMidi(BYTE* pData, DWORD length, char* sName = NULL);

	BOOL				PlayMidi(char* sFile, BOOL bLoop = FALSE, char* sName = NULL);
	BOOL				PlayMidi(BYTE* pData, DWORD length, BOOL bLoop = FALSE, char* sName = NULL);

	BOOL				Play(char* sName, BOOL bLoop = FALSE);
	BOOL				Play(BOOL bLoop = FALSE);
	BOOL				Pause();
	BOOL				Resume(BOOL bForce = FALSE);
	BOOL				Stop();
	BOOL				Replay();
	BOOL				IsPlaying();

	int					GetMgrVersion() { return(1); }
	int					GetMasterVolume() { return(100); }
	int					GetTempo() { return(100); }
	int					GetVolume() { return(100); }
	int					GetNumMidis() { return(m_collMidis.GetSize()); }
	CMidi*				GetCurMidi() { return(m_pCurMidi); }

	BOOL				SetTempo(int nPercent, DWORD timeRamp = 0) { return(TRUE); }
	BOOL				SetVolume(int nPercent, DWORD timeRamp = 0) { return(TRUE); }
	BOOL				SetMasterVolume(int nPercent) { return(TRUE); }
	BOOL				SetLooping(BOOL bLoop);
	BOOL				SetCurMidi(CMidi* pMidi) { m_pCurMidi = pMidi; return(TRUE); }
	BOOL				SetCurMidi(const char* sName);

	BOOL				IsMidiAvailable() { return(m_bHaveMidi); }
	void				SetMidiAvailable(BOOL b) { m_bHaveMidi = b; }

	CMidi*				FindMidi(const char* sName);
	CMidi*				GetMidi(const char* sName) { return(FindMidi(sName)); }
	BOOL				ExistMidi(const char* sName) { return(!!FindMidi(sName)); }

	void				RemoveAll();

	void				OnMciNotify(UINT wParam, LONG lParam);

private:
	void				AddMidi(CMidi* pMidi);
	void				StopCur();

	// Member variables...

private:
	CObArray			m_collMidis;
	CMapStringToOb		m_mapMidis;
	CMidi*				m_pCurMidi;
	HWND				m_hWnd;
	HINSTANCE			m_hInst;
	BOOL				m_bHaveMidi;
};


// Inlines...

inline CMidiMgr::CMidiMgr()
{
	m_pCurMidi = NULL;
	m_hWnd     = NULL;
}

inline CMidiMgr::~CMidiMgr()
{
	Term();
}

inline CMidiMgr::IsPlaying()
{
	if (m_pCurMidi)
	{
		return(m_pCurMidi->IsPlaying());
	}
	else
	{
		return(FALSE);
	}
}

inline BOOL CMidiMgr::SetLooping(BOOL bLoop)
{
	if (!m_pCurMidi) return(FALSE);
	m_pCurMidi->SetLooping(bLoop);
	return(TRUE);
}

inline BOOL CMidiMgr::SetCurMidi(const char* sName)
{
	CMidi* pMidi = FindMidi(sName);
	if (!pMidi) return(FALSE);
	SetCurMidi(pMidi);
	return(TRUE);
}


// EOF...

#endif

