/****************************************************************************
;
;	 MODULE:		Midi (.H)
;
;	PURPOSE:		Midi Object Class
;
;	HISTORY:		01/20/96  [blg]  This file was created
;
;	COMMENT:		Copyright (c) 1996, Monolith Productions Inc.
;
****************************************************************************/


#ifndef _MIDI_H_
#define _MIDI_H_


// Classes...

class CMidi : public CObject
{
	// Member functions...

public:
	CMidi();
	virtual	~CMidi();

	virtual	BOOL		Init(char* sFile, char* sName);
	virtual	BOOL		Init(BYTE* pData, DWORD length, char* sName);
	virtual	void		Term();

	virtual	BOOL		IsValid() { return(m_sName[0] != '\0'); }

	virtual	BOOL		Play(HWND hWnd, BOOL bLoop = FALSE);
	virtual	BOOL		Pause();
	virtual	BOOL		Resume(BOOL bForce = FALSE);
	virtual	BOOL		Stop();
	virtual	BOOL		Replay();

	char*				GetName() { return(m_sName); }
	int					GetTempo() { return(100); }
	int					GetVolume() { return(100); }

	BOOL				SetTempo(int nPercent) { return(TRUE); }
	BOOL				SetVolume(int nPercent) { return(TRUE); }
	void				SetLooping(BOOL bLoop) { m_bLoop = bLoop; }

	BOOL				IsLooping() { return(m_bLoop); }
	BOOL				IsPlaying() { return(m_bPlaying); }
	BOOL				IsPaused() { return(m_nPauseCount > 0); }

	virtual	BOOL		OnUpdate() { return(TRUE); }

	static	void		SetInst(HINSTANCE hInst) { s_hInst = hInst; }


private:
	virtual	BOOL		InitRes(char* sRes, char* sName);


	// Member variables...

private:
	char				m_sName[64];
	char				m_sFilePath[256];
	int					m_nPauseCount;
	BOOL				m_bTempFile;
	BOOL				m_bLoop;
	BOOL				m_bPlaying;
	HWND				m_hWnd;

	static	HINSTANCE	s_hInst;
	static	int			s_count;
};


// Inlines...

inline CMidi::CMidi()
{
	m_sName[0]     = '\0';
	m_sFilePath[0] = '\0';
	m_nPauseCount  = 0;
	m_bTempFile    = FALSE;
	m_bLoop        = FALSE;
	m_bPlaying     = FALSE;
	m_hWnd         = NULL;
}

inline CMidi::~CMidi()
{
	Term();
}


// EOF...

#endif






