// *********************************************************************** //
//
//	MODULE:		Pcx (.H)
//
//	PURPOSE:	Implements the Pcx class for Diner
//
//	HISTORY:	[blg]	06/11/94	This file was created
//
// *********************************************************************** //


#ifndef	_PCX_H_
#define _PCX_H_


// Includes...

#include <stdlib.h>
#include "mtypes.h"


// Externs...

class CRezDir;


// Constants...

const	kPaletteInfoSize	= 768;


// Structures...
#pragma pack(1)
typedef struct pcxRgb_struct {

	BYTE	red;
	BYTE	green;
	BYTE	blue;

} SH_PCXRGB;

typedef struct pcxHdr_struct {

	char 			manufacturer;
	char 			version;
	char 			encoding;
	unsigned char	bitsPerPixel;
  short     x0, y0, x1, y1;
  short     xDPI, yDPI;
  SH_PCXRGB    pal16[16];
	char 			reserved;
	char 			planes;
  short     bytesPerLine;
  short     paletteInfo;
  short     xScreenSize, yScreenSize;
	char 			filler[54];

} SH_PCXHDR;
#pragma pack()

#define HPBYTE BYTE*
#define LPBYTE BYTE*
#define DWORD unsigned long

// Classes..

class CPcx {
// Member functions...

public:
	virtual		~CPcx();
	CPcx();

//  virtual   BOOL  Init(HPBYTE pGcdData, DWORD packedSize = 0L, BOOL bNewMem = TRUE, CPoint* pPoint = NULL);
  virtual   BOOL  Init(const char* filename);
  virtual   BOOL  Init(CRezDir* pRezDir, const char* filename);
//  virtual   BOOL  Init(CString filename);

	DWORD		Free();
	void		Clear();

  pcxRgb_struct* Palette(); // returns a pointer to the palette array

	LPBYTE		UnpackPixels() const;
	void		UnpackPixels(LPBYTE pBytes) const;
  BOOL    FreePixels(LPBYTE pBytes);

  BOOL   UnpackPixelsBottomUp(HPBYTE pRed, HPBYTE pGreen, HPBYTE pBlue) const;
  BOOL   UnpackPixelsBottomUp(HPBYTE pBytes) const;
  BOOL   UnpackPixelsTopDown(HPBYTE pRed, HPBYTE pGreen, HPBYTE pBlue) const;
  BOOL   UnpackPixelsTopDown(HPBYTE pBytes, UINT32 nStride = 0) const;

	BYTE		GetPixelAt(const int x, const int y) const;
//  BYTE    GetPixelAt(const CPoint& pt) const;
	int			GetWidth() const { return(m_width); };
	int			GetHeight() const { return(m_height); };

  virtual   BOOL    IsValid() const { return(!!m_pPackedPixels && !!m_lineOffsets); }

	static		void		CopyHugeMem(HPBYTE pDst, HPBYTE pSrc, DWORD dwCount);

  int NumPlanes();

	// Member variables...

protected:
	SH_PCXHDR	m_hdr;
	int			m_width;
	int			m_height;
	int			m_widthBytes;
	HPBYTE		m_pPackedPixels;
	DWORD*		m_lineOffsets;
  pcxRgb_struct* ThePalette;
};


#endif


