// ----------------------------------------------------------------------- //
//
// MODULE  : ModelNodes.h
//
// PURPOSE : Model node related utility functions
//
// CREATED : 6/26/98
//
// ----------------------------------------------------------------------- //

#ifndef __MODEL_NODES_H__
#define __MODEL_NODES_H__

#include "ModelIds.h"

enum NodeType { NT_HEAD, NT_LARM, NT_RARM, NT_LLEG, NT_RLEG, NT_PELVIS, NT_TORSO };
		

static char* s_AVCModelNodes[] =
{
	"torso_bars",
	"torso",
	"right_armu_torso",
	"right_armu_shoulder",
	"right_armu",
	"right_arml",
	"right_arml_hand",
	"pelvis_3",
	"pelvis_2",
	"pelvis",
	"right_legu",
	"right_legl",
	"right_legl_1",
	"right_legl_2",
	"right_legl_foot",
	"left_legu",
	"left_legl",
	"left_legl_2",
	"left_legl_1",
	"left_legl_foot",
	"left_armu_torso",
	"left_armu_shoulder",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"head"
};

static char* s_AkumaModelNodes[] =
{
	"pelvis",
	"torso_1",
	"torso_2",
	"right_armu_1",
	"right_armu_2",
	"right_arml_1",
	"right_arml_2",
	"right_armu_3",
	"torso_3",
	"torso_4",
	"head_1",
	"head_2",
	"head_3",
	"head_4",
	"head_5",
	"head_6",
	"head_7",
	"head_8",
	"head_9",
	"torso_5",
	"torso_7",
	"left_armu_1",
	"left_armu_2",
	"left_arml_1",
	"left_arml_2",
	"left_armu_3",
	"torso_6",
	"torso_8",
	"torso_9",
	"torso_10",
	"torso_11",
	"torso_12",
	"torso_13",
	"torso_14",
	"right_legu_1",
	"right_legu_2",
	"right_legl_1",
	"right_legl_2",
	"right_legl_3",
	"right_legl_4",
	"right_legl_5",
	"right_legl_6",
	"right_legl_7",
	"left_legu_1",
	"left_legu_2",
	"left_legl_1",
	"left_legl_2",
	"left_legl_3",
	"left_legl_4",
	"left_legl_5",
	"left_legl_6",
	"left_legl_7"
};

static char* s_Andra5ModelNodes[] =
{
	"pelvis_1",
	"torso",
	"torso_2",
	"left_armu_1",
	"left_armu_2",
	"left_arml",
	"left_arml_hand",
	"torso_1",
	"right_armu_1",
	"right_armu_2",
	"right_arml",
	"right_arml_hand",
	"pelvis",
	"left_legu_1",
	"left_legu_2",
	"left_legl_1",
	"left_legl_foot",
	"right_legu_1",
	"right_legu_2",
	"right_legl_1",
	"right_legl_foot",
	"head"
};

static char* s_Andra10ModelNodes[] =
{
	"torso",
	"pelvis",
	"left_legu",
	"left_legu_1",
	"left_legl",
	"left_legl_heel",
	"left_legl_foot",
	"right_legu",
	"right_legu_1",
	"right_legl",
	"right_legl_heel",
	"right_legl_foot",
	"torso_2",
	"right_armu_shoulder",
	"right_armu",
	"right_arml",
	"right_arml_hand",
	"head",
	"torso_1",
	"left_armu_shoulder",
	"left_armu",
	"left_arml",
	"left_arml_shield",
	"left_arml_hand"
};

static char* s_AssassinModelNodes[] =
{
	"head",
	"pelvis",
	"left_legu",
	"left_legl",
	"left_legl_foot",
	"right_legu",
	"right_legl",
	"right_legl_foot",
	"left_armu_missle",
	"left_armu_wing",
	"left_armu_shoulder",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"left_arml_armshield",
	"left_armu_shldrjnt",
	"left_armu_shoulderwing",
	"left_armu_antannae",
	"right_armu_missle1",
	"right_armu_wing",
	"right_armu_shoulder",
	"right_armu",
	"right_arml",
	"right_arml_hand",
	"right_arml_shield",
	"right_armu_shldjnt",
	"right_armu_shouldershld",
	"right_armu_antennae"
};

static char* s_EnforcerModelNodes[] =
{
	"torso_1",
	"torso_2",
	"pelvis_1",
	"pelvis_2",
	"left_legu_1",
	"left_legu_2",
	"left_legl_1",
	"left_legl_2",
	"left_legl_3",
	"left_legl_shoe",
	"left_legl_4",
	"left_legl_5",
	"left_legl_6",
	"left_legl_7",
	"left_legl_8",
	"right_legu_1",
	"right_legu_2",
	"right_legl_1",
	"right_legl_2",
	"right_legl_3",
	"right_legl_shoe",
	"right_legl_4",
	"right_legl_5",
	"right_legl_6",
	"right_legl_7",
	"right_legl_8",
	"head_2",
	"head_3",
	"head_1",
	"head_4",
	"head_5",
	"head_6",
	"head_7",
	"head_8",
	"left_armu_4",
	"left_armu_5",
	"left_armu_1",
	"left_armu_2",
	"left_armu_3",
	"left_arml_1",
	"left_arml_2",
	"left_arml_3",
	"left_arml_hand",
	"right_armu_1",
	"right_armu_2",
	"right_armu_3",
	"right_armu_4",
	"right_armu_5",
	"right_arml_1",
	"right_arml_2",
	"right_arml_3",
	"right_arml_hand"
};

static char* s_OrdogModelNodes[] =
{
	"torso",
	"right_armu_spike",
	"left_armu_spike_lower",
	"right_armu_shoulder",
	"right_armu",
	"right_arml",
	"right_arml_hand",
	"head",
	"left_armu_shoulder",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"left_armu_spike",
	"left_armu_spike_lower",
	"torso_lower",
	"torso_lower_2",
	"pelvis",
	"right_legu",
	"right_legl",
	"right_legl_foot",
	"right_legu_crotchjoint",
	"left_legu_crotchjoint",
	"left_legu_2",
	"left_legl",
	"left_legl_foot"
};

static char* s_PredatorModelNodes[] =
{
	"torso_upper",
	"torso_lower",
	"pelvis_upper",
	"right_legu_thigh",
	"right_legu_hippack",
	"right_legu_knee",
	"right_legl_shin",
	"right_legl_knee",
	"right_legl_foot1",
	"right_legl_toe",
	"right_legl_heel",
	"pelvis_lower",
	"left_legu_thigh",
	"left_legu_hippack",
	"left_legu_knee",
	"left_legl_shin",
	"left_legl_knee",
	"left_legl_foot",
	"left_legl_toe",
	"left_legl_heel",
	"Torso_rightplate",
	"right_armu_chestlight1",
	"right_armu_chestlight2",
	"Torso_R_thruster_box",
	"torso_R_thruster_box_lid",
	"torso_R_thruster",
	"right_armu_1",
	"right_armu_elbospike",
	"right_arml",
	"right_arml_1",
	"right_arml_wrist",
	"Right_arml_hand",
	"right_armu_3",
	"right_armu_2",
	"head_back",
	"head_right_earbase",
	"head_rightear",
	"head_leftearbase",
	"head_leftear",
	"head_lowervisor",
	"head_neck",
	"head_visor",
	"head_top",
	"head_topvisor",
	"left_armu_chestlight1",
	"left_armu_chestlight2",
	"torso_leftplate",
	"torso_L_thruster_box",
	"torso_L_thruster_panel",
	"torso_L_thruster",
	"left_armu_1",
	"left_armu_elbowspike",
	"left_arml_elbow",
	"left_arml_1",
	"left_arml_wrist",
	"left_arml_hand",
	"left_armu_2",
	"left_armu_3"
};

static char* s_LittleBoyModelNodes[] =
{
	"pelvis_1",
	"torso_1",
	"head_1",
	"head_2",
	"head_3",
	"left_armu_1",
	"left_arml_1",
	"left_arml_2",
	"right_armu_1",
	"right_arml_1",
	"right_arml_2",
	"torso_2",
	"torso_3",
	"torso_4",
	"torso_5",
	"torso_6",
	"left_legu_1",
	"left_legl_1",
	"left_legl_2",
	"right_legu_1",
	"right_legl_1",
	"right_legl_2"
};

static char* s_LittleGirlModelNodes[] =
{
	"torso",
	"head_neck",
	"head",
	"head_hair",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"right_armu",
	"right_arml",
	"right_arml_hand",
	"torso_backpack",
	"torso_backpack1",
	"torso_backpack2",
	"left_armu_strap",
	"right_armu_strap",
	"right_legu_skirt",
	"right_legu",
	"right_legl",
	"right_legl_foot",
	"left_legu_skirt",
	"left_legu",
	"left_legl",
	"left_legl_foot"
};

static char* s_Civilian1ModelNodes[] =
{
	"pelvis_1",
	"torso_1",
	"head_1",
	"head_2",
	"head_3",
	"left_armu_1",
	"left_arml_1",
	"left_arml_2",
	"right_armu_1",
	"right_arml_1",
	"right_arml_2",
	"right_legu_1",
	"right_legl_1",
	"right_legl_2",
	"left_legu",
	"left_legl_1",
	"left_legl_2"
};

static char* s_Civilian1bModelNodes[] =
{
	"pelvis_1",
	"torso_1",
	"left_armu_1",
	"left_arml_1",
	"left_arml_2",
	"torso_2",
	"head_2",
	"head_1",
	"right_armu_1",
	"right_arml_1",
	"right_arml_2",
	"right_legu_1",
	"right_legl_1",
	"right_legl_2",
	"left_legu_1",
	"left_legl_1",
	"left_legl_2"
};

static char* s_Civilian2ModelNodes[] =
{
	"pelvis_1",
	"torso_1",
	"head_1",
	"head_2",
	"head_3",
	"right_armu_1",
	"right_arml_1",
	"right_arml_2",
	"left_armu_1",
	"left_arml_1",
	"left_arml_2",
	"right_legu_1",
	"right_legl_1",
	"right_legl_2",
	"left_legu_1",
	"left_legl_1",
	"left_legl_2"
};

static char* s_RakshaModelNodes[] =
{
	"torso",
	"pelvis",
	"left_legu",
	"left_legl",
	"left_legl_foot",
	"right_legu",
	"right_legl",
	"right_legl_foot",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"head",
	"right_armu",
	"right_arml",
	"right_arml_hand"
};

static char* s_OfficerModelNodes[] =
{
	"pelvis",
	"left_legu",
	"left_legl",
	"left_legl_foot",
	"pelvis_belt",
	"right_legu1",
	"right_legl1",
	"right_legl_foot",
	"torso",
	"torso_neck",
	"head",
	"head_hair",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"torso_armor",
	"right_armu1",
	"right_arml1",
	"right_arml_hand"
};

static char* s_TrooperModelNodes[] =
{
	"torso",
	"left_armu_1",
	"left_arml_1",
	"left_arml_hand",
	"head_1",
	"head_2",
	"pelvis",
	"left_legu_3",
	"left_legl_1",
	"left_legl_shoe",
	"right_legu_3",
	"right_legl_1",
	"right_legl_shoe",
	"right_legu_1",
	"right_legu_2",
	"left_legu_1",
	"left_legu_2",
	"pelvis_3",
	"pelvis_2",
	"pelvis_4",
	"right_armu_1",
	"right_arml_1",
	"right_arml_hand"
};

static char* s_EliteTrooperModelNodes[] =
{
	"torso",
	"pelvis",
	"right_legu_1",
	"right_legl_1",
	"right_legl_foot",
	"left_legu",
	"left_legl_shin",
	"left_legl_foot",
	"head_neck1",
	"head",
	"head_visor",
	"left_armu_shoulder",
	"left_armu",
	"left_arml",
	"right_armu_shoulder",
	"right_armu",
	"right_arml"
};

static char* s_ShockTrooperModelNodes[] =
{
	"torso",
	"pelvis",
	"left_legu",
	"left_legl",
	"left_legl_foot",
	"right_legu",
	"right_legl",
	"right_legl_foot",
	"head",
	"torso_1",
	"left_armu",
	"left_arml",
	"left_arml_hand",
	"right_armu",
	"right_arml",
	"right_arml_hand"
};

static char* s_EliteShockTrooperModelNodes[] =
{
	"torso_1",
	"pelvis",
	"left_legu",
	"left_legl_shin",
	"left_legl_foot",
	"right_legu",
	"right_legl_shin",
	"right_legl_foot",
	"head",
	"torso_2",
	"left_armu_shoulder",
	"left_arml_forearm",
	"left_arml_hand",
	"left_armu_bigspike",
	"left_armu_smallspike",
	"right_armu_shoulder",
	"right_arml_forearm",
	"right_arml_hand",
	"right_armu_bigspike",
	"right_armu_smallspike"
};

static char* s_TenmaModelNodes[] =
{
	"torso",
	"pelvis",
	"right_legu",
	"right_legl_shin",
	"right_legl_foot",
	"left_legu",
	"left_legl_shin",
	"left_legl_foot",
	"head",
	"right_armu_chest",
	"right_armu",
	"right_armu_elbow",
	"right_arml_forearm",
	"right_arml_hand",
	"left_armu_chest",
	"left_armu",
	"left_armu_elbow",
	"left_arml_forearm",
	"left_arml_hand"
};

// new ev - 11/12/98
static char* s_SAlienModelNodes[] = 
{
	"chest",
	"pelvis",
	"thigh01",
	"uppershin01",
	"foot01",
	"thigh02",
	"uppershin02",
	"foot02",
	"shoulder02",
	"bicep02",
	"forearm02",
	"Hand02",
	"shoulder01",
	"bicep01",
	"forearm01",
	"Hand01",
	"head"
};

// new ev - 28/12/98
static char* s_AlienStalkerModelNodes[] = 
{
	"mandable02",
	"shoulder02",
	"mandable03",
	"shoulder03",
	"foot02",
	"shin02",
	"lower_thigh02",
	"Thigh02",
	"foot01",
	"shin01",
	"lower_thigh01",
	"Thigh01",
	"hand03",
	"forearm06",
	"Bicep03",
	"hand02",
	"forearm05",
	"Bicep02",
	"head",
	"Neck",
	"Upper_chest",
	"Hip_joint01",
	"Hip_joint02"
};

// new ev - 22/12/98
static char* s_Mech02ModelNodes[] = 
{
	"Waist",
	"LegJoint02",
	"Leg02",
	"Knee02",
	"Shin02",
	"Foot02",
	"LegJoint01",
	"Leg01",
	"Knee01",
	"Shin01",
	"Foot01",
	"Chest",
	"ArmJoint02",
	"Shoulder02",
	"UperArm02",
	"LowerArm02",
	"Hand02",
	"ArmJoint01",
	"Shoulder01",
	"UperArm01",
	"LowerArm01",
	"Hand01",
	"Neck",
	"Head"
};
// new ev - 26/2/99

static char* s_VaderModelNodes[] =
{
	"R_RightFinger02",
	"R_Head",
	"R_Helmet",
	"R_BackRight",
	"R_BackLeft",
	"R_ShoulderJointLeft",
	"R_ShoulderLeft",
	"R_ElbowLeft",
	"R_ArmLeft",
	"R_LeftFinger02",
	"R_LeftFinger01",
	"R_ShoulderJointRight",
	"R_ShoulderRight",
	"R_ElbowRight",
	"R_ArmRight",
	"R_Chest",
	"R_RightFinger01",
	"R_Waist",
	"R_LegJointLeft",
	"R_LegLeft",
	"R_KneeLeft",
	"R_LowerLegLeft",
	"R_FootJointLeft",
	"R_FootLeft",
	"R_LegJointRight",
	"R_LegRight",
	"R_KneeRight",
	"R_LowerLegRight",
	"R_FootJointRight",
	"R_FootRight"
};

// new ev - 22/12/98
static char* s_BugModelNodes[] = 
{
	"Body",
	"LegFL02",
	"FootTopFL02",
	"FootBottomFL02",
	"LegFL03",
	"FootTopFL03",
	"FootBottomFL03",
	"LegFL04",
	"FootTopFL04",
	"FootBottomFL04",
	"LegFL05",
	"FootTopFL05",
	"FootBottomFL05",
	"Head"
};

// new ev - 22/12/98
static char* s_AlienProbeModelNodes[] = 
{
	"Jet_2",
	"FinTop",
	"EngineMountLeft",
	"Cylinder02",
	"Cylinder03",
	"Cylinder05",
	"Cylinder01",
	"Box01",
	"Cylinder07",
	"Jet_1",
	"Cockpit",
	"Fire_1",
	"Fire_2",
	"Box03",
	"Cylinder11",
	"Cylinder12",
	"Cylinder13",
	"Cylinder14",
	"EngineMountLeft01",
	"Cylinder15"
};

// new ev - 23/2/99
static char* s_AlienSearcherModelNodes[] = 
{
	"BladeBottomMiddle",
	"BladeTopLeft",
	"BladeTopRight",
	"Box01",
	"Box02",
	"Box03",
	"Box04",
	"Drone",
	"GunLeft",
	"GunMountLeft",
	"GunMountRight",
	"GunRight",
	"LeftBarrel01",
	"LeftBarrel02",
	"LeftBarrel03",
	"Light_Node",
	"RightBarrel01",
	"RightBarrel02",
	"RightBarrel03"
};

// ALIEN VEHICLE MODEL NODES... not used just yet....
// new ev - 23/2/99
static char* s_DoodleMechModelNodes[] = 
{
	"Cylinder01",
	"Tube01",
	"Box08",
	"Box11",
	"Box14",
	"Cylinder02",
	"Cone04",
	"thigh01",
	"shin01",
	"thigh02",
	"shin02",
	"foot02",
	"foot03",
	"shin03",
	"thigh03",
	"foot04"
};

// new ev - 23/2/99
static char* s_AlienSonicModelNodes[] = 
{
	"Cockpit",
	"GunFrontBack",
	"Barrel",
	"GunBack",
	"GunFrontMiddle",
	"GunTube",
	"UpperLegJointLeft01",
	"UpperLegLeft01",
	"LowerLegJointLeft01",
	"LegLeft01",
	"FootJointLeft01",
	"FootLeft01",
	"ToeFrontLeft01",
	"ToeBackLeft01",
	"TubeLeft01",
	"LegSpikeLeft01",
	"UpperLegJointLeft",
	"UpperLegLeft",
	"LowerLegJointLeft",
	"LegLeft",
	"FootJointLeft",
	"FootLeft",
	"ToeFrontLeft",
	"ToeBackLeft",
	"TubeLeft",
	"LegSpikeLeft"
};

// new ev - 23/2/99
static char* s_AlienWalkerModelNodes[] = 
{
	"Cockpit",
	"Left Gun Mount",
	"Left Gun Barrel",
	"Right Gun Mount",
	"Right Gun Barrel",
	"Right Leg Joint",
	"Right Leg Upper",
	"Right Leg",
	"Right Leg Lower",
	"Right Foot Joint",
	"Right Foot",
	"Left Leg Joint",
	"Left Leg Upper",
	"Left Leg",
	"Left Leg Lower",
	"Left Foot Joint",
	"Left Foot"
};

#pragma message ( "LOFFIXME - GET MODEL EXACT MODEL NODES FOR Mutant " __FILE__ )
// new ev - 7/3/99
static char* s_MutantModelNodes[] = 
{
	"Cockpit",
	"Left Gun Mount",
	"Left Gun Barrel",
	"Right Gun Mount",
	"Right Gun Barrel",
	"Right Leg Joint",
	"Right Leg Upper",
	"Right Leg",
	"Right Leg Lower",
	"Right Foot Joint",
	"Right Foot",
	"Left Leg Joint",
	"Left Leg Upper",
	"Left Leg",
	"Left Leg Lower",
	"Left Foot Joint",
	"Left Foot"
};

#pragma message ( "LOFFIXME - GET MODEL EXACT MODEL NODES FOR KatoBoss " __FILE__ )
// new ev - 7/3/99
static char* s_KatoBossModelNodes[] = 
{
	"Body",
	"Horn_01",
	"Head",
	"Right_Arm",
	"Right_Hand",
	"Horn_02",
	"Horn_03",
	"Left_Back_leg",
	"Right_Back_leg",
	"Left_arm",
	"Left_Hand",
	"Right_Front_Leg",
	"Left_Front_leg"
};

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetNumModelNodes
//
//	PURPOSE:	Return the number of nodes in the model associated with
//				the particular id
//
// ----------------------------------------------------------------------- //

inline DDWORD GetNumModelNodes(DDWORD nId, ModelSize size=MS_NORMAL)
{
	DDWORD nRet = 0;

	switch (nId)
	{
		// HUMAN MODELS /////////////////////////////////////////////////////
		case MI_AI_LITTLEBOY_ID:
			nRet = (sizeof(s_LittleBoyModelNodes) / sizeof(s_LittleBoyModelNodes[0]));
		break;

		case MI_AI_LITTLEGIRL_ID:
			nRet = (sizeof(s_LittleGirlModelNodes) / sizeof(s_LittleGirlModelNodes[0]));
		break;

		case MI_AI_CIVILIAN1_ID:
		case MI_AI_CIVILIAN1B_ID:
			nRet = (sizeof(s_Civilian1ModelNodes) / sizeof(s_Civilian1ModelNodes[0]));
		break;

		case MI_AI_CIVILIAN2_ID:
			nRet = (sizeof(s_Civilian2ModelNodes) / sizeof(s_Civilian2ModelNodes[0]));
		break;

		case MI_AI_OFFICER_ID:
			nRet = (sizeof(s_OfficerModelNodes) / sizeof(s_OfficerModelNodes[0]));
		break;

		case MI_AI_TROOPER_ID:
			nRet = (sizeof(s_TrooperModelNodes) / sizeof(s_TrooperModelNodes[0]));
		break;

		case MI_AI_ETROOPER_ID:
			nRet = (sizeof(s_EliteTrooperModelNodes) / sizeof(s_EliteTrooperModelNodes[0]));
		break;

		case MI_AI_STROOPER_ID:
			nRet = (sizeof(s_ShockTrooperModelNodes) / sizeof(s_ShockTrooperModelNodes[0]));
		break;

		case MI_AI_ESTROOPER_ID:
			nRet = (sizeof(s_EliteShockTrooperModelNodes) / sizeof(s_EliteShockTrooperModelNodes[0]));
		break;

		case MI_AI_SAMANTHA_ID:
		case MI_AI_AVC_ID:
			nRet = (sizeof(s_AVCModelNodes) / sizeof(s_AVCModelNodes[0]));
		break;

		case MI_AI_ORDOG_ID:
			nRet = (sizeof(s_OrdogModelNodes) / sizeof(s_OrdogModelNodes[0]));
		break;

		case MI_AI_AKUMA_ID:
			nRet = (sizeof(s_AkumaModelNodes) / sizeof(s_AkumaModelNodes[0]));
		break;

		case MI_AI_ENFORCER_ID:
			nRet = (sizeof(s_EnforcerModelNodes) / sizeof(s_EnforcerModelNodes[0]));
		break;

		case MI_AI_PREDATOR_ID:
			nRet = (sizeof(s_PredatorModelNodes) / sizeof(s_PredatorModelNodes[0]));
		break;

		case MI_AI_ASSASSIN_ID:
			nRet = (sizeof(s_AssassinModelNodes) / sizeof(s_AssassinModelNodes[0]));
		break;

		case MI_AI_ANDRA5_ID:
			nRet = (sizeof(s_Andra5ModelNodes) / sizeof(s_Andra5ModelNodes[0]));
		break;

		case MI_AI_ANDRA10_ID:
			nRet = (sizeof(s_Andra10ModelNodes) / sizeof(s_Andra10ModelNodes[0]));
		break;

		case MI_AI_RAKSHA_ID:
			nRet = (sizeof(s_RakshaModelNodes) / sizeof(s_RakshaModelNodes[0]));
		break;

		case MI_AI_TENMA_ID:
			nRet = (sizeof(s_TenmaModelNodes) / sizeof(s_TenmaModelNodes[0]));
		break;

		// new ev - 22/12/98
		case MI_AI_MECH02_ID:
			nRet = (sizeof(s_Mech02ModelNodes) / sizeof(s_Mech02ModelNodes[0]));
		break;

		// new ev - 26/2/99
		case MI_AI_VADER_ID :
			nRet = (sizeof(s_VaderModelNodes) / sizeof(s_VaderModelNodes[0]));		
		break;

		case MI_AI_COTHINEAL_ID:
		break;

		// ALIEN MODELS ////////////////////////////////////////////////////
		// new ev - 11/12/98
		case MI_AI_SALIEN_ID:
			nRet = (sizeof(s_SAlienModelNodes) / sizeof(s_SAlienModelNodes[0]));
		break;

		// new ev - 28/12/98
		case MI_AI_ALIENSTALKER_ID:
			nRet = (sizeof(s_AlienStalkerModelNodes) / sizeof(s_AlienStalkerModelNodes[0]));
		break;

		// new ev - 06/1/99
		case MI_AI_BUG_ID:
			nRet = (sizeof(s_BugModelNodes) / sizeof(s_BugModelNodes[0]));
		break;

		// new ev - 23/2/99
		case MI_AI_ALIENSEARCHER_ID:
			nRet = (sizeof(s_AlienSearcherModelNodes) / sizeof(s_AlienSearcherModelNodes[0]));
		break;

		// new ev - 09/2/99
		case MI_AI_ALIENPROBE_ID:
			nRet = (sizeof(s_AlienProbeModelNodes) / sizeof(s_AlienProbeModelNodes[0]));
		break;

		// new ev - 7/3/99
		case MI_AI_MUTANT_ID:
			nRet = (sizeof(s_MutantModelNodes) / sizeof(s_MutantModelNodes[0]));
		break;

		// VEHICLE MODELS ////////////////////////////////////////////////////

		case MI_AI_RASCAL_ID:	
		case MI_AI_VIGILANCE_ID:
		case MI_AI_HAMMERHEAD_ID:
		case MI_AI_VANDAL_ID:	
		case MI_AI_SPARROWHAWK_ID:
		case MI_AI_RUIN150_ID:
		case MI_AI_UHLANA3_ID:
		break;

		//new ev - 28/12/98
		case MI_AI_ALIENWALKER_ID:
			nRet = (sizeof(s_AlienWalkerModelNodes) / sizeof(s_AlienWalkerModelNodes[0]));
		break;

		//new ev - 24/2/99
		case MI_AI_ALIENSONIC_ID:
			nRet = (sizeof(s_AlienSonicModelNodes) / sizeof(s_AlienSonicModelNodes[0]));
		break;

		// new ev - 23/2/99
		case MI_AI_DOODLEMECH_ID:
		case MI_AI_ASSAULTDOODLEMECH_ID:
			nRet = (sizeof(s_DoodleMechModelNodes) / sizeof(s_DoodleMechModelNodes[0]));
		break;

		// MAJOR CHARACTER MODELS ////////////////////////////////////////////

		case MI_AI_AMBER_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		case MI_AI_WOLF_ID:
		case MI_AI_OHATO_ID:
		case MI_AI_TIGER_ID:
		case MI_AI_FUJI_ID:
		break;

		case MI_AI_TASAKA_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		case MI_AI_KATOBOSS_ID:
			nRet = (sizeof(s_KatoBossModelNodes) / sizeof(s_KatoBossModelNodes[0]));
		break;

		case MI_AI_BAKU_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		default : break;
	}

	return nRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetModelNodeName
//
//	PURPOSE:	Return the name of a particular model node
//
// ----------------------------------------------------------------------- //

inline char* GetModelNodeName(DDWORD dwIndex, DDWORD nId, ModelSize size=MS_NORMAL)
{
	char* pRet = DNULL;

	if (dwIndex < 0 || dwIndex > GetNumModelNodes(nId, size)) return pRet;

	switch (nId)
	{
		// HUMAN MODELS /////////////////////////////////////////////////////

		case MI_AI_LITTLEBOY_ID:
			pRet = s_LittleBoyModelNodes[dwIndex];
		break;
	
		case MI_AI_LITTLEGIRL_ID:
			pRet = s_LittleGirlModelNodes[dwIndex];
		break;

		case MI_AI_CIVILIAN1_ID:
			pRet = s_Civilian1ModelNodes[dwIndex];
		break;

		case MI_AI_CIVILIAN1B_ID:
			pRet = s_Civilian1bModelNodes[dwIndex];
		break;

		case MI_AI_CIVILIAN2_ID:
			pRet = s_Civilian2ModelNodes[dwIndex];
		break;

		case MI_AI_OFFICER_ID:
			pRet = s_OfficerModelNodes[dwIndex];
		break;

		case MI_AI_TROOPER_ID:
			pRet = s_TrooperModelNodes[dwIndex];
		break;

		case MI_AI_ETROOPER_ID:
			pRet = s_EliteTrooperModelNodes[dwIndex];
		break;

		case MI_AI_STROOPER_ID:
			pRet = s_ShockTrooperModelNodes[dwIndex];
		break;

		case MI_AI_ESTROOPER_ID:
			pRet = s_EliteShockTrooperModelNodes[dwIndex];
		break;

		case MI_AI_SAMANTHA_ID:
		case MI_AI_AVC_ID:
			pRet = s_AVCModelNodes[dwIndex];
		break;

		case MI_AI_ORDOG_ID:
			pRet = s_OrdogModelNodes[dwIndex];
		break;

		case MI_AI_AKUMA_ID:
			pRet = s_AkumaModelNodes[dwIndex];
		break;

		case MI_AI_ENFORCER_ID:
			pRet = s_EnforcerModelNodes[dwIndex];
		break;

		case MI_AI_PREDATOR_ID:
			pRet = s_PredatorModelNodes[dwIndex];
		break;

		case MI_AI_ASSASSIN_ID:
			pRet = s_AssassinModelNodes[dwIndex];
		break;

		case MI_AI_ANDRA5_ID:
			pRet = s_Andra5ModelNodes[dwIndex];
		break;

		case MI_AI_ANDRA10_ID:
			pRet = s_Andra10ModelNodes[dwIndex];
		break;

		case MI_AI_RAKSHA_ID:
			pRet = s_RakshaModelNodes[dwIndex];
		break;

		case MI_AI_TENMA_ID:
			pRet = s_TenmaModelNodes[dwIndex];
		break;

		// LOF IDs 
		case MI_AI_MECH02_ID:
			pRet = s_Mech02ModelNodes[dwIndex];
		break;

		case MI_AI_VADER_ID:
			pRet = s_VaderModelNodes[dwIndex];
		break;


		case MI_AI_COTHINEAL_ID:
		break;


		// VEHICLE MODELS ////////////////////////////////////////////////////

		case MI_AI_RASCAL_ID:	
		case MI_AI_VIGILANCE_ID:
		case MI_AI_HAMMERHEAD_ID:
		case MI_AI_VANDAL_ID:	
		case MI_AI_SPARROWHAWK_ID:
		case MI_AI_RUIN150_ID:
		case MI_AI_UHLANA3_ID:
		break;

		//new ev - 28/12/98
		case MI_AI_ALIENWALKER_ID:
			pRet = s_AlienWalkerModelNodes[dwIndex];
		break;

		//new ev - 24/2/99
		case MI_AI_ALIENSONIC_ID:
			pRet = s_AlienSonicModelNodes[dwIndex];
		break;

		// new ev - 23/2/99
		case MI_AI_DOODLEMECH_ID:
		case MI_AI_ASSAULTDOODLEMECH_ID:
			pRet = s_DoodleMechModelNodes[dwIndex];
		break;

		// ALIEN MODELS ////////////////////////////////////////////////////
		// new ev - 11/12/98
		case MI_AI_SALIEN_ID:
			pRet = s_SAlienModelNodes[dwIndex];
		break;

		// new ev - 28/12/98
		case MI_AI_ALIENSTALKER_ID:
			pRet = s_AlienStalkerModelNodes[dwIndex];
		break;

		// new ev - 06/1/99
		case MI_AI_BUG_ID:
			pRet = s_BugModelNodes[dwIndex];
		break;

		// new ev - 23/2/99 
		case MI_AI_ALIENSEARCHER_ID:
			pRet = s_AlienSearcherModelNodes[dwIndex];
		break;

		// new ev - 09/2/99
		case MI_AI_ALIENPROBE_ID:
			pRet = s_AlienProbeModelNodes[dwIndex];
		break;

		// new ev - 7/3/99 
		case MI_AI_MUTANT_ID:
			pRet = s_MutantModelNodes[dwIndex];
		break;

		// MAJOR CHARACTER MODELS ////////////////////////////////////////////

		case MI_AI_AMBER_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		case MI_AI_WOLF_ID:
		case MI_AI_OHATO_ID:
		case MI_AI_TIGER_ID:
		case MI_AI_FUJI_ID:
		break;

		case MI_AI_TASAKA_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		case MI_AI_KATOBOSS_ID:
			pRet = s_KatoBossModelNodes[dwIndex];
		break;

		case MI_AI_BAKU_ID:
		{
			switch(size)
			{
				case MS_SMALL:
				case MS_LARGE:
				case MS_NORMAL:
				default :
				break;
			}
		}
		break;

		default : break;
	}

	return pRet;
}


#endif // __MODEL_NODES_H__
