// ----------------------------------------------------------------------- //
//
// MODULE  : LOFWolf.cpp
//
// PURPOSE : Wolf - Implementation
//
// CREATED : 24/2/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //

#include "LOFWolf.h"

BEGIN_CLASS(Wolf)
	ADD_LONGINTPROP(WeaponId, GUN_AMBEDAGUMA_ID)
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_WOLF_ID), PF_DIMS | PF_HIDDEN)
	ADD_BOOLPROP_FLAG(Small, 0, PF_HIDDEN)
END_CLASS_DEFAULT(Wolf, MajorCharacter, NULL, NULL)


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Wolf::Wolf()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

Wolf::Wolf() : MajorCharacter()
{
	m_nModelId	 = MI_AI_WOLF_ID;
	m_bIsMecha	 = DFALSE;
	m_nWeaponId	 = GUN_AMBEDAGUMA_ID;
	m_cc		 = FALLEN;

	m_fWalkVel	 = 175.0f;
	m_fRunVel	 = 350.0f;
}

BEGIN_CLASS(BAD_Wolf)
END_CLASS_DEFAULT(BAD_Wolf, Wolf, NULL, NULL)
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	BAD_Wolf::BAD_Wolf()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

BAD_Wolf::BAD_Wolf() : Wolf()
{
	m_cc = ALIEN; // well, anything that doesn't like FALLEN!
}