// ----------------------------------------------------------------------- //
//
// MODULE  : LOFWeapons.h
//
// PURPOSE : LOF Weapons - Definitions of the LOF weapon classes
//
// CREATED : 10th November 1998 by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#ifndef __LOF_WEAPONS_H__
#define __LOF_WEAPONS_H__

#include "Weapon.h"

class CProjectile;

// Legacy Of the Fallen weapons...

class CAmbedMort : public CWeapon
{
	public :
		CAmbedMort();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedHWAR : public CWeapon
{
	public :
		CAmbedHWAR();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedRASG : public CWeapon
{
	public :
		CAmbedRASG();
};

/*class CAmbedDSG : public CWeapon
{
	public :
		CAmbedDSG();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};*/
// new ev - 4/2/99 replacing the DSG
class CAmbedShochi : public CWeapon
{
	public :
		CAmbedShochi();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedEMS : public CWeapon
{
	public :
		CAmbedEMS();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedAguma : public CWeapon
{
	public :
		CAmbedAguma();
};

class CAmbedMinigun : public CWeapon
{
	public :
		CAmbedMinigun();
};

class CAmbedDrill : public CWeapon
{
	public :
		CAmbedDrill();
};

class CAmbedProximityMine : public CWeapon
{
	public :
		CAmbedProximityMine();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedKatoBurst : public CWeapon
{
	public :
		CAmbedKatoBurst();

	protected : 
		CProjectile* CreateProjectile(ObjectCreateStruct & theStruct);
};

class CAmbedKatoAxe : public CWeapon
{
	public :
		CAmbedKatoAxe();
};

// NOTE: the following weapons are not for player use
class CMCAClaw : public CWeapon
{
	public :
		CMCAClaw();
};

class COFClaw : public CWeapon
{
	public :
		COFClaw();
};

class CBugClaw : public CWeapon
{
	public :
		CBugClaw();
};

#endif // __LOF_WEAPONS_H__
