// ----------------------------------------------------------------------- //
//
// MODULE  : LOFWeapons.cpp
//
// PURPOSE : LOF Weapons - Implementation of the LOF weapon classes
//
// CREATED : 10th November 1998 by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#include "LOFWeapons.h"

#include "RiotWeapons.h"
#include "cpp_server_de.h"
#include "PlayerObj.h"
#include "WeaponFXTypes.h"

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedMort::CAmbedMort
//
//	PURPOSE:	Create the AMBED Fragmentation Mortar gun
//
// ----------------------------------------------------------------------- //

CAmbedMort::CAmbedMort() : CWeapon()
{
	m_nId				= GUN_AMBEDMORT_ID;
	m_eDamageType		= DT_EXPLODE;

	m_pHandWeaponName   = "Models\\Powerups\\Ambed_MORT.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_MORT_a.dtx";


	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedMort::CreateProjectile
//
//	PURPOSE:	Create the Mort projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedMort::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedMortProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedHWAR::CAmbedHWAR
//
//	PURPOSE:	Create the AMBED HWar gun
//
// ----------------------------------------------------------------------- //

CAmbedHWAR::CAmbedHWAR() : CWeapon()
{
	m_nId				= GUN_AMBEDHWAR_ID;
	m_eDamageType		= DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_HWAR.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_HWAR_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedHWAR::CreateProjectile
//
//	PURPOSE:	Create the HWAR projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedHWAR::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedHWARProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedRASG::CAmbedRASG
//
//	PURPOSE:	Create the AMBED RASG gun
//
// ----------------------------------------------------------------------- //

CAmbedRASG::CAmbedRASG() : CWeapon()
{
	m_nId				= GUN_AMBEDRASG_ID;
	m_eDamageType		= DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_RASG.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_RASG_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 2.5f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedDSG::CAmbedDSG
//
//	PURPOSE:	Create the AMBED DSG (Dual Slug Gun) gun
//
// ----------------------------------------------------------------------- //
/*
CAmbedDSG::CAmbedDSG() : CWeapon()
{
	m_nId				= GUN_AMBEDDSG_ID;
	m_eDamageType		= DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_DSG.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_DSG_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedDSG::CreateProjectile
//
//	PURPOSE:	Create the DSG projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedDSG::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedDSGProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}
*/
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedShochi::CAmbedShochi
//
//	PURPOSE:	Create the AMBED Shochi gun
//
// ----------------------------------------------------------------------- //

CAmbedShochi::CAmbedShochi() : CWeapon()
{
	m_nId				= GUN_AMBEDSHOCHI_ID;
	m_eDamageType		= DT_ENERGY;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_Shochi.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_Shochi_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedShochi::CreateProjectile
//
//	PURPOSE:	Create the Shochi projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedShochi::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedShochiProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedEMS::CAmbedEMS
//
//	PURPOSE:	Create the Ambed EMS (Eat My Shit) gun
//
// ----------------------------------------------------------------------- //

CAmbedEMS::CAmbedEMS() : CWeapon()
{
	m_nId				= GUN_AMBEDEMS_ID;
	m_eDamageType		= DT_ENERGY;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_EMS.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_EMS_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 2.5f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedEMS::CreateProjectile
//
//	PURPOSE:	Create the EMS projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedEMS::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedEMSProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedAguma::CAmbedAguma
//
//	PURPOSE:	Create the rapid action Aguma shotgun
//
// ----------------------------------------------------------------------- //

CAmbedAguma::CAmbedAguma() : CWeapon()
{
	m_nId				= GUN_AMBEDAGUMA_ID;
	m_eDamageType		= DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_Aguma.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_Aguma_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedMinigun::CAmbedMinigun
//
//	PURPOSE:	Create the Minigun (20/1/99)
//
// ----------------------------------------------------------------------- //

CAmbedMinigun::CAmbedMinigun() : CWeapon()
{
	m_nId				= GUN_AMBEDMINIGUN_ID;
	m_eDamageType		= DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_Minigun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_Minigun_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedDrill::CAmbedDrill
//
//	PURPOSE:	Create the CAmbedDrill (28/1/99)
//
// ----------------------------------------------------------------------- //

CAmbedDrill::CAmbedDrill() : CWeapon()
{
	m_nId				= GUN_AMBEDDRILL_ID;
	m_eDamageType		= DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_Drill.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_Drill_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 2.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedProximityMine::CAmbedProximityMine
//
//	PURPOSE:	Create the Ambed Proximity Mine (28/1/99)
//
// ----------------------------------------------------------------------- //

CAmbedProximityMine::CAmbedProximityMine() : CWeapon()
{
	m_nId				= GUN_AMBEDPROXIMITYMINE_ID;
	m_eDamageType		= DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_ProximityMine.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_ProximityMine_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedProximityMine::CreateProjectile
//
//	PURPOSE:	Create the Proximity Mine projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedProximityMine::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();
	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedProximityMineProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedKatoBurst::CAmbedKatoBurst
//
//	PURPOSE:	Create the Kato burst gun
//
// ----------------------------------------------------------------------- //

CAmbedKatoBurst::CAmbedKatoBurst() : CWeapon()
{
	m_nId				= GUN_AMBEDKATOBURST_ID;
	m_eDamageType		= DT_KATO;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_KatoBurst.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_KatoBurst_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedKatoBurst::CreateProjectile
//
//	PURPOSE:	Create the Kato burst projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAmbedKatoBurst::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAmbedKatoBurstProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAmbedKatoAxe::CAmbedKatoAxe
//
//	PURPOSE:	Create the Kato Axe
//
// ----------------------------------------------------------------------- //

CAmbedKatoAxe::CAmbedKatoAxe() : CWeapon()
{
	m_nId				= GUN_AMBEDKATOAXE_ID;
	m_eDamageType		= DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Ambed_KatoAxe.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ambed_KatoAxe_a.dtx";

	m_bInfiniteAmmo		= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}


// NOTE: the following weapons are not for player use

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CMCAClaw::CMCAClaw
//
//	PURPOSE:	Create the MCAClaw weapon
//
// ----------------------------------------------------------------------- //

CMCAClaw::CMCAClaw() : CWeapon()
{
	m_nId				= GUN_MCACLAW_ID;
	m_eDamageType		= DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Katana.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Katana.dtx";

	m_bInfiniteAmmo		= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.5f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.5f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	COFClaw::COFClaw
//
//	PURPOSE:	Create the OFClaw weapon
//
// ----------------------------------------------------------------------- //

COFClaw::COFClaw() : CWeapon()
{
	m_nId				= GUN_OFCLAW_ID;
	m_eDamageType		= DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Katana.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Katana.dtx";

	m_bInfiniteAmmo		= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.5f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.5f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBugClaw::CBugClaw
//
//	PURPOSE:	Create the Bug Claw weapon
//
// ----------------------------------------------------------------------- //

CBugClaw::CBugClaw() : CWeapon()
{
	m_nId				= GUN_BUGCLAW_ID;
	m_eDamageType		= DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Katana.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Katana.dtx";

	m_bInfiniteAmmo		= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.5f;
	m_fMinFireRest		= 0.5f;
	m_fMaxFireRest		= 1.5f;
}
