// ----------------------------------------------------------------------- //
//
// MODULE  : LOFWeaponPowerups.cpp
//
// PURPOSE : LOF weapon powerups - Implementation
//
// CREATED : 30/11/98 by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#include "WeaponPowerups.h"
#include "RiotMsgIds.h"
#include "cpp_server_de.h"
#include "WeaponDefs.h"
#include "BaseCharacter.h"
#include "LOFWeaponPowerups.h"

#define UPDATE_DELTA	0.1f

BEGIN_CLASS(AmbedRASGPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDRASG_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDRASG_ID))
END_CLASS_DEFAULT(AmbedRASGPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedRASGPowerup::AmbedRASGPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedRASGPowerup::AmbedRASGPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDRASG_ID); 
	m_iWeaponType	= GUN_AMBEDRASG_ID;
}


BEGIN_CLASS(AmbedHWARPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDHWAR_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDHWAR_ID))
END_CLASS_DEFAULT(AmbedHWARPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedHWARPowerup::AmbedHWARPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedHWARPowerup::AmbedHWARPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDHWAR_ID); 
	m_iWeaponType	= GUN_AMBEDHWAR_ID;
}


BEGIN_CLASS(AmbedMORTPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDMORT_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDMORT_ID))
END_CLASS_DEFAULT(AmbedMORTPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedMORTPowerup::AmbedMORTPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedMORTPowerup::AmbedMORTPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDMORT_ID); 
	m_iWeaponType	= GUN_AMBEDMORT_ID;
}
/*
BEGIN_CLASS(AmbedDSGPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDDSG_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDDSG_ID))
END_CLASS_DEFAULT(AmbedDSGPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedDSGPowerup::AmbedDSGPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedDSGPowerup::AmbedDSGPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDDSG_ID); 
	m_iWeaponType	= GUN_AMBEDDSG_ID;
}
*/

BEGIN_CLASS(AmbedShochiPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDSHOCHI_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDSHOCHI_ID))
END_CLASS_DEFAULT(AmbedShochiPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedShochiPowerup::AmbedShochiPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedShochiPowerup::AmbedShochiPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDSHOCHI_ID); 
	m_iWeaponType	= GUN_AMBEDSHOCHI_ID;
}

BEGIN_CLASS(AmbedEMSPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDEMS_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDEMS_ID))
END_CLASS_DEFAULT(AmbedEMSPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedEMSPowerup::AmbedEMSPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedEMSPowerup::AmbedEMSPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDEMS_ID); 
	m_iWeaponType	= GUN_AMBEDEMS_ID;
}

BEGIN_CLASS(AmbedAgumaPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDAGUMA_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDAGUMA_ID))
END_CLASS_DEFAULT(AmbedAgumaPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedAgumaPowerup::AmbedAgumaPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedAgumaPowerup::AmbedAgumaPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDAGUMA_ID); 
	m_iWeaponType	= GUN_AMBEDAGUMA_ID;
}

BEGIN_CLASS(AmbedDrillPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDDRILL_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDDRILL_ID))
END_CLASS_DEFAULT(AmbedDrillPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedDrillPowerup::AmbedDrillPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedDrillPowerup::AmbedDrillPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= 10000;//GetSpawnedAmmo(GUN_AMBEDDRILL_ID); 
	m_iWeaponType	= GUN_AMBEDDRILL_ID;
}

BEGIN_CLASS(AmbedProximityMinePowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDPROXIMITYMINE_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDPROXIMITYMINE_ID))
END_CLASS_DEFAULT(AmbedProximityMinePowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedProximityMinePowerup::AmbedProximityMinePowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedProximityMinePowerup::AmbedProximityMinePowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDPROXIMITYMINE_ID); 
	m_iWeaponType	= GUN_AMBEDPROXIMITYMINE_ID;
}

BEGIN_CLASS(AmbedMinigunPowerup)
	ADD_LONGINTPROP_FLAG(WeaponType, GUN_AMBEDMINIGUN_ID, PF_HIDDEN)
	ADD_LONGINTPROP(Ammo, GetSpawnedAmmo(GUN_AMBEDMINIGUN_ID))
END_CLASS_DEFAULT(AmbedMinigunPowerup, WeaponPowerup, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AmbedMinigunPowerup::AmbedMinigunPowerup
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AmbedMinigunPowerup::AmbedMinigunPowerup() : WeaponPowerup()
{ 
	m_dwAmmo		= GetSpawnedAmmo(GUN_AMBEDMINIGUN_ID); 
	m_iWeaponType	= GUN_AMBEDMINIGUN_ID;
}
