// ----------------------------------------------------------------------- //
//
// MODULE  : LOFWeaponDefs.h
//
// PURPOSE : LOF Specific definitions for weapon types
//
// CREATED : 18/1/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //

#ifndef __LOFWEAPON_DEFS_H__
#define __LOFWEAPON_DEFS_H__

#include "clientshell_de.h"
#include "RiotCommandIds.h"
#include "PlayerModeTypes.h"
#include "WeaponFXTypes.h"
#include "ProjectileFXTypes.h"
#include "basedefs_de.h"
#include "ModelFuncs.h"

#include <stdio.h>

// new ev - 18/1/99 Amount of ammo that an ammo powerup contains
inline DDWORD GetAmmoCount(RiotWeaponId nWeaponId)
{
	DDWORD dwAmmo = 1000;

	switch (nWeaponId)
	{
		case GUN_AMBEDKATOBURST_ID :
			dwAmmo = 50;//GetRandom(40,80);
		break;

		case GUN_SPIDER_ID :
			dwAmmo = 5;//GetRandom(5,10);
		break;

		case GUN_AMBEDMORT_ID :
			dwAmmo = GetRandom(1,3);
		break;

		case GUN_SNIPERRIFLE_ID :
			dwAmmo = 50;//GetRandom(40,80);
		break;

		case GUN_AMBEDSHOCHI_ID :
			dwAmmo = 60;//GetRandom(10,20);
		break;

		case GUN_SHREDDER_ID :
			dwAmmo = 10;//GetRandom(10,20);
		break;

		case GUN_AMBEDHWAR_ID :
			dwAmmo = 3;//GetRandom(1,3);
		break;


		// On-foot mode weapons...

		case GUN_AMBEDEMS_ID :
			dwAmmo = 10;//GetRandom(10,20);
		break;

		case GUN_AMBEDAGUMA_ID	:
			dwAmmo = 15;//GetRandom(10,25);
		break;

		case GUN_ASSAULTRIFLE_ID :
			dwAmmo = 50;//GetRandom(40,80);
		break;

		case GUN_ENERGYGRENADE_ID :
			dwAmmo = 5;//GetRandom(5,10);
		break;

		case GUN_AMBEDPROXIMITYMINE_ID :
			dwAmmo = 3;//GetRandom(5,10);
		break;

		case GUN_AMBEDRASG_ID :
			dwAmmo = 40;//GetRandom(45,90);
		break;

		case GUN_AMBEDMINIGUN_ID :
			dwAmmo = 100;
		break;

		case GUN_TOW_ID	:
			dwAmmo = 1;//GetRandom(1,5);
		break;

		case GUN_LASERCANNON_ID :
			dwAmmo = 45;//GetRandom(30,60);
		break;

		default : break;
	}

	return dwAmmo;
}

// new ev - 18/1/99 The scaling of the ammo powerup object
inline DVector GetAmmoScale(RiotWeaponId nWeaponId, ModelSize eSize=MS_NORMAL)
{
	DVector vRet;
	VEC_SET(vRet, 1.0f, 1.0f, 1.0f)

	switch (nWeaponId)
	{
		// On-foot mode weapons...

		case GUN_AMBEDDRILL_ID :
			VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
		break;

		case GUN_AMBEDEMS_ID :
			VEC_SET(vRet, 1.9f, 1.9f, 1.9f); 
		break;

		case GUN_AMBEDAGUMA_ID	:
			VEC_SET(vRet, 1.55f, 1.55f, 1.55f);
		break;

		case GUN_AMBEDRASG_ID :
			VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
		break;

		case GUN_ASSAULTRIFLE_ID :
		case GUN_ENERGYGRENADE_ID :
			//VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
			VEC_SET(vRet, 3.0f, 3.0f, 3.0f);
		break;

		case GUN_AMBEDPROXIMITYMINE_ID :
			//VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
			VEC_SET(vRet, 0.25f, 0.25f, 0.25f);
		break;

		case GUN_TOW_ID	:
			VEC_SET(vRet, 28.0f, 28.0f, 28.0f);
		break;

		case GUN_AMBEDMINIGUN_ID :
			VEC_SET(vRet, 1.1f, 1.1f, 1.1f);
		break;

		case GUN_AMBEDKATOBURST_ID :
			VEC_SET(vRet, 15.0f, 15.0f, 15.0f);
		break;

		case GUN_SHREDDER_ID	:
			VEC_SET(vRet, 25.0f, 25.0f, 25.0f);
		break;

		case GUN_AMBEDSHOCHI_ID :
			//VEC_SET(vRet, 25.0f, 25.0f, 25.0f); // new ev - 04/12/98 changing Juggernaut to Ambed DSG
			VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
		break;

		case GUN_AMBEDMORT_ID	:
			// new ev - 30/11/98 changing Bullgut to AMBED MORT
			VEC_SET(vRet, 1.0f, 1.0f, 1.0f);
		break;

		case GUN_LASERCANNON_ID:
			VEC_SET(vRet, 25.0f, 25.0f, 25.0f);
		break;

		case GUN_SPIDER_ID :
			VEC_SET(vRet, 25.0f, 25.0f, 25.0f);
		break;

		case GUN_SNIPERRIFLE_ID :
			VEC_SET(vRet, 25.0f, 25.0f, 25.0f);
		break;

		case GUN_AMBEDHWAR_ID :
			//VEC_SET(vRet, 25.0f, 25.0f, 25.0f); // new ev - 02/12/98 changing RedRiot to Ambed HWAR
			VEC_SET(vRet, 2.0, 2.0f, 2.0f);
		break;

		default : break;
	}

	DFLOAT fFactor = (eSize == MS_NORMAL ? 1.0f : (eSize == MS_SMALL ? 0.2f : 5.0f));
	VEC_MULSCALAR(vRet, vRet, fFactor);


	return vRet;
}

#endif // __LOFWEAPON_DEFS_H__