// ----------------------------------------------------------------------- //
//
// MODULE  : LOFSAlien.cpp
//
// PURPOSE : SAlien Alien - Implementation
//
// CREATED : 11/12/98 - by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#include "LOFSAlien.h"


BEGIN_CLASS(SAlien)
	ADD_LONGINTPROP(WeaponId, GUN_AMBEDEMS_ID)
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_SALIEN_ID), PF_DIMS | PF_HIDDEN )
	ADD_BOOLPROP_FLAG(Small, 0, PF_HIDDEN)
END_CLASS_DEFAULT(SAlien, BaseAI, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	SAlien::SAlien()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

SAlien::SAlien() : BaseAI()
{
	m_nModelId	 = MI_AI_SALIEN_ID;
	m_bIsMecha	 = DFALSE;
	m_nWeaponId	 = GUN_AMBEDEMS_ID;
	m_cc		 = ALIEN;
}

BEGIN_CLASS(SAlien2)
	ADD_LONGINTPROP(WeaponId, GUN_AMBEDRASG_ID)
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_SALIEN_ID), PF_DIMS | PF_HIDDEN )
	ADD_REALPROP_FLAG(HearingRange, 400.0f, PF_RADIUS)
	ADD_BOOLPROP_FLAG(Small, 0, PF_HIDDEN)
END_CLASS_DEFAULT(SAlien2, SAlien, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	SAlien2::SAlien2()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

SAlien2::SAlien2() : SAlien()
{
	m_nWeaponId	 = GUN_AMBEDRASG_ID;
}
