// ----------------------------------------------------------------------- //
//
// MODULE  : LOFProxMineTrigger.h
//
// PURPOSE : ProxMineTrigger - Definition
//
// CREATED : 1/3/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //

#ifndef __ProxMineTrigger_H__
#define __ProxMineTrigger_H__

#include "cpp_engineobjects_de.h"
#include "Activation.h"

class ProxMineTrigger : public BaseClass
{
	public :

		ProxMineTrigger();
		~ProxMineTrigger();

	protected :

		virtual DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);
		virtual DDWORD ObjectMessageFn(HOBJECT hSender, DDWORD messageID, HMESSAGEREAD hRead);

		virtual void  ObjectTouch(HOBJECT hObj);
		void  SetProximityMine(HOBJECT hObj);	// used to allow us to explode the CAmbedProximityMine!

		DVector m_vDims;				// Dims

	private :

		void	Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void	Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
		DBOOL	InitialUpdate();
		HOBJECT	m_hProxMine;		// a handle to the CAmbedProximityMine HOBJECT

};

#endif // __ProxMineTrigger_H__