// ----------------------------------------------------------------------- //
//
// MODULE  : LOFProjectiles.h
//
// PURPOSE : LOFProjectiles class - definition of Legacy of the Fallen Weapon projectiles
//
// CREATED : 8th November 1998 by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#ifndef __LOF_PROJECTILES_H__
#define __LOF_PROJECTILES_H__

#include "Projectile.h"
#include "Bouncer.h"

class CAmbedHWARProjectile : public CProjectile
{
	public :
		CAmbedHWARProjectile();
};

class CAmbedMortProjectile : public CProjectile
{
	public :
		CAmbedMortProjectile();
	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
	private : 
		void Update();					// provide new functionality for our projectile
		DVector		m_vPseudoGravity;	// less than world gravity but makes projectile fall
};

class CAmbedMortFragmentProjectile : public CProjectile
{
	public :
		CAmbedMortFragmentProjectile();
		void Setup(CProjectile* pParent, HOBJECT hFiredFrom);
	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
	private : 
		void Detonate(HOBJECT hObj);
		void Update();					// provide new functionality for our projectile
		DVector		m_vPseudoGravity;	// less than world gravity but makes projectile fall
};

class CAmbedEMSProjectile : public CProjectile
{
	public :
		CAmbedEMSProjectile();
	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
};

class CAmbedShochiProjectile : public CProjectile
{
	public :
		CAmbedShochiProjectile();
	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
};

class CAmbedProximityMineProjectile : public CProjectile
{
	public :
		CAmbedProximityMineProjectile();

	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);
		DDWORD ObjectMessageFn(HOBJECT hSender, DDWORD messageID, HMESSAGEREAD hRead);
		virtual void HandleImpact(HOBJECT hObj);
		virtual void RemoveObject();
		virtual void HandleTouch(HOBJECT hObj);

	private :

		void Detonate(HOBJECT hObj);
		void Update();						// provide new functionality for our projectile
		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);

		char*		m_pThudSound;			// Thud sound filename
		char*		m_pArmSound;			// Weapon Armed filename

		DVector		m_vPosOffset;

		DBOOL		m_bAttached;			// Are we stuck on / attached to a world object?
		DBOOL		m_bArmed;				// Are we ready to blow
		DFLOAT		m_fArmTime;				// Time taken to arm (and let player get out of the way)!

		DDWORD		m_dwFireAni;			// Fire animation
		DDWORD		m_dwArmedAni;			// Mine is armed and primed animation
		DDWORD		m_dwImpactAni;			// Impact animation

		DVector		m_vPseudoGravity;		// less than world gravity but makes projectile fall

		HOBJECT		m_hExternalBox;			// external bounding box trigger

		void		CreateExternalBox();
};

class CAmbedKatoBurstProjectile : public CProjectile
{
	public :
		CAmbedKatoBurstProjectile();
	protected :
		DDWORD EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
};

/*class CAmbedDSGProjectile : public CProjectile
{
	public :
		CAmbedDSGProjectile();
};*/

#endif //  __LOF_PROJECTILES_H__