// ----------------------------------------------------------------------- //
//
// MODULE  : LOFMeleeAI.h
//
// PURPOSE : LOFMeleeAI Melee - Definition
//
// CREATED : 27/1/99
//
// ----------------------------------------------------------------------- //

#ifndef __LOFMELEEAI_H__
#define __LOFMELEEAI_H__

#include "cpp_engineobjects_de.h"
#include "BaseAI.h"

// distance to target must be less than this to attack
#define MELEE_ENGAGE_DISTANCE	120.0f
// we run until we get this close!
#define MELEE_RUN_DISTANCE		256.0f

#define MELEE_START_FIRE		"START_FIRE"
#define MELEE_KEY_FIRE_WEAPON	"FIRE_KEY"
#define MELEE_END_FIRE			"END_FIRE"


class MeleeAI : public BaseAI
{
	public :
		enum Melee_Attacks
		{
			NOATTACK = 0, MATTACK1, MATTACK2, MATTACK3
		};

 		MeleeAI();
		~MeleeAI();

	protected :

		DDWORD	EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);

		virtual void UpdateWeapon();
		virtual void UpdateAnimation();
		virtual void SetAnimationIndexes();
		virtual void HandleModelString(ArgList* pArgList); // handles our special model commands (start fire / fire / end fire)
		virtual void SetStandAnimation();	// overrides the standing animations to accomodate our special melee attacks
		virtual void SetWalkAnimation();	// overrides the walking animations to accomodate our special melee attacks
		virtual void UpdateAggressive();	// melee AI creatures are by default very aggressive
		virtual void UpdateMovement();
		void		 NewUpdateMovement();
		void		 InitialUpdate();
		void		 ApproachTarget();
		virtual DBOOL TargetInMeleeRange(HOBJECT target); // very important for melee creatures, so that they can 
														  // determine whether they are close enough to strike the player

		HMODELANIM	m_hMeleeAttack1Ani; // the most common melee attack
		HMODELANIM	m_hMeleeAttack2Ani; // the second melee attack
		HMODELANIM	m_hMeleeAttack3Ani; // the third melee attack

		DBOOL		m_bChangeAnimation;	// used to ignore the default UpdateAnimation from CBaseCharacter
		DBOOL		m_bIsMeleeFiring;	// used to flag whether our current animation can be interrupted

		char*		m_pIdleSound;		// name of idle sound
		DFLOAT		m_fMeleeRange;		// range of attack

		Melee_Attacks m_nLastAni;		// keeps track of the last attack animation (for varienty)

	private :

		HSOUNDDE	m_hIdleSound; // pointer to sound object


		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
		void CacheFiles();


};
#endif // __LOFMELEEAI_H__