// ----------------------------------------------------------------------- //
//
// MODULE  : LOFFlyingAI.h
//
// PURPOSE : LOFFlyingAI Flying Unit - Definition
//
// CREATED : 9/2/99
//
// ----------------------------------------------------------------------- //

#ifndef __LOFFLYINGAI_H__
#define __LOFFLYINGAI_H__

#include "cpp_engineobjects_de.h"
#include "TemplateList.h"
#include "BaseAI.h"


class FlyingAI : public BaseAI
{
	public :
		enum FAIMoveType
		{
			FARAND = 0,		// a semi random function -- erratic
			FACONSTRAINED,	// changes the current direction by a small percentage
			FASTART,		// hovers around the start point
			FASWOOP,		// swoops the player
			FASHOGO			// similar to shogo's ai
		};

 		FlyingAI();
		~FlyingAI();

	protected :

		DDWORD	EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);
		DBOOL   ReadProp(ObjectCreateStruct *pInfo);

		virtual void UpdateThinking();
		virtual void UpdateWeapon();
		virtual void UpdateAnimation();
		virtual void SetAnimationIndexes();
		virtual void UpdateMovement();
		void		 NewUpdateMovement();
		void		 InitialUpdate();
		void		 ApproachTarget();
		virtual	DBOOL CheckForFlyingCollision(DVector vDir, DFLOAT fDist);
		virtual	DBOOL CheckForFlyingCollision2(DVector vPos, DVector vDir, DFLOAT fDist);
		virtual	void CalculateNextMoveDir(DVector *vDir, FAIMoveType eType = FARAND);

		DBOOL		m_bChangeAnimation;	// used to ignore the default UpdateAnimation from CBaseCharacter
		DFLOAT		m_fFlyVel;
		DFLOAT		m_fFlyFastVel;
		DFLOAT		m_fSwoopVel;
		DVector		m_vStartPoint;
		DDWORD		m_nUpCount;			// used to make the flying AI recover from it's swoop

		DFLOAT		m_fNextAttackTime;	// the next time that the AI will attack

		char*		m_pIdleSound;		// name of idle sound
		FAIMoveType m_eFAIType;

		HMODELANIM	m_hFlyAni;
		HMODELANIM	m_hFlyAttackAni;

		CTList< DVector* > m_pWayPoints;// list of ai waypoints

	private :

		HSOUNDDE	m_hIdleSound; // pointer to sound object

		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
		void CacheFiles();
		void GetPanicPos(DVector *vPos);

};
#endif // __LOFFLYINGAI_H__