// ----------------------------------------------------------------------- //
//
// MODULE  : LOFDoodleMech.h
//
// PURPOSE : DoodleMech Alien Scouting Robot - Definition
//
// CREATED : 28/12/98
//
// ----------------------------------------------------------------------- //

#ifndef __DOODLEMECH_H__
#define __DOODLEMECH_H__

#include "cpp_engineobjects_de.h"
#include "Vehicle.h"


class DoodleMech : public Vehicle
{
	public :

 		DoodleMech();

	protected :

		DDWORD	EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);

		virtual void UpdateWeapon();
		virtual void UpdateAnimation();
		virtual void SetAnimationIndexes();

		virtual DVector GetFirePos(DVector* pvPos);

		HMODELANIM	m_hShredderAni;
		HMODELANIM	m_hRocketsAni;

		DBOOL		m_bSaveAllowmovement;
		DBOOL		m_bChangeAnimation;

	private :

		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);

};
#endif // __DOODLEMECH_H__