// ----------------------------------------------------------------------- //
//
// MODULE  : LOFBug.cpp
//
// PURPOSE : Bug Alien - Implementation
//
// CREATED : 06/1/99 - by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#include "LOFBug.h"

#define ANIM_ATTACK1			"MATTACK1"
#define ANIM_ATTACK2			"MATTACK2"
#define ANIM_ATTACK3			"MATTACK3"
#define BUG_ENGAGE_DISTANCE		112.0f

BEGIN_CLASS(Bug)
	ADD_LONGINTPROP(WeaponId, GUN_BUGCLAW_ID)
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_BUG_ID), PF_DIMS | PF_HIDDEN )
	ADD_BOOLPROP_FLAG(Small, 0, PF_HIDDEN)
END_CLASS_DEFAULT(Bug, MeleeAI, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Bug::Bug()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

Bug::Bug() : MeleeAI()
{
	m_nModelId	 = MI_AI_BUG_ID;
	m_bIsMecha	 = DFALSE;
	m_nWeaponId	 = GUN_BUGCLAW_ID;
	m_cc		 = ALIEN;

	m_fMeleeRange			= BUG_ENGAGE_DISTANCE;

	m_pIdleSound = "Sounds\\Enemies\\Alien\\Bug\\Idle.wav";
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Bug::~Bug()
//
//	PURPOSE:	Destructor
//
// ----------------------------------------------------------------------- //

/*Bug::~Bug()
{	
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_hIdleSound)
	{
		pServerDE->KillSound(m_hIdleSound);
		m_hIdleSound = DNULL;
	}

}
*/
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Bug::SetAnimationIndexes()
//
//	PURPOSE:	Initialize model animation indexes
//
// ----------------------------------------------------------------------- //
	
void Bug::SetAnimationIndexes()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;

	MeleeAI::SetAnimationIndexes();

	m_hMeleeAttack1Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK1);
	m_hMeleeAttack2Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK2);
	m_hMeleeAttack3Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK3);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Bug::InitialUpdate()
//
//	PURPOSE:	Handle initial update
//
// ----------------------------------------------------------------------- //
/*
void Bug::InitialUpdate()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;
			
	DFLOAT fRadius = 2000.0f;
	fRadius *= (m_eModelSize == MS_SMALL ? 0.2f : (m_eModelSize == MS_LARGE ? 5.0f : 1.0f));

	// Play idle sound as long as we're alive...

	m_hIdleSound = PlaySoundFromObject(m_hObject, m_pIdleSound, fRadius, 
									   SOUNDTYPE_AI, SOUNDPRIORITY_HIGH, 
									   DTRUE, DTRUE);

	// Rag-doll the Bug...
	m_damage.SetApplyDamagePhysics(DTRUE);
}
*/