// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAssaultDoodleMech.cpp
//
// PURPOSE : AssaultDoodleMech Alien Scouting Robot - Implementation
//
// CREATED : 27/1/99
//
// ----------------------------------------------------------------------- //
#include "LOFAssaultDoodleMech.h"

#define ANIM_ATTACK1			"WALK_ATTACK"
#define ANIM_ATTACK2			"FRONT_FEET_ATTACK"
#define ANIM_ATTACK3			"REAR_LEG_ATTACK"

BEGIN_CLASS(AssaultDoodleMech)
	ADD_LONGINTPROP( State, MeleeAI::AGGRESSIVE )
	ADD_LONGINTPROP( WeaponId, GUN_MCACLAW_ID )
	ADD_STRINGPROP_FLAG( Filename, GetModel(MI_AI_ASSAULTDOODLEMECH_ID), PF_DIMS | PF_HIDDEN )
END_CLASS_DEFAULT( AssaultDoodleMech, MeleeAI, NULL, NULL )


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AssaultDoodleMech::AssaultDoodleMech()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AssaultDoodleMech::AssaultDoodleMech() : MeleeAI()
{
	m_nModelId		= MI_AI_ASSAULTDOODLEMECH_ID;
	m_bIsMecha		= DTRUE;
	m_nWeaponId		= GUN_MCACLAW_ID;
	m_cc			= ALIEN;

	m_pIdleSound = "Sounds\\Enemies\\MCA\\AssaultDoodleMech\\Idle.wav";
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AssaultDoodleMech::~AssaultDoodleMech()
//
//	PURPOSE:	Destructor
//
// ----------------------------------------------------------------------- //

/*AssaultDoodleMech::~AssaultDoodleMech()
{	
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_hIdleSound)
	{
		pServerDE->KillSound(m_hIdleSound);
		m_hIdleSound = DNULL;
	}

}
*/
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AssaultDoodleMech::SetAnimationIndexes()
//
//	PURPOSE:	Initialize model animation indexes
//
// ----------------------------------------------------------------------- //
	
void AssaultDoodleMech::SetAnimationIndexes()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;
pServerDE->CPrint("AssaultDoodleMech::SetAnimationIndexes()");
	MeleeAI::SetAnimationIndexes();

	m_hMeleeAttack1Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK1);
	m_hMeleeAttack2Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK2);
	m_hMeleeAttack3Ani		= pServerDE->GetAnimIndex(m_hObject, ANIM_ATTACK3);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AssaultDoodleMech::InitialUpdate()
//
//	PURPOSE:	Handle initial update
//
// ----------------------------------------------------------------------- //
/*
void AssaultDoodleMech::InitialUpdate()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;
			
	DFLOAT fRadius = 2000.0f;
	fRadius *= (m_eModelSize == MS_SMALL ? 0.2f : (m_eModelSize == MS_LARGE ? 5.0f : 1.0f));

	// Play idle sound as long as we're alive...

	m_hIdleSound = PlaySoundFromObject(m_hObject, m_pIdleSound, fRadius, 
									   SOUNDTYPE_AI, SOUNDPRIORITY_HIGH, 
									   DTRUE, DTRUE);

	// Don't rag-doll AssaultDoodleMech...
//	m_damage.SetApplyDamagePhysics(DFALSE);
}
*/