// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAmmoPowerups.h
//
// PURPOSE : LOF ammo powerups / pickup items implementation
//
// CREATED : 13/1/99
//
// ----------------------------------------------------------------------- //

#ifndef __LOFAMMO_POWERUPS_H__
#define __LOFAMMO_POWERUPS_H__

#include "Powerup.h"
#include "ModelFuncs.h"

class AmmoPowerup : public Powerup
{
	public :

		AmmoPowerup();

	protected :

		DDWORD			EngineMessageFn(DDWORD messageID, void *pData, DFLOAT lData);
		void			ObjectTouch(HOBJECT hObject);

		void			ReadProp( ObjectCreateStruct *pStruct );
		void			PostPropRead( ObjectCreateStruct *pStruct );
		void			InitialUpdate( CServerDE *pServer );

		DBYTE			m_iWeaponType;
		DDWORD			m_dwAmmo;
		ModelSize		m_eModelSize;

	private :

		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
};

class KatoBurstAmmo : public AmmoPowerup
{
	public :
		KatoBurstAmmo();
};

class SpiderAmmo : public AmmoPowerup
{
	public :
		SpiderAmmo();
};

class AmbedMORTAmmo : public AmmoPowerup
{
	public :
		AmbedMORTAmmo();
};

class SniperRifleAmmo : public AmmoPowerup
{
	public :
		SniperRifleAmmo();
};
/*
class AmbedDSGAmmo : public AmmoPowerup
{
	public :
		AmbedDSGAmmo();
};
*/
class AmbedShochiAmmo : public AmmoPowerup
{
	public :
		AmbedShochiAmmo();
};

class ShredderAmmo : public AmmoPowerup
{
	public :
		ShredderAmmo();
};

class AmbedHWARAmmo : public AmmoPowerup
{
	public :
		AmbedHWARAmmo();
};

class AmbedEMSAmmo : public AmmoPowerup
{
	public :
		AmbedEMSAmmo();
};

class AmbedAgumaAmmo : public AmmoPowerup
{
	public :
		AmbedAgumaAmmo();
};

class AssaultRifleAmmo : public AmmoPowerup
{
	public :
		AssaultRifleAmmo();
};

class EnergyGrenadeAmmo : public AmmoPowerup
{
	public :
		EnergyGrenadeAmmo();
};

class AmbedProximityMineAmmo : public AmmoPowerup
{
	public :
		AmbedProximityMineAmmo();
};

class AmbedRASGAmmo : public AmmoPowerup
{
	public :
		AmbedRASGAmmo();
};

class AmbedMinigunAmmo : public AmmoPowerup
{
	public :
		AmbedMinigunAmmo();
};

class TOWAmmo : public AmmoPowerup
{
	public :
		TOWAmmo();
};

class LaserCannonAmmo : public AmmoPowerup
{
	public :
		LaserCannonAmmo();
};

#endif //  __LOFAMMO_POWERUPS_H__