// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAmber.cpp
//
// PURPOSE : Amber - Implementation
//
// CREATED : 24/2/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //

#include "LOFAmber.h"

BEGIN_CLASS(Amber)
	ADD_LONGINTPROP(WeaponId, GUN_AMBEDEMS_ID)
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_AMBER_ID), PF_DIMS | PF_HIDDEN)
END_CLASS_DEFAULT(Amber, MajorCharacter, NULL, NULL)


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Amber::Amber()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

Amber::Amber() : MajorCharacter()
{
	m_nModelId	 = MI_AI_AMBER_ID;
	m_bIsMecha	 = DFALSE;
	m_nWeaponId	 = GUN_AMBEDEMS_ID;
	m_cc		 = FALLEN;
//	m_bGhost	 = DFALSE;

	m_fDimsScale[MS_NORMAL] = 1.0f;
	m_fDimsScale[MS_SMALL]  = 1.0f;
	m_fDimsScale[MS_LARGE]  = 1.0f;

	m_fWalkVel		= 200.0f;
	m_fRunVel		= 400.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Amber::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //
/*
DDWORD Amber::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	switch(messageID)
	{
		case MID_PRECREATE:
		{
			DDWORD dwRet = BaseAI::EngineMessageFn(messageID, pData, fData);
			if (fData == 1.0f || fData == 2.0f )
			{
				ReadProp((ObjectCreateStruct*)pData);
			}

			if (m_eModelSize == MS_SMALL)
			{
				m_nWeaponId	= GUN_NONE;
			}
			return dwRet;
		}

		case MID_SAVEOBJECT:
		{
			Save((HMESSAGEWRITE)pData, (DDWORD)fData);
		}
		break;

		case MID_LOADOBJECT:
		{
			Load((HMESSAGEREAD)pData, (DDWORD)fData);
		}
		break;

		default : break;
	}


	return BaseAI::EngineMessageFn(messageID, pData, fData);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Amber::ReadProp
//
//	PURPOSE:	Set property value
//
// ----------------------------------------------------------------------- //

DBOOL Amber::ReadProp(ObjectCreateStruct *pData)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !pData) return DFALSE;

	GenericProp genProp;
	if ( pServerDE->GetPropGeneric( "Ghost", &genProp ) == DE_OK )
		m_bGhost = genProp.m_Bool;

	if (m_bGhost)
	{
		DFLOAT r, g, b, a;
		pServerDE->GetObjectColor(m_hObject, &r, &g, &b, &a);
		pServerDE->SetObjectColor(m_hObject, r, g, b, 0.35f);

		m_dwFlags &= ~FLAG_SHADOW;
		m_nWeaponId	= GUN_NONE;
	}


	return DTRUE;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Amber::Save
//
//	PURPOSE:	Save the object
//
// ----------------------------------------------------------------------- //

void Amber::Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hWrite) return;

	pServerDE->WriteToMessageByte(hWrite, m_bGhost);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Amber::Load
//
//	PURPOSE:	Load the object
//
// ----------------------------------------------------------------------- //

void Amber::Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hRead) return;

	m_bGhost = (DBOOL) pServerDE->ReadFromMessageByte(hRead);
}
*/