// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAlienWalker.h
//
// PURPOSE : AlienWalker - Definition
//
// CREATED : 28/12/98 - by Ewen Vowels for Anarchy-Arts
//
// ----------------------------------------------------------------------- //

#ifndef __ALIENWALKER_H__
#define __ALIENWALKER_H__

#include "cpp_engineobjects_de.h"
#include "Vehicle.h"


class AlienWalker : public Vehicle
{
	public :

 		AlienWalker();

	protected :

		DDWORD	EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData);

		virtual void UpdateWeapon();
		virtual void UpdateAnimation();
		virtual void SetAnimationIndexes();

		virtual DVector GetFirePos(DVector* pvPos);

		HMODELANIM	m_hShredderAni;
		HMODELANIM	m_hRocketsAni;

		DBOOL		m_bSaveAllowmovement;
		DBOOL		m_bChangeAnimation;

	private :

		void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);

};
#endif // __ALIENWALKER_H__
