// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAlienSearcher.cpp
//
// PURPOSE : LOFAlienSearcher Flying Enemy - Implementation
//
// CREATED : 9/2/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //
#include "LOFAlienSearcher.h"

// animation names

BEGIN_CLASS( AlienSearcher )
	ADD_LONGINTPROP( State, FlyingAI::AGGRESSIVE )
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_ALIENSEARCHER_ID), PF_DIMS | PF_HIDDEN )
	ADD_LONGINTPROP( WeaponId, GUN_TOW_ID )
	ADD_BOOLPROP(MoveToFloor, DFALSE)
END_CLASS_DEFAULT( AlienSearcher, FlyingAI, NULL, NULL )


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::AlienSearcher()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AlienSearcher::AlienSearcher() : FlyingAI()
{
	m_bIsMecha				= DTRUE;
	m_nWeaponId				= GUN_TOW_ID;
	m_nModelId				= MI_AI_ALIENSEARCHER_ID;
	m_cc					= ALIEN;

	m_pIdleSound			= "Sounds\\Enemies\\MCA\\AlienSearcher\\Idle.wav";
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::~AlienSearcher()
//
//	PURPOSE:	Destructor
//
// ----------------------------------------------------------------------- //

/*AlienSearcher::~AlienSearcher()
{	
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_hIdleSound)
	{
		pServerDE->KillSound(m_hIdleSound);
		m_hIdleSound = DNULL;
	}

}*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::SetAnimationIndexes()
//
//	PURPOSE:	Initialize model animation indexes
//
// ----------------------------------------------------------------------- //
/*	
void AlienSearcher::SetAnimationIndexes()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;

	//FlyingAI::SetAnimationIndexes();
	m_hFlyAni		= pServerDE->GetAnimIndex(m_hObject, FLYINGAI_FLY_ANI);
}
*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::UpdateWeapon()
//
//	PURPOSE:	Update the our weapon
//
// ----------------------------------------------------------------------- //
/*
void AlienSearcher::UpdateWeapon()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;

	m_bChangeAnimation = DFALSE;

	// See if we are firing...

	if (IsFiring())
	{
		// If we just started firing, figure out what weapon/animation to use...

		if (!(m_dwLastAction & AI_AFLG_FIRE))
		{
			m_bChangeAnimation = DTRUE;
		}
	}

	FlyingAI::UpdateWeapon();
}
*/
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::UpdateAnimation()
//
//	PURPOSE:	Update the current animation
//
// ----------------------------------------------------------------------- //
/*
void AlienSearcher::UpdateAnimation()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;
	HMODELANIM hAni;
	// See if we should change our animation...

	if (m_bChangeAnimation)
	{
		//return;
		hAni = m_hFlyAni;
		m_bChangeAnimation = DFALSE;
	}
	else if (!IsFiring())
	{
		hAni = m_hFlyAni;
		//FlyingAI::UpdateAnimation();
	}
	if (!(pServerDE->GetModelPlaybackState(m_hObject) & MS_PLAYDONE))
	{
		return;
	}
	SetAnimation(hAni, DTRUE);
}
*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //

DDWORD AlienSearcher::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	switch(messageID)
	{
		case MID_SAVEOBJECT:
		{
			Save((HMESSAGEWRITE)pData, (DDWORD)fData);
		}
		break;

		case MID_LOADOBJECT:
		{
			Load((HMESSAGEREAD)pData, (DDWORD)fData);
		}
		break;
		
		default : break;
	}

	return FlyingAI::EngineMessageFn(messageID, pData, fData);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::Save
//
//	PURPOSE:	Save the object
//
// ----------------------------------------------------------------------- //

void AlienSearcher::Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hWrite) return;

	pServerDE->WriteToMessageByte  (hWrite, m_bChangeAnimation);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::Load
//
//	PURPOSE:	Load the object
//
// ----------------------------------------------------------------------- //

void AlienSearcher::Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hRead) return;

	m_bChangeAnimation		= pServerDE->ReadFromMessageByte  (hRead);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::InitialUpdate()
//
//	PURPOSE:	Handle initial update
//
// ----------------------------------------------------------------------- //
/*
void AlienSearcher::InitialUpdate()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;
			
	DFLOAT fRadius = 2000.0f;
	fRadius *= (m_eModelSize == MS_SMALL ? 0.2f : (m_eModelSize == MS_LARGE ? 5.0f : 1.0f));

	// Play idle sound as long as we're alive...

	m_hIdleSound = PlaySoundFromObject(m_hObject, m_pIdleSound, fRadius, 
									   SOUNDTYPE_AI, SOUNDPRIORITY_HIGH, 
									   DTRUE, DTRUE);

}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienSearcher::CacheFiles
//
//	PURPOSE:	Cache resources used by this the object
//
// ----------------------------------------------------------------------- //

void AlienSearcher::CacheFiles()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_pIdleSound)
	{
		pServerDE->CacheFile(FT_SOUND3D, m_pIdleSound);
	}
}
*/
