// ----------------------------------------------------------------------- //
//
// MODULE  : LOFAlienProbe.cpp
//
// PURPOSE : LOFAlienProbe Flying Enemy - Implementation
//
// CREATED : 9/2/99 by Ewen Vowels for Anarchy Arts
//
// ----------------------------------------------------------------------- //
#include "LOFAlienProbe.h"

// animation names

BEGIN_CLASS( AlienProbe )
	ADD_LONGINTPROP( State, FlyingAI::AGGRESSIVE )
	ADD_STRINGPROP_FLAG(Filename, GetModel(MI_AI_ALIENPROBE_ID), PF_DIMS | PF_HIDDEN )
	ADD_LONGINTPROP( WeaponId, GUN_BULLGUT_ID )
	ADD_BOOLPROP(MoveToFloor, DFALSE)
END_CLASS_DEFAULT( AlienProbe, FlyingAI, NULL, NULL )


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::AlienProbe()
//
//	PURPOSE:	Constructor
//
// ----------------------------------------------------------------------- //

AlienProbe::AlienProbe() : FlyingAI()
{
	m_bIsMecha				= DTRUE;
	m_nWeaponId				= GUN_BULLGUT_ID;
	m_nModelId				= MI_AI_ALIENPROBE_ID;
	m_cc					= ALIEN;

	m_pIdleSound			= "Sounds\\Enemies\\MCA\\AlienProbe\\Idle.wav";
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::~AlienProbe()
//
//	PURPOSE:	Destructor
//
// ----------------------------------------------------------------------- //

/*AlienProbe::~AlienProbe()
{	
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_hIdleSound)
	{
		pServerDE->KillSound(m_hIdleSound);
		m_hIdleSound = DNULL;
	}

}*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::SetAnimationIndexes()
//
//	PURPOSE:	Initialize model animation indexes
//
// ----------------------------------------------------------------------- //
/*	
void AlienProbe::SetAnimationIndexes()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;

	//FlyingAI::SetAnimationIndexes();
	m_hFlyAni		= pServerDE->GetAnimIndex(m_hObject, FLYINGAI_FLY_ANI);
}
*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::UpdateWeapon()
//
//	PURPOSE:	Update the our weapon
//
// ----------------------------------------------------------------------- //
/*
void AlienProbe::UpdateWeapon()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;

	m_bChangeAnimation = DFALSE;

	// See if we are firing...

	if (IsFiring())
	{
		// If we just started firing, figure out what weapon/animation to use...

		if (!(m_dwLastAction & AI_AFLG_FIRE))
		{
			m_bChangeAnimation = DTRUE;
		}
	}

	FlyingAI::UpdateWeapon();
}
*/
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::UpdateAnimation()
//
//	PURPOSE:	Update the current animation
//
// ----------------------------------------------------------------------- //
/*
void AlienProbe::UpdateAnimation()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !m_hObject) return;
	HMODELANIM hAni;
	// See if we should change our animation...

	if (m_bChangeAnimation)
	{
		//return;
		hAni = m_hFlyAni;
		m_bChangeAnimation = DFALSE;
	}
	else if (!IsFiring())
	{
		hAni = m_hFlyAni;
		//FlyingAI::UpdateAnimation();
	}
	if (!(pServerDE->GetModelPlaybackState(m_hObject) & MS_PLAYDONE))
	{
		return;
	}
	SetAnimation(hAni, DTRUE);
}
*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //

DDWORD AlienProbe::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	switch(messageID)
	{
		case MID_SAVEOBJECT:
		{
			Save((HMESSAGEWRITE)pData, (DDWORD)fData);
		}
		break;

		case MID_LOADOBJECT:
		{
			Load((HMESSAGEREAD)pData, (DDWORD)fData);
		}
		break;
		
		default : break;
	}

	return FlyingAI::EngineMessageFn(messageID, pData, fData);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::Save
//
//	PURPOSE:	Save the object
//
// ----------------------------------------------------------------------- //

void AlienProbe::Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hWrite) return;

	pServerDE->WriteToMessageByte  (hWrite, m_bChangeAnimation);
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::Load
//
//	PURPOSE:	Load the object
//
// ----------------------------------------------------------------------- //

void AlienProbe::Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !hRead) return;

	m_bChangeAnimation		= pServerDE->ReadFromMessageByte  (hRead);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::InitialUpdate()
//
//	PURPOSE:	Handle initial update
//
// ----------------------------------------------------------------------- //
/*
void AlienProbe::InitialUpdate()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;
			
	DFLOAT fRadius = 2000.0f;
	fRadius *= (m_eModelSize == MS_SMALL ? 0.2f : (m_eModelSize == MS_LARGE ? 5.0f : 1.0f));

	// Play idle sound as long as we're alive...

	m_hIdleSound = PlaySoundFromObject(m_hObject, m_pIdleSound, fRadius, 
									   SOUNDTYPE_AI, SOUNDPRIORITY_HIGH, 
									   DTRUE, DTRUE);

}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	AlienProbe::CacheFiles
//
//	PURPOSE:	Cache resources used by this the object
//
// ----------------------------------------------------------------------- //

void AlienProbe::CacheFiles()
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_pIdleSound)
	{
		pServerDE->CacheFile(FT_SOUND3D, m_pIdleSound);
	}
}
*/
