// ----------------------------------------------------------------------- //
//
// MODULE  : CharacterAttributes.h
//
// PURPOSE : Definitions for default character attributes
//
// CREATED : 12/9/97
//
// ----------------------------------------------------------------------- //

#ifndef __CHARACTER_ATTRIBUTES_H__
#define __CHARACTER_ATTRIBUTES_H__

#include "basetypes_de.h"
#include "ModelIds.h"
#include "ModelFuncs.h"

DFLOAT GetDefaultMass(DBYTE nId, ModelSize size);
DFLOAT GetDefaultHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultArmor(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxArmor(DBYTE nId, ModelSize size);


// Defines....

#define INFINITE_MASS						100000.0f

// Player attributes...

#define	CA_PLAYER_ONFOOT_MASS				2000.0f
#define	CA_PLAYER_MECHA_MASS				(CA_PLAYER_ONFOOT_MASS * 5.0f)

#define	CA_PLAYER_ONFOOT_HITPTS				100.0f
#define	CA_PLAYER_ONFOOT_MAX_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_PLAYER_ONFOOT_ARMOR				50.0f
#define	CA_PLAYER_ONFOOT_MAX_ARMOR			(CA_PLAYER_ONFOOT_ARMOR*4.0f)

#define	CA_PLAYER_KID_HITPTS				50.0f
#define	CA_PLAYER_KID_MAX_HITPTS			CA_PLAYER_KID_HITPTS
#define	CA_PLAYER_KID_ARMOR					0.0f
#define	CA_PLAYER_KID_MAX_ARMOR				CA_PLAYER_KID_ARMOR

#define	CA_PLAYER_ANUBIS_HITPTS				600.0f
#define	CA_PLAYER_PREDATOR_HITPTS			800.0f
#define	CA_PLAYER_OMONI_HITPTS				1200.0f
#define	CA_PLAYER_ENFORCER_HITPTS			1000.0f
#define	CA_PLAYER_DOKUSHU_HITPTS			1100.0f
#define	CA_PLAYER_GCDM_HITPTS				1000.0f

#define	CA_PLAYER_ANUBIS_MAX_HITPTS			CA_PLAYER_ANUBIS_HITPTS
#define	CA_PLAYER_PREDATOR_MAX_HITPTS		CA_PLAYER_PREDATOR_HITPTS
#define	CA_PLAYER_OMONI_MAX_HITPTS			CA_PLAYER_OMONI_HITPTS
#define	CA_PLAYER_ENFORCER_MAX_HITPTS		CA_PLAYER_ENFORCER_HITPTS
#define	CA_PLAYER_DOKUSHU_MAX_HITPTS		CA_PLAYER_DOKUSHU_HITPTS
#define	CA_PLAYER_GCDM_MAX_HITPTS			CA_PLAYER_GCDM_HITPTS

#define	CA_PLAYER_ANUBIS_ARMOR				600.0f
#define	CA_PLAYER_PREDATOR_ARMOR			800.0f
#define	CA_PLAYER_OMONI_ARMOR				1200.0f
#define	CA_PLAYER_ENFORCER_ARMOR			1000.0f
#define	CA_PLAYER_DOKUSHU_ARMOR				1000.0f
#define	CA_PLAYER_GCDM_ARMOR				900.0f

#define	CA_PLAYER_ANUBIS_MAX_ARMOR			(CA_PLAYER_ANUBIS_ARMOR*2.0f)
#define	CA_PLAYER_PREDATOR_MAX_ARMOR		(CA_PLAYER_PREDATOR_ARMOR*2.0f)
#define	CA_PLAYER_OMONI_MAX_ARMOR			(CA_PLAYER_OMONI_ARMOR*2.0f)
#define	CA_PLAYER_ENFORCER_MAX_ARMOR		(CA_PLAYER_ENFORCER_ARMOR*2.0f)
#define	CA_PLAYER_DOKUSHU_MAX_ARMOR			(CA_PLAYER_DOKUSHU_ARMOR*2.0f)
#define	CA_PLAYER_GCDM_MAX_ARMOR			(CA_PLAYER_GCDM_ARMOR*2.0f)
#define	CA_PLAYER_CONSTRUCTOR_MAX_ARMOR		(CA_PLAYER_CONSTRUCTOR_ARMOR*2.0f)


// AI attributes...

#define	CA_AI_MECHA_MASS			(CA_PLAYER_MECHA_MASS)
#define	CA_AI_VEHICLE_MASS			((CA_AI_MECHA_MASS) * 0.9f)
#define	CA_AI_ONFOOT_MASS			(CA_PLAYER_ONFOOT_MASS)

#define	CA_AI_ONFOOT_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_AI_ONFOOT_MAX_HITPTS		CA_PLAYER_ONFOOT_MAX_HITPTS
#define	CA_AI_ONFOOT_ARMOR			CA_PLAYER_ONFOOT_ARMOR
#define	CA_AI_ONFOOT_MAX_ARMOR		CA_PLAYER_ONFOOT_MAX_ARMOR

#define	CA_AI_MECHA_HITPTS			(CA_AI_ONFOOT_HITPTS * 5.0f)
#define	CA_AI_MECHA_MAX_HITPTS		(CA_AI_ONFOOT_MAX_HITPTS * 5.0f)
#define	CA_AI_MECHA_ARMOR			(CA_AI_ONFOOT_ARMOR * 5.0f)
#define	CA_AI_MECHA_MAX_ARMOR		(CA_AI_ONFOOT_MAX_ARMOR * 5.0f)

#define	CA_AI_LITTLEKID_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_LITTLEKID_HITPTS		25.0f
#define	CA_AI_LITTLEKID_MAX_HITPTS	CA_AI_LITTLEKID_HITPTS
#define	CA_AI_LITTLEKID_ARMOR		0.0f
#define	CA_AI_LITTLEKID_MAX_ARMOR	CA_AI_LITTLEKID_ARMOR

#define	CA_AI_CIVILIAN1_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_CIVILIAN1_HITPTS		50.0f
#define	CA_AI_CIVILIAN1_MAX_HITPTS	CA_AI_CIVILIAN1_HITPTS
#define	CA_AI_CIVILIAN1_ARMOR		0.0f
#define	CA_AI_CIVILIAN1_MAX_ARMOR	CA_AI_CIVILIAN1_ARMOR

#define	CA_AI_CIVILIAN2_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_CIVILIAN2_HITPTS		CA_AI_CIVILIAN1_HITPTS
#define	CA_AI_CIVILIAN2_MAX_HITPTS	CA_AI_CIVILIAN2_HITPTS
#define	CA_AI_CIVILIAN2_ARMOR		CA_AI_CIVILIAN1_ARMOR
#define	CA_AI_CIVILIAN2_MAX_ARMOR	CA_AI_CIVILIAN2_ARMOR

#define	CA_AI_OFFICER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_OFFICER_HITPTS		50.0f
#define	CA_AI_OFFICER_MAX_HITPTS	CA_AI_OFFICER_HITPTS
#define	CA_AI_OFFICER_ARMOR			25.0f
#define	CA_AI_OFFICER_MAX_ARMOR		CA_AI_OFFICER_ARMOR

#define	CA_AI_TROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_TROOPER_HITPTS		50.0f
#define	CA_AI_TROOPER_MAX_HITPTS	CA_AI_TROOPER_HITPTS
#define	CA_AI_TROOPER_ARMOR			50.0f
#define	CA_AI_TROOPER_MAX_ARMOR		CA_AI_TROOPER_ARMOR

#define	CA_AI_ETROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_ETROOPER_HITPTS		125.0f
#define	CA_AI_ETROOPER_MAX_HITPTS	CA_AI_ETROOPER_HITPTS
#define	CA_AI_ETROOPER_ARMOR		125.0f
#define	CA_AI_ETROOPER_MAX_ARMOR	CA_AI_ETROOPER_ARMOR

#define	CA_AI_STROOPER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_STROOPER_HITPTS		150.0f
#define	CA_AI_STROOPER_MAX_HITPTS	CA_AI_STROOPER_HITPTS
#define	CA_AI_STROOPER_ARMOR		150.0f
#define	CA_AI_STROOPER_MAX_ARMOR	CA_AI_STROOPER_ARMOR

#define	CA_AI_ESTROOPER_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_ESTROOPER_HITPTS		250.0f
#define	CA_AI_ESTROOPER_MAX_HITPTS	CA_AI_ESTROOPER_HITPTS
#define	CA_AI_ESTROOPER_ARMOR		250.0f
#define	CA_AI_ESTROOPER_MAX_ARMOR	CA_AI_ESTROOPER_ARMOR

#define	CA_AI_SALIEN_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_SALIEN_HITPTS			180.0f
#define	CA_AI_SALIEN_MAX_HITPTS		CA_AI_SALIEN_HITPTS
#define	CA_AI_SALIEN_ARMOR			180.0f
#define	CA_AI_SALIEN_MAX_ARMOR		CA_AI_SALIEN_ARMOR

#define	CA_AI_ALIENSTALKER_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_ALIENSTALKER_HITPTS	220.0f
#define	CA_AI_ALIENSTALKER_MAX_HITPTS CA_AI_ALIENSTALKER_HITPTS
#define	CA_AI_ALIENSTALKER_ARMOR	220.0f
#define	CA_AI_ALIENSTALKER_MAX_ARMOR CA_AI_ALIENSTALKER_ARMOR

#define	CA_AI_BUG_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_BUG_HITPTS			100.0f
#define	CA_AI_BUG_MAX_HITPTS		CA_AI_BUG_HITPTS
#define	CA_AI_BUG_ARMOR				100.0f
#define	CA_AI_BUG_MAX_ARMOR			CA_AI_BUG_ARMOR

#define	CA_AI_ALIENPROBE_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_ALIENPROBE_HITPTS		500.0f
#define	CA_AI_ALIENPROBE_MAX_HITPTS	CA_AI_ALIENPROBE_HITPTS
#define	CA_AI_ALIENPROBE_ARMOR		500.0f
#define	CA_AI_ALIENPROBE_MAX_ARMOR	CA_AI_ALIENPROBE_ARMOR

#define	CA_AI_ALIENSEARCHER_MASS		CA_AI_ONFOOT_MASS
#define	CA_AI_ALIENSEARCHER_HITPTS		150.0f
#define	CA_AI_ALIENSEARCHER_MAX_HITPTS	CA_AI_ALIENSEARCHER_HITPTS
#define	CA_AI_ALIENSEARCHER_ARMOR		150.0f
#define	CA_AI_ALIENSEARCHER_MAX_ARMOR	CA_AI_ALIENSEARCHER_ARMOR

#define	CA_AI_MUTANT_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_MUTANT_HITPTS			250.0f
#define	CA_AI_MUTANT_MAX_HITPTS		CA_AI_MUTANT_HITPTS
#define	CA_AI_MUTANT_ARMOR			250.0f
#define	CA_AI_MUTANT_MAX_ARMOR		CA_AI_MUTANT_ARMOR

#define	CA_AI_RASCAL_MASS			CA_AI_VEHICLE_MASS
#define	CA_AI_RASCAL_HITPTS			300.0f
#define	CA_AI_RASCAL_MAX_HITPTS		CA_AI_RASCAL_HITPTS
#define	CA_AI_RASCAL_ARMOR			300.0f
#define	CA_AI_RASCAL_MAX_ARMOR		CA_AI_RASCAL_ARMOR

#define	CA_AI_VIGILANCE_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_VIGILANCE_HITPTS		500.0f
#define	CA_AI_VIGILANCE_MAX_HITPTS	CA_AI_RASCAL_HITPTS
#define	CA_AI_VIGILANCE_ARMOR		500.0f
#define	CA_AI_VIGILANCE_MAX_ARMOR	CA_AI_RASCAL_ARMOR

#define	CA_AI_HAMMERHEAD_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_HAMMERHEAD_HITPTS		500.0f
#define	CA_AI_HAMMERHEAD_MAX_HITPTS	CA_AI_HAMMERHEAD_HITPTS
#define	CA_AI_HAMMERHEAD_ARMOR		500.0f
#define	CA_AI_HAMMERHEAD_MAX_ARMOR	CA_AI_HAMMERHEAD_ARMOR

#define	CA_AI_VANDAL_MASS			CA_AI_VEHICLE_MASS
#define	CA_AI_VANDAL_HITPTS			300.0f
#define	CA_AI_VANDAL_MAX_HITPTS		CA_AI_VANDAL_HITPTS
#define	CA_AI_VANDAL_ARMOR			300.0f
#define	CA_AI_VANDAL_MAX_ARMOR		CA_AI_VANDAL_ARMOR

#define	CA_AI_SPARROWHAWK_MASS		CA_AI_VEHICLE_MASS
#define	CA_AI_SPARROWHAWK_HITPTS	400.0f
#define	CA_AI_SPARROWHAWK_MAX_HITPTS CA_AI_SPARROWHAWK_HITPTS
#define	CA_AI_SPARROWHAWK_ARMOR		400.0f
#define	CA_AI_SPARROWHAWK_MAX_ARMOR	CA_AI_SPARROWHAWK_ARMOR

#define	CA_AI_VIOLATOR_MASS			CA_AI_MECHA_MASS
#define	CA_AI_VIOLATOR_HITPTS		900.0f
#define	CA_AI_VIOLATOR_MAX_HITPTS	CA_AI_VIOLATOR_HITPTS
#define	CA_AI_VIOLATOR_ARMOR		700.0f
#define	CA_AI_VIOLATOR_MAX_ARMOR	CA_AI_VIOLATOR_ARMOR

#define	CA_AI_AVC_MASS				CA_AI_MECHA_MASS
#define	CA_AI_AVC_HITPTS			500.0f
#define	CA_AI_AVC_MAX_HITPTS		CA_AI_AVC_HITPTS
#define	CA_AI_AVC_ARMOR				500.0f
#define	CA_AI_AVC_MAX_ARMOR			CA_AI_AVC_ARMOR

#define	CA_AI_RUIN150_MASS			CA_AI_MECHA_MASS
#define	CA_AI_RUIN150_HITPTS		800.0f
#define	CA_AI_RUIN150_MAX_HITPTS	CA_AI_RUIN150_HITPTS
#define	CA_AI_RUIN150_ARMOR			1000.0f
#define	CA_AI_RUIN150_MAX_ARMOR		CA_AI_RUIN150_ARMOR

#define	CA_AI_UHLANA3_MASS			CA_AI_MECHA_MASS
#define	CA_AI_UHLANA3_HITPTS		1500.0f
#define	CA_AI_UHLANA3_MAX_HITPTS	CA_AI_UHLANA3_HITPTS
#define	CA_AI_UHLANA3_ARMOR			1500.0f
#define	CA_AI_UHLANA3_MAX_ARMOR		CA_AI_UHLANA3_ARMOR

#define	CA_AI_DOODLEMECH_MASS		CA_AI_MECHA_MASS
#define	CA_AI_DOODLEMECH_HITPTS		800.0f
#define	CA_AI_DOODLEMECH_MAX_HITPTS	CA_AI_DOODLEMECH_HITPTS
#define	CA_AI_DOODLEMECH_ARMOR		800.0f
#define	CA_AI_DOODLEMECH_MAX_ARMOR	CA_AI_DOODLEMECH_ARMOR

// slightly stronger, hand to hand fighting version of the doodlemech!
#define	CA_AI_ASSAULTDOODLEMECH_MASS		CA_AI_MECHA_MASS
#define	CA_AI_ASSAULTDOODLEMECH_HITPTS		1100.0f
#define	CA_AI_ASSAULTDOODLEMECH_MAX_HITPTS	CA_AI_ASSAULTDOODLEMECH_HITPTS
#define	CA_AI_ASSAULTDOODLEMECH_ARMOR		1100.0f
#define	CA_AI_ASSAULTDOODLEMECH_MAX_ARMOR	CA_AI_ASSAULTDOODLEMECH_ARMOR

#define	CA_AI_ALIENWALKER_MASS		CA_AI_MECHA_MASS
#define	CA_AI_ALIENWALKER_HITPTS	1000.0f
#define	CA_AI_ALIENWALKER_MAX_HITPTS CA_AI_ALIENWALKER_HITPTS
#define	CA_AI_ALIENWALKER_ARMOR		1000.0f
#define	CA_AI_ALIENWALKER_MAX_ARMOR	CA_AI_ALIENWALKER_ARMOR

#define	CA_AI_ALIENSONIC_MASS		CA_AI_MECHA_MASS
#define	CA_AI_ALIENSONIC_HITPTS		1250.0f
#define	CA_AI_ALIENSONIC_MAX_HITPTS CA_AI_ALIENSONIC_HITPTS
#define	CA_AI_ALIENSONIC_ARMOR		1250.0f
#define	CA_AI_ALIENSONIC_MAX_ARMOR	CA_AI_ALIENSONIC_ARMOR

#define	CA_AI_OMONI_MASS			CA_AI_MECHA_MASS
#define	CA_AI_OMONI_HITPTS			CA_PLAYER_OMONI_HITPTS
#define	CA_AI_OMONI_MAX_HITPTS		CA_AI_OMONI_HITPTS
#define	CA_AI_OMONI_ARMOR			CA_PLAYER_OMONI_ARMOR
#define	CA_AI_OMONI_MAX_ARMOR		CA_AI_OMONI_ARMOR

#define	CA_AI_ANUBIS_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ANUBIS_HITPTS			CA_PLAYER_ANUBIS_HITPTS
#define	CA_AI_ANUBIS_MAX_HITPTS		CA_AI_ANUBIS_HITPTS
#define	CA_AI_ANUBIS_ARMOR			CA_PLAYER_ANUBIS_ARMOR
#define	CA_AI_ANUBIS_MAX_ARMOR		CA_AI_ANUBIS_ARMOR

#define	CA_AI_ENFORCER_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ENFORCER_HITPTS		CA_PLAYER_ENFORCER_HITPTS
#define	CA_AI_ENFORCER_MAX_HITPTS	CA_AI_ENFORCER_HITPTS
#define	CA_AI_ENFORCER_ARMOR		CA_PLAYER_ENFORCER_ARMOR
#define	CA_AI_ENFORCER_MAX_ARMOR	CA_AI_ENFORCER_ARMOR

#define	CA_AI_PREDATOR_MASS			CA_AI_MECHA_MASS
#define	CA_AI_PREDATOR_HITPTS		CA_PLAYER_PREDATOR_HITPTS
#define	CA_AI_PREDATOR_MAX_HITPTS	CA_AI_PREDATOR_HITPTS
#define	CA_AI_PREDATOR_ARMOR		CA_PLAYER_PREDATOR_ARMOR
#define	CA_AI_PREDATOR_MAX_ARMOR	CA_AI_PREDATOR_ARMOR

#define	CA_AI_ASSASSIN_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ASSASSIN_HITPTS		4000.0f
#define	CA_AI_ASSASSIN_MAX_HITPTS	CA_AI_ASSASSIN_HITPTS
#define	CA_AI_ASSASSIN_ARMOR		4000.0f
#define	CA_AI_ASSASSIN_MAX_ARMOR	CA_AI_ASSASSIN_ARMOR

#define	CA_AI_ANDRA5_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ANDRA5_HITPTS			600.0f
#define	CA_AI_ANDRA5_MAX_HITPTS		CA_AI_ANDRA5_HITPTS
#define	CA_AI_ANDRA5_ARMOR			600.0f
#define	CA_AI_ANDRA5_MAX_ARMOR		CA_AI_ANDRA5_ARMOR

#define	CA_AI_ANDRA10_MASS			CA_AI_MECHA_MASS
#define	CA_AI_ANDRA10_HITPTS		800.0f
#define	CA_AI_ANDRA10_MAX_HITPTS	CA_AI_ANDRA10_HITPTS
#define	CA_AI_ANDRA10_ARMOR			800.0f
#define	CA_AI_ANDRA10_MAX_ARMOR		CA_AI_ANDRA10_ARMOR

#define	CA_AI_RAKSHA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_RAKSHA_HITPTS			2000.0f
#define	CA_AI_RAKSHA_MAX_HITPTS		CA_AI_RAKSHA_HITPTS
#define	CA_AI_RAKSHA_ARMOR			2000.0f
#define	CA_AI_RAKSHA_MAX_ARMOR		CA_AI_RAKSHA_ARMOR

#define	CA_AI_TENMA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_TENMA_HITPTS			3000.0f
#define	CA_AI_TENMA_MAX_HITPTS		CA_AI_TENMA_HITPTS
#define	CA_AI_TENMA_ARMOR			3000.0f
#define	CA_AI_TENMA_MAX_ARMOR		CA_AI_TENMA_ARMOR

#define	CA_AI_MECH02_MASS			CA_AI_MECHA_MASS
#define	CA_AI_MECH02_HITPTS			2500.0f
#define	CA_AI_MECH02_MAX_HITPTS		CA_AI_MECH02_HITPTS
#define	CA_AI_MECH02_ARMOR			2500.0f
#define	CA_AI_MECH02_MAX_ARMOR		CA_AI_MECH02_ARMOR

#define	CA_AI_VADER_MASS			CA_AI_MECHA_MASS
#define	CA_AI_VADER_HITPTS			2000.0f
#define	CA_AI_VADER_MAX_HITPTS		CA_AI_VADER_HITPTS
#define	CA_AI_VADER_ARMOR			2000.0f
#define	CA_AI_VADER_MAX_ARMOR		CA_AI_VADER_ARMOR

#define	CA_AI_COTHINEAL_MASS		(CA_AI_MECHA_MASS * 2.5f)
#define	CA_AI_COTHINEAL_HITPTS		1000000.0f
#define	CA_AI_COTHINEAL_MAX_HITPTS	CA_AI_COTHINEAL_HITPTS
#define	CA_AI_COTHINEAL_ARMOR		1000000.0f
#define	CA_AI_COTHINEAL_MAX_ARMOR	CA_AI_COTHINEAL_ARMOR


// Major Character attributes...

#define	CA_AI_AMBER_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_AMBER_HITPTS			200.0f
#define	CA_AI_AMBER_MAX_HITPTS		CA_AI_AMBER_HITPTS
#define	CA_AI_AMBER_ARMOR			200.0f
#define	CA_AI_AMBER_MAX_ARMOR		CA_AI_AMBER_ARMOR
	
#define	CA_AI_WOLF_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_WOLF_HITPTS			300.0f
#define	CA_AI_WOLF_MAX_HITPTS		CA_AI_WOLF_HITPTS
#define	CA_AI_WOLF_ARMOR			400.0f
#define	CA_AI_WOLF_MAX_ARMOR		CA_AI_WOLF_ARMOR
	
#define	CA_AI_OHATO_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_OHATO_HITPTS			200.0f
#define	CA_AI_OHATO_MAX_HITPTS		CA_AI_OHATO_HITPTS
#define	CA_AI_OHATO_ARMOR			200.0f
#define	CA_AI_OHATO_MAX_ARMOR		CA_AI_OHATO_ARMOR
	
#define	CA_AI_TIGER_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_TIGER_HITPTS			200.0f
#define	CA_AI_TIGER_MAX_HITPTS		CA_AI_TIGER_HITPTS
#define	CA_AI_TIGER_ARMOR			200.0f
#define	CA_AI_TIGER_MAX_ARMOR		CA_AI_TIGER_ARMOR
	
#define	CA_AI_FUJI_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_FUJI_HITPTS			200.0f
#define	CA_AI_FUJI_MAX_HITPTS		CA_AI_FUJI_HITPTS
#define	CA_AI_FUJI_ARMOR			200.0f
#define	CA_AI_FUJI_MAX_ARMOR		CA_AI_FUJI_ARMOR
	
#define	CA_AI_TASAKA_MASS			CA_AI_ONFOOT_MASS
#define	CA_AI_TASAKA_HITPTS			200.0f
#define	CA_AI_TASAKA_MAX_HITPTS		CA_AI_TASAKA_HITPTS
#define	CA_AI_TASAKA_ARMOR			200.0f
#define	CA_AI_TASAKA_MAX_ARMOR		CA_AI_TASAKA_ARMOR
	
#define	CA_AI_KATOBOSS_MASS			(CA_AI_MECHA_MASS * 2.0f)
#define	CA_AI_KATOBOSS_HITPTS		2500.0f
#define	CA_AI_KATOBOSS_MAX_HITPTS	CA_AI_KATOBOSS_HITPTS
#define	CA_AI_KATOBOSS_ARMOR		2500.0f
#define	CA_AI_KATOBOSS_MAX_ARMOR	CA_AI_KATOBOSS_ARMOR
	
#define	CA_AI_BAKU_MASS				CA_AI_ONFOOT_MASS
#define	CA_AI_BAKU_HITPTS			400.0f
#define	CA_AI_BAKU_MAX_HITPTS		CA_AI_BAKU_HITPTS
#define	CA_AI_BAKU_ARMOR			400.0f
#define	CA_AI_BAKU_MAX_ARMOR		CA_AI_BAKU_ARMOR
	
#define	CA_AI_BAKU_MECHA_MASS		CA_AI_MECHA_MASS
#define	CA_AI_BAKU_MECHA_HITPTS		5000.0f
#define	CA_AI_BAKU_MECHA_MAX_HITPTS	CA_AI_BAKU_MECHA_HITPTS
#define	CA_AI_BAKU_MECHA_ARMOR		4000.0f
#define	CA_AI_BAKU_MECHA_MAX_ARMOR	CA_AI_BAKU_MECHA_ARMOR
	
#define	CA_AI_SAMANTHA_MASS			CA_AI_MECHA_MASS
#define	CA_AI_SAMANTHA_HITPTS		2000.0f
#define	CA_AI_SAMANTHA_MAX_HITPTS	CA_AI_SAMANTHA_HITPTS
#define	CA_AI_SAMANTHA_ARMOR		2000.0f
#define	CA_AI_SAMANTHA_MAX_ARMOR	CA_AI_SAMANTHA_ARMOR
	


#endif // __CHARACTER_ATTRIBUTES_H__
