// ----------------------------------------------------------------------- //
//
// MODULE  : CharacterAttributes.cpp
//
// PURPOSE : Implementation of character attributes
//
// CREATED : 12/9/97
//
// ----------------------------------------------------------------------- //

#include "CharacterAttributes.h"


DFLOAT s_fCharacterMasses[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MASS,	// Sanjuro
	CA_PLAYER_ONFOOT_MASS,	// Kid
	CA_PLAYER_MECHA_MASS,	// Player Akuma
	CA_PLAYER_MECHA_MASS,	// Player Predator
	CA_PLAYER_MECHA_MASS,	// Player Ordog
	CA_PLAYER_MECHA_MASS,	// Player Enforcer
	CA_PLAYER_MECHA_MASS,	// Player Dokushu
	CA_PLAYER_MECHA_MASS,	// Player GCDM
	CA_AI_LITTLEKID_MASS,
	CA_AI_LITTLEKID_MASS,
	CA_AI_CIVILIAN1_MASS,
	CA_AI_CIVILIAN1_MASS,
	CA_AI_CIVILIAN2_MASS,
	CA_AI_OFFICER_MASS,
	CA_AI_TROOPER_MASS,
	CA_AI_ETROOPER_MASS,
	CA_AI_STROOPER_MASS,
	CA_AI_ESTROOPER_MASS,
	CA_AI_AVC_MASS,
	CA_AI_OMONI_MASS,
	CA_AI_ANUBIS_MASS,
	CA_AI_ENFORCER_MASS,
	CA_AI_PREDATOR_MASS,
	CA_AI_ASSASSIN_MASS,
	CA_AI_ANDRA5_MASS,
	CA_AI_ANDRA10_MASS,
	CA_AI_RAKSHA_MASS,
	CA_AI_TENMA_MASS,
	CA_AI_COTHINEAL_MASS,
	CA_AI_MECH02_MASS,
	CA_AI_VADER_MASS,
	CA_AI_RASCAL_MASS,
	CA_AI_VIGILANCE_MASS,
	CA_AI_HAMMERHEAD_MASS,
	CA_AI_VANDAL_MASS,
	CA_AI_SPARROWHAWK_MASS,
	CA_AI_RUIN150_MASS,
	CA_AI_UHLANA3_MASS,
	CA_AI_DOODLEMECH_MASS,
	CA_AI_ASSAULTDOODLEMECH_MASS,
	CA_AI_ALIENWALKER_MASS,
	CA_AI_ALIENSONIC_MASS,
	CA_AI_AMBER_MASS,
	CA_AI_WOLF_MASS,
	CA_AI_OHATO_MASS,
	CA_AI_TIGER_MASS,
	CA_AI_FUJI_MASS,
	CA_AI_TASAKA_MASS,
	CA_AI_KATOBOSS_MASS,
	CA_AI_BAKU_MASS,
	CA_AI_SAMANTHA_MASS,
	CA_AI_SALIEN_MASS,
	CA_AI_ALIENSTALKER_MASS,
	CA_AI_BUG_MASS,
	CA_AI_ALIENPROBE_MASS,
	CA_AI_ALIENSEARCHER_MASS
};

DFLOAT s_fCharacterHitPts[MI_LAST] =
{
	CA_PLAYER_ONFOOT_HITPTS,	// Sanjuro
	CA_PLAYER_KID_HITPTS,		// Kid
	CA_PLAYER_ANUBIS_HITPTS,	// Player Anubis
	CA_PLAYER_PREDATOR_HITPTS,	// Player Predator
	CA_PLAYER_OMONI_HITPTS,		// Player Ordog
	CA_PLAYER_ENFORCER_HITPTS,	// Player Enforcer
	CA_PLAYER_DOKUSHU_HITPTS,	// Player Dokushu
	CA_PLAYER_GCDM_HITPTS,		// Player GCDM
	CA_AI_LITTLEKID_HITPTS,
	CA_AI_LITTLEKID_HITPTS,
	CA_AI_CIVILIAN1_HITPTS,
	CA_AI_CIVILIAN1_HITPTS,
	CA_AI_CIVILIAN2_HITPTS,
	CA_AI_OFFICER_HITPTS,
	CA_AI_TROOPER_HITPTS,
	CA_AI_ETROOPER_HITPTS,
	CA_AI_STROOPER_HITPTS,
	CA_AI_ESTROOPER_HITPTS,
	CA_AI_AVC_HITPTS,
	CA_AI_OMONI_HITPTS,
	CA_AI_ANUBIS_HITPTS,
	CA_AI_ENFORCER_HITPTS,
	CA_AI_PREDATOR_HITPTS,
	CA_AI_ASSASSIN_HITPTS,
	CA_AI_ANDRA5_HITPTS,
	CA_AI_ANDRA10_HITPTS,
	CA_AI_RAKSHA_HITPTS,
	CA_AI_TENMA_HITPTS,
	CA_AI_COTHINEAL_HITPTS,
	CA_AI_MECH02_HITPTS,
	CA_AI_VADER_HITPTS,
	CA_AI_RASCAL_HITPTS,
	CA_AI_VIGILANCE_HITPTS,
	CA_AI_HAMMERHEAD_HITPTS,
	CA_AI_VANDAL_HITPTS,
	CA_AI_SPARROWHAWK_HITPTS,
	CA_AI_RUIN150_HITPTS,
	CA_AI_UHLANA3_HITPTS,
	CA_AI_DOODLEMECH_HITPTS,
	CA_AI_ASSAULTDOODLEMECH_HITPTS,
	CA_AI_ALIENWALKER_HITPTS,
	CA_AI_ALIENSONIC_HITPTS,
	CA_AI_AMBER_HITPTS,
	CA_AI_WOLF_HITPTS,
	CA_AI_OHATO_HITPTS,
	CA_AI_TIGER_HITPTS,
	CA_AI_FUJI_HITPTS,
	CA_AI_TASAKA_HITPTS,
	CA_AI_KATOBOSS_HITPTS,
	CA_AI_BAKU_HITPTS,
	CA_AI_SAMANTHA_HITPTS,
	CA_AI_SALIEN_HITPTS,
	CA_AI_ALIENSTALKER_HITPTS,
	CA_AI_BUG_HITPTS,
	CA_AI_ALIENPROBE_HITPTS,
	CA_AI_ALIENSEARCHER_HITPTS,
	CA_AI_MUTANT_HITPTS
};

DFLOAT s_fCharacterMaxHitPts[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MAX_HITPTS,	// Sanjuro
	CA_PLAYER_KID_MAX_HITPTS,		// Kid
	CA_PLAYER_ANUBIS_MAX_HITPTS,	// Player Anubis
	CA_PLAYER_PREDATOR_MAX_HITPTS,	// Player Predator
	CA_PLAYER_OMONI_MAX_HITPTS,		// Player Ordog
	CA_PLAYER_ENFORCER_MAX_HITPTS,	// Player Enforcer
	CA_PLAYER_DOKUSHU_MAX_HITPTS,	// Player Dokushu
	CA_PLAYER_GCDM_MAX_HITPTS,		// Player GCDM
	CA_AI_LITTLEKID_MAX_HITPTS,
	CA_AI_LITTLEKID_MAX_HITPTS,
	CA_AI_CIVILIAN1_MAX_HITPTS,
	CA_AI_CIVILIAN1_MAX_HITPTS,
	CA_AI_CIVILIAN2_MAX_HITPTS,
	CA_AI_OFFICER_MAX_HITPTS,
	CA_AI_TROOPER_MAX_HITPTS,
	CA_AI_ETROOPER_MAX_HITPTS,
	CA_AI_STROOPER_MAX_HITPTS,
	CA_AI_ESTROOPER_MAX_HITPTS,
	CA_AI_AVC_MAX_HITPTS,
	CA_AI_OMONI_MAX_HITPTS,
	CA_AI_ANUBIS_MAX_HITPTS,
	CA_AI_ENFORCER_MAX_HITPTS,
	CA_AI_PREDATOR_MAX_HITPTS,
	CA_AI_ASSASSIN_MAX_HITPTS,
	CA_AI_ANDRA5_MAX_HITPTS,
	CA_AI_ANDRA10_MAX_HITPTS,
	CA_AI_RAKSHA_MAX_HITPTS,
	CA_AI_TENMA_MAX_HITPTS,
	CA_AI_COTHINEAL_MAX_HITPTS,
	CA_AI_MECH02_MAX_HITPTS,
	CA_AI_VADER_MAX_HITPTS,
	CA_AI_RASCAL_MAX_HITPTS,
	CA_AI_VIGILANCE_MAX_HITPTS,
	CA_AI_HAMMERHEAD_MAX_HITPTS,
	CA_AI_VANDAL_MAX_HITPTS,
	CA_AI_SPARROWHAWK_MAX_HITPTS,
	CA_AI_RUIN150_MAX_HITPTS,
	CA_AI_UHLANA3_MAX_HITPTS,
	CA_AI_DOODLEMECH_MAX_HITPTS,
	CA_AI_ASSAULTDOODLEMECH_MAX_HITPTS,
	CA_AI_ALIENWALKER_MAX_HITPTS,
	CA_AI_ALIENSONIC_MAX_HITPTS,
	CA_AI_AMBER_MAX_HITPTS,
	CA_AI_WOLF_MAX_HITPTS,
	CA_AI_OHATO_MAX_HITPTS,
	CA_AI_TIGER_MAX_HITPTS,
	CA_AI_FUJI_MAX_HITPTS,
	CA_AI_TASAKA_MAX_HITPTS,
	CA_AI_KATOBOSS_MAX_HITPTS,
	CA_AI_BAKU_MAX_HITPTS,
	CA_AI_SAMANTHA_MAX_HITPTS,
	CA_AI_SALIEN_MAX_HITPTS,
	CA_AI_ALIENSTALKER_MAX_HITPTS,
	CA_AI_BUG_MAX_HITPTS,
	CA_AI_ALIENPROBE_MAX_HITPTS,
	CA_AI_ALIENSEARCHER_MAX_HITPTS,
	CA_AI_MUTANT_MAX_HITPTS
};

DFLOAT s_fCharacterArmor[MI_LAST] =
{
	CA_PLAYER_ONFOOT_ARMOR,		// Sanjuro
	CA_PLAYER_KID_ARMOR,		// Kid
	CA_PLAYER_ANUBIS_ARMOR,		// Player Akuma
	CA_PLAYER_PREDATOR_ARMOR,	// Player Predator
	CA_PLAYER_OMONI_ARMOR,		// Player Ordog
	CA_PLAYER_ENFORCER_ARMOR,	// Player Enforcer
	CA_PLAYER_DOKUSHU_ARMOR,	// Player Dokushu
	CA_PLAYER_GCDM_ARMOR,		// Player GCDM
	CA_AI_LITTLEKID_ARMOR,
	CA_AI_LITTLEKID_ARMOR,
	CA_AI_CIVILIAN1_ARMOR,
	CA_AI_CIVILIAN1_ARMOR,
	CA_AI_CIVILIAN2_ARMOR,
	CA_AI_OFFICER_ARMOR,
	CA_AI_TROOPER_ARMOR,
	CA_AI_ETROOPER_ARMOR,
	CA_AI_STROOPER_ARMOR,
	CA_AI_ESTROOPER_ARMOR,
	CA_AI_AVC_ARMOR,
	CA_AI_OMONI_ARMOR,
	CA_AI_ANUBIS_ARMOR,
	CA_AI_ENFORCER_ARMOR,
	CA_AI_PREDATOR_ARMOR,
	CA_AI_ASSASSIN_ARMOR,
	CA_AI_ANDRA5_ARMOR,
	CA_AI_ANDRA10_ARMOR,
	CA_AI_RAKSHA_ARMOR,
	CA_AI_TENMA_ARMOR,
	CA_AI_COTHINEAL_ARMOR,
	CA_AI_MECH02_ARMOR,
	CA_AI_VADER_ARMOR,
	CA_AI_RASCAL_ARMOR,
	CA_AI_VIGILANCE_ARMOR,
	CA_AI_HAMMERHEAD_ARMOR,
	CA_AI_VANDAL_ARMOR,
	CA_AI_SPARROWHAWK_ARMOR,
	CA_AI_RUIN150_ARMOR,
	CA_AI_UHLANA3_ARMOR,
	CA_AI_DOODLEMECH_ARMOR,
	CA_AI_ASSAULTDOODLEMECH_ARMOR,
	CA_AI_ALIENWALKER_ARMOR,
	CA_AI_ALIENSONIC_ARMOR,
	CA_AI_AMBER_ARMOR,
	CA_AI_WOLF_ARMOR,
	CA_AI_OHATO_ARMOR,
	CA_AI_TIGER_ARMOR,
	CA_AI_FUJI_ARMOR,
	CA_AI_TASAKA_ARMOR,
	CA_AI_KATOBOSS_ARMOR,
	CA_AI_BAKU_ARMOR,
	CA_AI_SAMANTHA_ARMOR,
	CA_AI_SALIEN_ARMOR,
	CA_AI_ALIENSTALKER_ARMOR,
	CA_AI_BUG_ARMOR,
	CA_AI_ALIENPROBE_ARMOR,
	CA_AI_ALIENSEARCHER_ARMOR,
	CA_AI_MUTANT_ARMOR
};

DFLOAT s_fCharacterMaxArmor[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MAX_ARMOR,		// Sanjuro
	CA_PLAYER_KID_MAX_ARMOR,		// Kid
	CA_PLAYER_ANUBIS_MAX_ARMOR,		// Player Akuma
	CA_PLAYER_PREDATOR_MAX_ARMOR,	// Player Predator
	CA_PLAYER_OMONI_MAX_ARMOR,		// Player Ordog
	CA_PLAYER_ENFORCER_MAX_ARMOR,	// Player Enforcer
	CA_PLAYER_DOKUSHU_MAX_ARMOR,	// Player Dokushu
	CA_PLAYER_GCDM_MAX_ARMOR,		// Player GCDM
	CA_AI_LITTLEKID_MAX_ARMOR,
	CA_AI_LITTLEKID_MAX_ARMOR,
	CA_AI_CIVILIAN1_MAX_ARMOR,
	CA_AI_CIVILIAN1_MAX_ARMOR,
	CA_AI_CIVILIAN2_MAX_ARMOR,
	CA_AI_OFFICER_MAX_ARMOR,
	CA_AI_TROOPER_MAX_ARMOR,
	CA_AI_ETROOPER_MAX_ARMOR,
	CA_AI_STROOPER_MAX_ARMOR,
	CA_AI_ESTROOPER_MAX_ARMOR,
	CA_AI_AVC_MAX_ARMOR,
	CA_AI_OMONI_MAX_ARMOR,
	CA_AI_ANUBIS_MAX_ARMOR,
	CA_AI_ENFORCER_MAX_ARMOR,
	CA_AI_PREDATOR_MAX_ARMOR,
	CA_AI_ASSASSIN_MAX_ARMOR,
	CA_AI_ANDRA5_MAX_ARMOR,
	CA_AI_ANDRA10_MAX_ARMOR,
	CA_AI_RAKSHA_MAX_ARMOR,
	CA_AI_TENMA_MAX_ARMOR,
	CA_AI_COTHINEAL_MAX_ARMOR,
	CA_AI_MECH02_MAX_ARMOR,
	CA_AI_VADER_MAX_ARMOR,
	CA_AI_RASCAL_MAX_ARMOR,
	CA_AI_VIGILANCE_MAX_ARMOR,
	CA_AI_HAMMERHEAD_MAX_ARMOR,
	CA_AI_VANDAL_MAX_ARMOR,
	CA_AI_SPARROWHAWK_MAX_ARMOR,
	CA_AI_RUIN150_MAX_ARMOR,
	CA_AI_UHLANA3_MAX_ARMOR,
	CA_AI_DOODLEMECH_MAX_ARMOR,
	CA_AI_ASSAULTDOODLEMECH_MAX_ARMOR,
	CA_AI_ALIENWALKER_MAX_ARMOR,
	CA_AI_ALIENSONIC_MAX_ARMOR,
	CA_AI_AMBER_MAX_ARMOR,
	CA_AI_WOLF_MAX_ARMOR,
	CA_AI_OHATO_MAX_ARMOR,
	CA_AI_TIGER_MAX_ARMOR,
	CA_AI_FUJI_MAX_ARMOR,
	CA_AI_TASAKA_MAX_ARMOR,
	CA_AI_KATOBOSS_MAX_ARMOR,
	CA_AI_BAKU_MAX_ARMOR,
	CA_AI_SAMANTHA_MAX_ARMOR,
	CA_AI_SALIEN_MAX_ARMOR,
	CA_AI_ALIENSTALKER_MAX_ARMOR,
	CA_AI_BUG_MAX_ARMOR,
	CA_AI_ALIENPROBE_MAX_ARMOR,
	CA_AI_ALIENSEARCHER_MAX_ARMOR,
	CA_AI_MUTANT_MAX_ARMOR
};

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMass
//
//	PURPOSE:	Return the mass associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMass(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MASS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMasses[nId];

	if (nId == MI_AI_BAKU_ID && size == MS_LARGE)
	{
		fRet = CA_AI_BAKU_MECHA_MASS;
	}

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultHitPts
//
//	PURPOSE:	Return the hit pts associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultHitPts(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_HITPTS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterHitPts[nId];

	if (nId == MI_AI_BAKU_ID && size == MS_LARGE)
	{
		fRet = CA_AI_BAKU_MECHA_HITPTS;
	}

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMaxHitPts
//
//	PURPOSE:	Return the max hit pts associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMaxHitPts(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MAX_HITPTS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMaxHitPts[nId];

	if (nId == MI_AI_BAKU_ID && size == MS_LARGE)
	{
		fRet = CA_AI_BAKU_MECHA_MAX_HITPTS;
	}

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultArmor
//
//	PURPOSE:	Return the armor associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultArmor(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_ARMOR;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterArmor[nId];

	if (nId == MI_AI_BAKU_ID && size == MS_LARGE)
	{
		fRet = CA_AI_BAKU_MECHA_ARMOR;
	}

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMaxArmor
//
//	PURPOSE:	Return the max armor associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMaxArmor(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MAX_ARMOR;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMaxArmor[nId];

	if (nId == MI_AI_BAKU_ID && size == MS_LARGE)
	{
		fRet = CA_AI_BAKU_MECHA_MAX_ARMOR;
	}

	return fRet;
}
