#ifndef __WEAPONSTRINGDEFS_H
#define __WEAPONSTRINGDEFS_H

#include "WeaponDefs.h"
#include "ClientRes.h"

inline char* GetWeaponString(RiotWeaponId nWeaponId)
{
	if (!g_pClientDE) return "Error";

	DDWORD nStringID = IDS_UNUSED;

	switch (nWeaponId)
	{
		case GUN_AMBEDKATOBURST_ID :
			nStringID = IDS_WEAPON_AMBEDKATOBURST;
		break;

		case GUN_SPIDER_ID :
			nStringID = IDS_WEAPON_SPIDER;
		break;

		case GUN_BULLGUT_ID :
			nStringID = IDS_WEAPON_BULLGUT;
		break;

		case GUN_AMBEDMORT_ID :
			nStringID = IDS_WEAPON_AMBEDMORT;
		break;

		case GUN_SNIPERRIFLE_ID :
			nStringID = IDS_WEAPON_SNIPERRIFLE;
		break;

		case GUN_AMBEDSHOCHI_ID :
			nStringID = IDS_WEAPON_AMBEDSHOCHI;
		break;

		case GUN_SHREDDER_ID :
			nStringID = IDS_WEAPON_SHREDDER;
		break;

		case GUN_AMBEDHWAR_ID :
			nStringID = IDS_WEAPON_AMBEDHWAR;
		break;

		case GUN_ENERGYBATON_ID :
			nStringID = IDS_WEAPON_ENERGYBATON;
		break;

		case GUN_ENERGYBLADE_ID :
			nStringID = IDS_WEAPON_ENERGYBLADE;
		break;

		case GUN_KATANA_ID :
			nStringID = IDS_WEAPON_KATANA;
		break;

		case GUN_AMBEDKATOAXE_ID :
			nStringID = IDS_WEAPON_AMBEDKATOAXE;
		break;


		// On-foot mode weapons...

		case GUN_AMBEDEMS_ID : // new ev - 12/1/99 changing COLT45 to Ambed EMS
			nStringID = IDS_WEAPON_AMBEDEMS;
		break;

		case GUN_AMBEDAGUMA_ID	: // new ev - 12/1/99 changing Shotgun to Ambed Aguma
			nStringID = IDS_WEAPON_AMBEDAGUMA;
		break;

		case GUN_ASSAULTRIFLE_ID :
			nStringID = IDS_WEAPON_ASSAULTRIFLE;
		break;

		case GUN_ENERGYGRENADE_ID :
			nStringID = IDS_WEAPON_ENERGYGRENADE;
		break;

		case GUN_AMBEDRASG_ID :
			nStringID = IDS_WEAPON_AMBEDRASG;
		break;

		case GUN_TOW_ID	:
			nStringID = IDS_WEAPON_TOW;
		break;

		case GUN_LASERCANNON_ID :
			nStringID = IDS_WEAPON_LASERCANNON;
		break;

		case GUN_AMBEDMINIGUN_ID :
			nStringID = IDS_WEAPON_AMBEDMINIGUN;
		break;
		
		case GUN_AMBEDDRILL_ID :
			nStringID = IDS_WEAPON_AMBEDDRILL;
		break;

		case GUN_AMBEDPROXIMITYMINE_ID :
			nStringID = IDS_WEAPON_AMBEDPROXIMITYMINE;
		break;

		default : break;
	}

	HSTRING hStr = g_pClientDE->FormatString (nStringID);
	if (!hStr) return "Error";

	static char strWeapon[128];
	SAFE_STRCPY(strWeapon, g_pClientDE->GetStringData (hStr));
	g_pClientDE->FreeString (hStr);

	return strWeapon;
}

inline char* GetAmmoString(RiotWeaponId nWeaponId)
{
	if (!g_pClientDE) return "Error";

	DDWORD nStringID = IDS_UNUSED;

	switch (nWeaponId)
	{
		// Mech mode weapons...	
	
		case GUN_AMBEDKATOBURST_ID :
			nStringID = IDS_AMMO_AMBEDKATOBURST;
		break;

		case GUN_SPIDER_ID :
			nStringID = IDS_AMMO_SPIDER;
		break;

		case GUN_BULLGUT_ID :
			nStringID = IDS_AMMO_BULLGUT;
		break;

		case GUN_AMBEDMORT_ID :
			nStringID = IDS_AMMO_AMBEDMORT;
		break;

		case GUN_SNIPERRIFLE_ID :
			nStringID = IDS_AMMO_SNIPERRIFLE;
		break;

		case GUN_AMBEDSHOCHI_ID :
			nStringID = IDS_AMMO_AMBEDSHOCHI;
		break;

		case GUN_SHREDDER_ID :
			nStringID = IDS_AMMO_SHREDDER;
		break;

		case GUN_AMBEDHWAR_ID :
			nStringID = IDS_AMMO_AMBEDHWAR;
		break;

		// On-foot mode weapons...

		case GUN_AMBEDEMS_ID :  // new ev - 12/1/99 changing COLT45 to Ambed EMS
			nStringID = IDS_AMMO_AMBEDEMS;
		break;

		case GUN_AMBEDAGUMA_ID	:  // new ev - 12/1/99 changing Shotgun to Ambed Aguma
			nStringID = IDS_AMMO_AMBEDAGUMA;
		break;

		case GUN_ASSAULTRIFLE_ID :
			nStringID = IDS_AMMO_ASSAULTRIFLE;
		break;

		case GUN_AMBEDPROXIMITYMINE_ID :
			nStringID = IDS_AMMO_AMBEDPROXIMITYMINE;
		break;

		case GUN_ENERGYGRENADE_ID :
			nStringID = IDS_AMMO_ENERGYGRENADE;
		break;

		case GUN_AMBEDRASG_ID :
			nStringID = IDS_AMMO_AMBEDRASG;
		break;

		case GUN_TOW_ID	:
			nStringID = IDS_AMMO_TOW;
		break;

		case GUN_LASERCANNON_ID :
			nStringID = IDS_AMMO_LASERCANNON;
		break;

		case GUN_AMBEDMINIGUN_ID :
			nStringID = IDS_AMMO_AMBEDMINIGUN;
		break;
		
		default : break;
	}

	HSTRING hStr = g_pClientDE->FormatString (nStringID);
	if (!hStr) return "Error";

	static char strAmmo[128];
	SAFE_STRCPY(strAmmo, g_pClientDE->GetStringData (hStr));
	g_pClientDE->FreeString (hStr);

	return strAmmo;
}

inline RiotWeaponId GetWeaponId(char* pWeaponName)
{
	if (!pWeaponName || strlen(pWeaponName) < 5) return GUN_NONE;

	for(int i=GUN_FIRST_ID; i < GUN_MAX_PLAYER; i++)
	{
		if (_stricmp(pWeaponName, GetWeaponString((RiotWeaponId)i)) == 0)
		{
			return ((RiotWeaponId)i);
		}
	}

	return GUN_NONE;
}

#endif
