// ----------------------------------------------------------------------- //
//
// MODULE  : ModelFuncs.cpp
//
// PURPOSE : Model related utility functions
//
// CREATED : 7/6/98
//
// ----------------------------------------------------------------------- //

#include "ModelFuncs.h"
#include "ModelIds.h"
#include "CharacterAlignment.h"
#include "GibTypes.h"

extern int GetRandom(int, int);

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetModel
//
//	PURPOSE:	Return the model associated with a particular id
//
// ----------------------------------------------------------------------- //

char* GetModel(DBYTE nId, ModelSize size)
{
	char* pRet = "Models\\Default.abc";

	switch (nId)
	{
		// PLAYER MODELS ///////////////////////////////////////////////////

		case MI_PLAYER_ONFOOT_ID:
			pRet = "Models\\Player\\sanjuro.abc";
		break;

		case MI_PLAYER_KID_ID:
			pRet = "Models\\Player\\kid.abc";
		break;

		case MI_PLAYER_SNIPER_ID:
			pRet = "Models\\Player\\Sniper.abc";
		break;

		case MI_PLAYER_HEAVYW_ID:
			pRet = "Models\\Player\\HEAVYW.abc";
		break;

		case MI_PLAYER_DEMOMAN_ID:
			pRet = "Models\\Player\\Demoman.abc";
		break;

		case MI_PLAYER_ROCKETEER_ID:
			pRet = "Models\\Player\\Rocketeer.abc";
		break;

		// DTM NEW CLASSES

		case MI_PLAYER_MEDIC_ID:
			pRet = "Models\\Player\\Medic.abc";
		break;

		case MI_PLAYER_SOLDIER_ID:
			pRet = "Models\\Player\\Soldier.abc";
		break;

		default : break;
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetSkin
//
//	PURPOSE:	Return the skin associated with a particular id
//
// ----------------------------------------------------------------------- //
// char* GetSkin(DBYTE nId, CharacterClass cc, ModelSize size, DBOOL bMulti)
// DTM SKINS
char* GetSkin(DBYTE nId, DBYTE team, ModelSize size, DBOOL bMulti)
{
	char* pRet = DNULL;

	switch (nId)
	{
		// PLAYER SKINS ///////////////////////////////////////////////////

		case MI_PLAYER_ONFOOT_ID:
			pRet = bMulti ? "Skins\\Player\\SanjuroM.dtx" : "Skins\\Player\\Sanjuro.dtx";
		break;

		case MI_PLAYER_KID_ID:
			pRet = bMulti ? "Skins\\Player\\kid.dtx" : "Skins\\Player\\kid.dtx";
		break;

		case MI_PLAYER_SNIPER_ID:
			if (team !=0) pRet = "Skins\\Player\\SniperR.dtx";
			else pRet = "Skins\\Player\\SniperB.dtx";
		break;

		case MI_PLAYER_HEAVYW_ID:
			if (team !=0) pRet = "Skins\\Player\\HeavywR.dtx";
			else pRet = "Skins\\Player\\HeavywB.dtx";
		break;

		case MI_PLAYER_DEMOMAN_ID:
			if (team !=0) pRet = "Skins\\Player\\demomanR.dtx";
			else pRet = "Skins\\Player\\demomanB.dtx";
		break;

		case MI_PLAYER_ROCKETEER_ID:
			if (team !=0) pRet = "Skins\\Player\\rocketeerR.dtx";
			else pRet = "Skins\\Player\\rocketeerB.dtx";
		break;

		// DTM NEW CLASSES
		case MI_PLAYER_MEDIC_ID:
			if (team !=0) pRet = "Skins\\Player\\MedicR.dtx";
			else pRet = "Skins\\Player\\MedicB.dtx";
		break;
		
		case MI_PLAYER_SOLDIER_ID:
			if (team !=0) pRet = "Skins\\Player\\SoldierR.dtx";
			else pRet = "Skins\\Player\\SoldierB.dtx";
		break;

		default : break;
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetGibModel
//
//	PURPOSE:	Return the gib model associated with a particular id
//
// ----------------------------------------------------------------------- //

char* GetGibModel(DBYTE nId, GibType eType, ModelSize size)
{
	char* pFile = DNULL;

	switch (nId)
	{
		// MECHA MODELS ////////////////////////////////////////////////////

		case MI_PLAYER_SNIPER_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Sniper\\Sniper_head.abc",
				"Models\\Gibs\\Sniper\\Sniper_larm.abc",
				"Models\\Gibs\\Sniper\\Sniper_rarm.abc",
				"Models\\Gibs\\Sniper\\Sniper_lleg.abc",
				"Models\\Gibs\\Sniper\\Sniper_rleg.abc",
				"Models\\Gibs\\Sniper\\Sniper_ubody.abc",
				"Models\\Gibs\\Sniper\\Sniper_lbody.abc",
				"Models\\Player\\Sniper.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;

		case MI_PLAYER_DEMOMAN_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Demoman\\Demoman_head.abc",
				"Models\\Gibs\\Demoman\\Demoman_larm.abc",
				"Models\\Gibs\\Demoman\\Demoman_rarm.abc",
				"Models\\Gibs\\Demoman\\Demoman_lleg.abc",
				"Models\\Gibs\\Demoman\\Demoman_rleg.abc",
				"Models\\Gibs\\Demoman\\Demoman_ubody.abc",
				"Models\\Gibs\\Demoman\\Demoman_lbody.abc",
				"Models\\Player\\Demoman.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;
		case MI_PLAYER_HEAVYW_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Heavyw\\Heavyw_head.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_larm.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_rarm.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_lleg.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_rleg.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_ubody.abc",
				"Models\\Gibs\\Heavyw\\Heavyw_lbody.abc",
				"Models\\Player\\Heavyw.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;

		case MI_PLAYER_ROCKETEER_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Rocketeer\\Rocketeer_head.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_larm.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_rarm.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_lleg.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_rleg.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_ubody.abc",
				"Models\\Gibs\\Rocketeer\\Rocketeer_lbody.abc",
				"Models\\Player\\Rocketeer.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;

		// DTM NEW CLASSES
		case MI_PLAYER_MEDIC_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Medic\\Medic_head.abc",
				"Models\\Gibs\\Medic\\Medic_larm.abc",
				"Models\\Gibs\\Medic\\Medic_rarm.abc",
				"Models\\Gibs\\Medic\\Medic_lleg.abc",
				"Models\\Gibs\\Medic\\Medic_rleg.abc",
				"Models\\Gibs\\Medic\\Medic_ubody.abc",
				"Models\\Gibs\\Medic\\Medic_lbody.abc",
				"Models\\Player\\Medic.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;
		
		case MI_PLAYER_SOLDIER_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Soldier\\Soldier_head.abc",
				"Models\\Gibs\\Soldier\\Soldier_larm.abc",
				"Models\\Gibs\\Soldier\\Soldier_rarm.abc",
				"Models\\Gibs\\Soldier\\Soldier_lleg.abc",
				"Models\\Gibs\\Soldier\\Soldier_rleg.abc",
				"Models\\Gibs\\Soldier\\Soldier_ubody.abc",
				"Models\\Gibs\\Soldier\\Soldier_lbody.abc",
				"Models\\Player\\Soldier.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;


		case MI_PLAYER_ONFOOT_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\Sanjuro\\Sanjuro_head.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_larm.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_rarm.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_lleg.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_rleg.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_ubody.abc",
				"Models\\Gibs\\Sanjuro\\Sanjuro_lbody.abc",
				"Models\\Player\\Sanjuro.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;

		case MI_PLAYER_KID_ID:
		{
			char* GibFiles[] = 
			{
				"Models\\Gibs\\LittleBoy\\LittleBoy_head.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_larm.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_rarm.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_lleg.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_rleg.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_ubody.abc",
				"Models\\Gibs\\LittleBoy\\LittleBoy_lbody.abc",
				"Models\\Enemies\\Onfoot\\LittleBoy.abc"
			};

			if (GT_FIRST <= eType && eType < GT_LAST)
			{
				pFile = GibFiles[eType];
			}
		}
		break;

		default : break;
	}

	return pFile;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetModelType
//
//	PURPOSE:	Return the type of the model
//
// ----------------------------------------------------------------------- //

ModelType GetModelType(DBYTE nId, ModelSize size)
{
	ModelType eType = MT_UNSPECIFIED;

	switch (nId)
	{
		case MI_PLAYER_SNIPER_ID:
		case MI_PLAYER_HEAVYW_ID:
		case MI_PLAYER_DEMOMAN_ID:
		case MI_PLAYER_ROCKETEER_ID:
		// DTM NEW CLASSES
		case MI_PLAYER_MEDIC_ID:
		case MI_PLAYER_SOLDIER_ID:
			eType = MT_MECHA;
		break;

		// HUMAN MODELS ////////////////////////////////////////////////////

		case MI_PLAYER_ONFOOT_ID:
		case MI_PLAYER_KID_ID:
			eType = MT_HUMAN;
		break;
	}

	return eType;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetTurretFilename
//
//	PURPOSE:	Return the turret model associated with a particular id
//
// ----------------------------------------------------------------------- //

char* GetTurretFilename(DBYTE nId, ModelSize size)
{
	char* pRet = DNULL;

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetModelName
//
//	PURPOSE:	Return the model name associated with a particular id
//
// ----------------------------------------------------------------------- //

char* GetModelName(DBYTE nId, ModelSize size)
{
	char* pName = DNULL;

	switch (nId)
	{
		case MI_PLAYER_SNIPER_ID:
			pName = "Sniper";
		break;

		case MI_PLAYER_HEAVYW_ID:
			pName = "Heavyw";
		break;

		case MI_PLAYER_DEMOMAN_ID:
			pName = "Demoman";
		break;

		case MI_PLAYER_ROCKETEER_ID:
			pName = "Rocketeer";
		break;

		// DTM NEW CLASSES
		case MI_PLAYER_MEDIC_ID:
			pName = "Medic";
		break;

		case MI_PLAYER_SOLDIER_ID:
			pName = "Soldier";
		break;

		case MI_PLAYER_ONFOOT_ID:
			pName = "Sanjuro";
		break;

		case MI_PLAYER_KID_ID:
			pName = "Kid";
		break;

	}

	return pName;
}
