// ----------------------------------------------------------------------- //
//
// MODULE  : Teleporter.cpp
//
// PURPOSE : Teleporter - Definition
//
// CREATED : 6/7/99
//
// ----------------------------------------------------------------------- //

#include "Teleporter.h"
#include "cpp_server_de.h"
#include "PlayerModeTypes.h"
#include "RiotServerShell.h"
#include "RiotObjectUtilities.h"
#include "CachedFiles.h"
#include "DebrisTypes.h"
#include "SurfaceFunctions.h"
#include "PlayerObj.h"

extern CRiotServerShell* g_pRiotServerShellDE;


BEGIN_CLASS(Teleporter)
	ADD_VECTORPROP_VAL(DestinationPoint, 0.0f, 0.0f, 0.0f)
	ADD_VECTORPROP_VAL(DestinationRotation, 0.0f, 0.0f, 0.0f)
	ADD_VECTORPROP_VAL(Scale, 1.0f, 1.0f, 1.0f)
	ADD_STRINGPROP(TriggerTarget, "")
	ADD_STRINGPROP(TriggerMessage, "")
END_CLASS_DEFAULT(Teleporter, BaseClass, NULL, NULL)

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Teleporter::Teleporter
//
//	PURPOSE:	Initialize
//
// ----------------------------------------------------------------------- //

Teleporter::Teleporter() : Prop()
{ 
	m_hstrName				= DNULL;
	m_hstrTriggerTarget		= DNULL;
	m_hstrTriggerMessage	= DNULL;
	VEC_INIT(m_vPitchYawRoll);
	VEC_INIT(m_vDestination);
	VEC_INIT(m_vScale);

	m_fMass = 100000.0f;

	m_fHitPoints = 0.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Teleporter::~Teleporter
//
//	PURPOSE:	Deallocate
//
// ----------------------------------------------------------------------- //

Teleporter::~Teleporter()
{ 
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	if (m_hstrName)
	{
		pServerDE->FreeString(m_hstrName);
	}

	if (m_hstrTriggerTarget)
	{
		pServerDE->FreeString(m_hstrTriggerTarget);
	}

	if (m_hstrTriggerMessage)
	{
		pServerDE->FreeString(m_hstrTriggerMessage);
	}
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Teleporter::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //

DDWORD Teleporter::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return 0;

	DDWORD dwRet = Prop::EngineMessageFn(messageID, pData, fData);

	switch(messageID)
	{
		case MID_PRECREATE:
		{
			ObjectCreateStruct *pStruct = (ObjectCreateStruct*)pData;

			if (pStruct)
			{
				if (fData == PRECREATE_WORLDFILE)
				{
					ReadProp(pStruct);
				}

				SAFE_STRCPY(pStruct->m_Filename, "models\\powerups\\telering.abc");
					
				SAFE_STRCPY(pStruct->m_SkinName, "skins\\weapons\\fractal.dtx");

				SAFE_STRCPY(pStruct->m_Name, "Teleporter");

				ROT_COPY(pStruct->m_Rotation, m_rRotation);
			}			

			break;
		}

		case MID_INITIALUPDATE:
		{
			pServerDE->SetObjectFlags(m_hObject, FLAG_VISIBLE|FLAG_TOUCH_NOTIFY|FLAG_GRAVITY|FLAG_FORCECLIENTUPDATE|FLAG_SOLID|FLAG_BOXPHYSICS);
			
			DVector vDims;
			// Set the dims based on the current animation...
			g_pServerDE->GetModelAnimUserDims(m_hObject, &vDims, g_pServerDE->GetModelAnimation(m_hObject));
			//g_pServerDE->SetObjectDims(m_hObject, &vDims);

			g_pServerDE->CPrint("Model Dims from ModelEdit : %f, %f, %f", vDims.x, vDims.y, vDims.z);
			g_pServerDE->CPrint("Scale of the model from DEdit : %f, %f, %f", m_vScale.x, m_vScale.y, m_vScale.z);
			
			
			DVector vNewDims;

			// Set object dims based on scale value...

			vNewDims.x = m_vScale.x * vDims.x;
			vNewDims.y = m_vScale.y * vDims.y;
			vNewDims.z = m_vScale.z * vDims.z;

			g_pServerDE->CPrint("We set the new dims to : %f, %f, %f", vNewDims.x, vNewDims.y, vNewDims.z);

			g_pServerDE->ScaleObject(m_hObject, &m_vScale);
			g_pServerDE->SetObjectDims(m_hObject, &vNewDims);
				
			pServerDE->SetObjectMass(m_hObject, m_fMass);
						
			pServerDE->SetObjectRotation(m_hObject, &m_rRotation);
			
			
			m_Damage.SetCanDamage( DFALSE );
			
			pServerDE->SetNextUpdate(m_hObject, 0.1f);
			return dwRet;
		}
		break;

		case MID_TOUCHNOTIFY:
		{
			ObjectTouch((HOBJECT)pData);
		}
		break;

		default : break;
	}

	return dwRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Teleporter::ReadProp
//
//	PURPOSE:	Set property value
//
// ----------------------------------------------------------------------- //

DBOOL Teleporter::ReadProp(ObjectCreateStruct *pData)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE || !pData) return DFALSE;

	char buf[MAX_CS_FILENAME_LEN];
	buf[0] = '\0';
	pServerDE->GetPropString("Name", buf, MAX_CS_FILENAME_LEN);
	if (buf[0]) m_hstrName = pServerDE->CreateString(buf);

	pServerDE->GetPropVector("DestinationPoint", &m_vDestination);
	pServerDE->GetPropVector("DestinationRotation", &m_vPitchYawRoll);
	pServerDE->GetPropVector("Scale", &m_vScale);

	pServerDE->GetPropRotation("Rotation", &m_rRotation);
	
	GenericProp genProp;
	if (pServerDE->GetPropGeneric("TriggerTarget", &genProp) == DE_OK)
	{
		if (genProp.m_String[0])
		{
			m_hstrTriggerTarget = pServerDE->CreateString(genProp.m_String);
		}
	}

	if (pServerDE->GetPropGeneric("TriggerMessage", &genProp) == DE_OK)
	{
		if (genProp.m_String[0])
		{
			m_hstrTriggerMessage = pServerDE->CreateString(genProp.m_String);
		}
	}

	return DTRUE;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Teleporter::ObjectTouch
//
//	PURPOSE:	Handle object touch
//
// ----------------------------------------------------------------------- //

void Teleporter::ObjectTouch(HOBJECT hObj)
{
	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE) return;

	HCLASS hClassBaseCharacter = pServerDE->GetClass("CBaseCharacter");
	HCLASS hClassObj		   = pServerDE->GetObjectClass(hObj);
	
	if (!pServerDE->IsKindOf(hClassObj, hClassBaseCharacter))
	{
		return;
	}

	CPlayerObj* pPlayer = (CPlayerObj*)pServerDE->HandleToObject(hObj);

	if (pPlayer)
	{
		pPlayer->Teleport(m_vDestination, m_vPitchYawRoll);
	}
}
