// ----------------------------------------------------------------------- //
//
// MODULE  : RiotWeapons.cpp
//
// PURPOSE : Riot Weapons - Implementation of the Riot weapon classes
//
// CREATED : 9/30/97
//
// ----------------------------------------------------------------------- //

#include "RiotWeapons.h"
#include "cpp_server_de.h"
#include "PlayerObj.h"
#include "WeaponFXTypes.h"


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CPulseRifle::CPulseRifle
//
//	PURPOSE:	Create the pulse rifle gun
//
// ----------------------------------------------------------------------- //

CPulseRifle::CPulseRifle() : CWeapon()
{
	m_nId			 = GUN_PULSERIFLE_ID;
	m_eDamageType	 = DT_ENERGY;

	m_pHandWeaponName	= "Models\\Powerups\\PulseRifle.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\PulseRifle_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 1.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CPulseRifle::CPulseRifle
//
//	PURPOSE:	Create the pulse rifle projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CPulseRifle::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CPulseRifleProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CRiotCannon::CRiotCannon
//
//	PURPOSE:	Create the RiotCannon gun
//
// ----------------------------------------------------------------------- //

CRiotCannon::CRiotCannon() : CWeapon()
{	
	m_nId			 = GUN_RIOTCANNON_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\RiotCannon.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\RiotCannon_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 4.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}
/*
// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CRiotCannon::CreateProjectile
//
//	PURPOSE:	Create the RiotCannon projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CRiotCannon::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CRiotCannonProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}
*/

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CPulseLauncher::CPulseLauncher
//
//	PURPOSE:	Create the PulseLauncher gun
//
// ----------------------------------------------------------------------- //

CPulseLauncher::CPulseLauncher() : CWeapon()
{
	m_nId			 = GUN_PULSELAUNCHER_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\PulseLauncher.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\PulseLauncher_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CPulseLauncher::CreateProjectile
//
//	PURPOSE:	Create the PulseLauncher projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CPulseLauncher::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CGrenadeProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CMassDriver::CMassDriver
//
//	PURPOSE:	Create the mass driver gun
//
// ----------------------------------------------------------------------- //

CMassDriver::CMassDriver() : CWeapon()
{
	m_nId			 = GUN_MASSDRIVER_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\Juggernaut.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Juggernaut_a.dtx";

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CMassDriver::CreateProjectile
//
//	PURPOSE:	Create the MassDriver projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CMassDriver::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CJuggernautProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CDeathCharge::CDeathCharge
//
//	PURPOSE:	Create the DeathCharge gun
//
// ----------------------------------------------------------------------- //

CDeathCharge::CDeathCharge() : CWeapon()
{
	m_nId			 = GUN_DEATHCHARGE_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_bCanLockOnTarget	= DTRUE;

	m_pHandWeaponName	= "Models\\Powerups\\DeathCharge.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\DeathCharge_a.dtx";

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CDeathCharge::CreateProjectile
//
//	PURPOSE:	Create the DeathCharge projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CDeathCharge::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CDChargeGrenadeProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CLithKiller::CLithKiller
//
//	PURPOSE:	Create the LithKiller gun
//
// ----------------------------------------------------------------------- //

CLithKiller::CLithKiller() : CWeapon()
{
	m_nId			 = GUN_LITHKILLER_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\LithKiller.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\LithKiller_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);
	
	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 20.0f;
	m_fMaxFireRest		= 30.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CLithKiller::CreateProjectile
//
//	PURPOSE:	Create the LithKiller projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CLithKiller::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CTOWProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CSniperRifle::CSniperRifle
//
//	PURPOSE:	Create the sniper rifle gun
//
// ----------------------------------------------------------------------- //

CSniperRifle::CSniperRifle() : CWeapon()
{
	m_nId			 = GUN_SNIPERRIFLE_ID;
	m_eDamageType	 = DT_BURST;

	m_pHandWeaponName	= "Models\\Powerups\\SniperRifle.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\SniperRifle_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fZoomDamageMult	= 33.0f; //DTM
	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBuzzsaw::CBuzzsaw
//
//	PURPOSE:	Create the energy baton
//
// ----------------------------------------------------------------------- //

CBuzzsaw::CBuzzsaw() : CWeapon()
{
	m_nId			 = GUN_BUZZSAW_ID;
	m_eDamageType	 = DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\buzzsaw.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\buzzsaw_a.dtx";

//	m_bInfiniteAmmo	= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAxe::CAxe
//
//	PURPOSE:	Create the Axe
//
// ----------------------------------------------------------------------- //

CAxe::CAxe() : CWeapon()
{
	m_nId			 = GUN_AXE_ID;
	m_eDamageType	 = DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\axe.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\axe_a.dtx";

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CEnergyBlade::CEnergyBlade
//
//	PURPOSE:	Create the energy blade
//
// ----------------------------------------------------------------------- //

CShoulderCannons::CShoulderCannons() : CWeapon()
{
	m_nId			 = GUN_SHOULDERCANNONS_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\ShoulderCannons.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\ShoulderCannons_a.dtx";

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CShoulderCannons::CreateProjectile
//
//	PURPOSE:	Create the ShoulderCannon projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CShoulderCannons::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CJuggernautProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBigBoot::CBigBoot
//
//	PURPOSE:	Create the BigBoot
//
// ----------------------------------------------------------------------- //

CBigBoot::CBigBoot() : CWeapon()
{
	m_nId			 = GUN_BIGBOOT_ID;
	m_eDamageType	 = DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\BigBoot.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\BigBoot_a.dtx";

	m_bInfiniteAmmo	= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CSniperClub::CSniperClub
//
//	PURPOSE:	Create the Sniper Club
//
// ----------------------------------------------------------------------- //

CSniperClub::CSniperClub() : CWeapon()
{
	m_nId			 = GUN_SNIPERCLUB_ID;
	m_eDamageType	 = DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\SniperClub.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\SniperClub_a.dtx";

	m_bInfiniteAmmo	= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CMachineGun::CMachineGun
//
//	PURPOSE:	Create the Machine Gun
//
// ----------------------------------------------------------------------- //

CMachineGun::CMachineGun() : CWeapon()
{
	m_nId			 = GUN_MACHINEGUN_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\MachineGun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\MachineGun_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CRocketLauncher::CRocketLauncher
//
//	PURPOSE:	Create the Rocket Launcher
//
// ----------------------------------------------------------------------- //

CRocketLauncher::CRocketLauncher() : CWeapon()
{
	m_nId			 = GUN_ROCKETLAUNCHER_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\RocketLauncher.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\RocketLauncher_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);
	
	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 5.0f;
	m_fMinFireRest		= 2.0f;
	m_fMaxFireRest		= 5.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CRocketLauncher::CreateProjectile
//
//	PURPOSE:	Create the rocket launcher projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CRocketLauncher::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CTOWProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// On-foot weapons...

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CColt45::CColt45
//
//	PURPOSE:	Create the colt 45 gun
//
// ----------------------------------------------------------------------- //

CColt45::CColt45() : CWeapon()
{
	m_nId			 = GUN_COLT45_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Colt45.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Colt45_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CShotgun::CShotgun
//
//	PURPOSE:	Create the shotgun
//
// ----------------------------------------------------------------------- //

CShotgun::CShotgun() : CWeapon()
{
	m_nId			 = GUN_SHOTGUN_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Shotgun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Shotgun_a.dtx";

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 1.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CMac10::CMac10
//
//	PURPOSE:	Create the mac 10 machine gun
//
// ----------------------------------------------------------------------- //

CMac10::CMac10() : CWeapon()
{
	m_nId			 = GUN_MAC10_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\Machinegun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Machinegun_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAssaultRifle::CAssaultRifle
//
//	PURPOSE:	Create the assault riffle
//
// ----------------------------------------------------------------------- //

CAssaultRifle::CAssaultRifle() : CWeapon()
{
	m_nId			 = GUN_ASSAULTRIFLE_ID;
	m_eDamageType	 = DT_PUNCTURE;

	m_pHandWeaponName	= "Models\\Powerups\\AssaultRifle.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\AssaultRifle_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fZoomDamageMult	= 1.5f;
	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 4.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CEnergyGrenade::CEnergyGrenade
//
//	PURPOSE:	Create the energy grenade launcher
// ----------------------------------------------------------------------- //

CEnergyGrenade::CEnergyGrenade() : CWeapon()
{
	m_nId			 = GUN_ENERGYGRENADE_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\EnergyGrenade.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\EnergyGrenade_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CEnergyGrenade::CreateProjectile
//
//	PURPOSE:	Create the energy grenade projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CEnergyGrenade::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CGrenadeProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBombs::CBombs
//
//	PURPOSE:	Create the Bombs
// ----------------------------------------------------------------------- //

CBombs::CBombs() : CWeapon()
{
	m_nId			 = GUN_BOMBS_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_pHandWeaponName	= "Models\\Powerups\\Bombs.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Bombs_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBombs::CreateProjectile
//
//	PURPOSE:	Create the bomb projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CBombs::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CGrenadeProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CTOW::CTOW
//
//	PURPOSE:	Create the TOW rocket launcher
//
// ----------------------------------------------------------------------- //

CTOW::CTOW() : CWeapon()
{
	m_nId			 = GUN_TOW_ID;
	m_eDamageType	 = DT_EXPLODE;

	m_bCanLockOnTarget	= DTRUE;

	m_pHandWeaponName	= "Models\\Powerups\\TOW.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\TOW_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CTOW::CreateProjectile
//
//	PURPOSE:	Create the TOW rocket launcher projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CTOW::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CTOWProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAutoCannons::CAutoCannons
//
//	PURPOSE:	Create the auto cannons
//
// ----------------------------------------------------------------------- //

CAutoCannons::CAutoCannons() : CWeapon()
{
	m_nId			 = GUN_AUTOCANNONS_ID;
	m_eDamageType	 = DT_ENERGY;

	m_pHandWeaponName	= "Models\\Powerups\\AutoCannons.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\AutoCannons_a.dtx";

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CAutoCannons::CAutoCannons
//
//	PURPOSE:	Create the pulse rifle projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CAutoCannons::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CAutoCannonsProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CHealGun::CHealGun
//
//	PURPOSE:	Create the Heal Gun
//
// ----------------------------------------------------------------------- //

CHealGun::CHealGun() : CWeapon()
{
	m_nId			 = GUN_HEALGUN_ID;
	m_eDamageType	 = DT_ENERGY;

	m_pHandWeaponName	= "Models\\Powerups\\HealGun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\HealGun_a.dtx";

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CSickGun::CSickGun
//
//	PURPOSE:	Create the Sick Gun
//
// ----------------------------------------------------------------------- //

CSickGun::CSickGun() : CWeapon()
{
	m_nId			 = GUN_SICKGUN_ID;
	m_eDamageType	 = DT_MAKESICK;

	m_pHandWeaponName	= "Models\\Powerups\\SickGun.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\SickGun_a.dtx";

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CBlinder::CBlinder
//
//	PURPOSE:	Create the Blinder Gun
//
// ----------------------------------------------------------------------- //

CBlinder::CBlinder() : CWeapon()
{
	m_nId			 = GUN_BLINDER_ID;
	m_eDamageType	 = DT_MAKEBLIND;

	m_pHandWeaponName	= "Models\\Powerups\\Blinder.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Blinder_a.dtx";

	m_fMinFireDuration	= 1.5f;
	m_fMaxFireDuration	= 3.0f;
	m_fMinFireRest		= 10.0f;
	m_fMaxFireRest		= 15.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CKatoGrenade::CKatoGrenade
//
//	PURPOSE:	Create the KatoGrenade rocket launcher
//
// ----------------------------------------------------------------------- //

CKatoGrenade::CKatoGrenade() : CWeapon()
{
	m_nId			 = GUN_KATOGRENADE_ID;
	m_eDamageType	 = DT_KATO;

	m_pHandWeaponName	= "Models\\Powerups\\KatoGrenade.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\KatoGrenade_a.dtx";

	m_nAmmoInClip		= GetShotsPerClip(m_nId);

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CKatoGrenade::CreateProjectile
//
//	PURPOSE:	Create the hand grenade projectile
//
// ----------------------------------------------------------------------- //

CProjectile* CKatoGrenade::CreateProjectile(ObjectCreateStruct & theStruct)
{
	CProjectile* pRet = DNULL;

	CServerDE* pServerDE = BaseClass::GetServerDE();

	if (pServerDE)
	{
		HCLASS hClass = pServerDE->GetClass("CKatoGrenadeProjectile");

		if (hClass)
		{
			pRet = (CProjectile*)pServerDE->CreateObject(hClass, &theStruct);
		}
	}

	return pRet;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CRamset::CRamset
//
//	PURPOSE:	Create the Ramset
//
// ----------------------------------------------------------------------- //

CRamset::CRamset() : CWeapon()
{
	m_nId			 = GUN_RAMSET_ID;
	m_eDamageType	 = DT_MELEE;

	m_pHandWeaponName	= "Models\\Powerups\\Ramset.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\Ramset_a.dtx";

	m_nAmmoInClip	= GetShotsPerClip(m_nId);
	m_bInfiniteAmmo	= DTRUE;

	m_fMinFireDuration	= 2.5f;
	m_fMaxFireDuration	= 4.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	CSqueakyToy::CSqueakyToy
//
//	PURPOSE:	Create the squeeky toy gun
//
// ----------------------------------------------------------------------- //

CSqueakyToy::CSqueakyToy() : CWeapon()
{
	m_nId			 = GUN_SQUEAKYTOY_ID;
	m_eDamageType	 = DT_SQUEAKY;

	m_pHandWeaponName	= "Models\\Powerups\\SqueakyToy.abc";
	m_pHandWeaponSkin	= "Skins\\Powerups\\SqueakyToy_a.dtx";

	m_bInfiniteAmmo	= DTRUE;

	m_fMinFireDuration	= 0.5f;
	m_fMaxFireDuration	= 2.0f;
	m_fMinFireRest		= 5.0f;
	m_fMaxFireRest		= 10.0f;
}

