// ----------------------------------------------------------------------- //
//
// MODULE  : Monolith.h
//
// PURPOSE : This is the Monolith object for DTM
//
// CREATED : 10/9/97
//
// ----------------------------------------------------------------------- //

/*
------------------
Monolith.h
------------------
*/

#ifndef __MONOLITH_H__
#define __MONOLITH_H__

#include "cpp_engineobjects_de.h"
#include "PlayerObj.h"
// This is always available, once you create your server shell.
class ServerDE;
class CRiotServerShell;

extern ServerDE *g_pServerDE;
extern CRiotServerShell *g_pRiotServerShellDE;


#include "Bouncer.h"
#include "Prop.h"

//#define UPDATE_DELTA 0.01f

class Monolith : public Prop
{
	public :

		Monolith();
		~Monolith();
		DBOOL m_bIsAway;
		DVector m_vOriginalPosition;
		HOBJECT		GetObject() {return m_hObject;}
	
		DDWORD	m_dwTeam;  // slutty

		CBouncer		m_bounce;

		void SetBounce(DBOOL yesno) { m_bBounce = yesno; }
		void GetMonolithInfo(DDWORD &Team, DFLOAT &HitPoints)
		{
			Team		= m_dwTeam;
			HitPoints	= m_fHitPoints;
		}

	protected :
		DVector			m_vDims;
		DVector			m_vScale;
		DDWORD	EngineMessageFn (DDWORD messageID, void *pData, DFLOAT lData);
		DDWORD  ObjectMessageFn( HOBJECT hSender, DDWORD messageID, HMESSAGEREAD hRead );
		void	ReadProp(ObjectCreateStruct *pStruct);
		void	ObjectTouch (HOBJECT hObject);


	protected:

		DBOOL	m_bBounce;			// Do we bounce
		//HSTRING m_hstrTeam;			// team
		//Team	m_eTeam;
		
		//HSTRING m_hstrSqueakyMessage;			// Trigger message
		//HSTRING m_hstrSqueakedAtSound;			// Sound played when squeaked at
		//HSTRING m_hstrDeathSound;				// Sound played when dead
		//HSTRING m_hstrDeathTriggerTarget;		// Target to trigger when dead
		//HSTRING m_hstrDeathTriggerMessage;		// Message to send target when dead
		//DFLOAT	m_fSoundRadius;					// Radius of sounds

	private :

		//void Save(HMESSAGEWRITE hWrite, DDWORD dwSaveFlags);
		//void Load(HMESSAGEREAD hRead, DDWORD dwLoadFlags);
		void CacheFiles();
};

#endif // __Monolith_H__

/*
------------
MONOLITH.H
------------
*/
