// ----------------------------------------------------------------------- //
//
// MODULE  : Monolith.cpp
//
// PURPOSE : Defending the Monolith: Monolith model - Definition
//
// CREATED : 03/23/99
//
// ----------------------------------------------------------------------- //

/*
------------------
Monolith.cpp
------------------
*/


#include "Monolith.h"
#include "InventoryTypes.h"
#include "cpp_server_de.h"
#include "generic_msg_de.h"
#include "DamageTypes.h"
#include "RiotObjectUtilities.h"
#include "RiotMsgIDs.h"
#include "PlayerObj.h"
#include "RiotServerShell.h"

//#include "SharedDefs.h"

BEGIN_CLASS(Monolith)
	ADD_LONGINTPROP(Team, 0.0f)
	ADD_VECTORPROP_VAL(Scale, 20.0f, 20.0f, 20.0f)
	ADD_STRINGPROP( HitPoints, "100000" )
	ADD_COLORPROP(TintColor, 0.0f, 0.0f, 0.0f) 
	ADD_REALPROP(Translucency, 1.0f)
END_CLASS_DEFAULT(Monolith, BaseClass, NULL, NULL)


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::Monolith()
//
//	PURPOSE:	Initialize object
//
// ----------------------------------------------------------------------- //

Monolith::Monolith() : Prop()
{
	m_dwTeam = 0;
	m_bIsAway = DFALSE;
	m_vDims.x = m_vDims.y = m_vDims.z = 20.0f;

	m_bBounce = DTRUE;

	VEC_SET(m_vScale, 20.0f, 20.0f, 20.0f);
	
	m_fHitPoints = 5000.0f;
	m_fArmorPoints = 0.0f;
	m_fMass = 100000.0f;
	
	//AddAggregate(&m_bounce);
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::~Monolith()
//
//	PURPOSE:	DealloFlage object
//
// ----------------------------------------------------------------------- //

Monolith::~Monolith()
{
	if( !g_pServerDE ) return;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::EngineMessageFn
//
//	PURPOSE:	Handle engine messages
//
// ----------------------------------------------------------------------- //

DDWORD Monolith::EngineMessageFn(DDWORD messageID, void *pData, DFLOAT fData)
{
	DBOOL	firstTime = DTRUE;
	
	if( g_pServerDE )
	{
		switch(messageID)
		{
			case MID_UPDATE:
			{
				
				CServerDE* pServerDE = GetServerDE();
				if (!pServerDE) return DFALSE;

				//DDWORD dwRet = Powerup::EngineMessageFn(messageID, pData, fData);
				if (m_bounce.IsDoneBouncing())
				{
					pServerDE->SetNextUpdate(m_hObject, 0.0f);
				}
				else
				{
					pServerDE->SetNextUpdate(m_hObject, 0.01f /*UPDATE_DELTA*/);
				}
					
				
				//return dwRet;
			}
			break;

			case MID_TOUCHNOTIFY:
			{
				firstTime = DFALSE;
			}
			break;

			case MID_INITIALUPDATE:
			{
				CServerDE* pServerDE = GetServerDE();
				if (!pServerDE) return DFALSE;
				pServerDE->GetObjectPos(m_hObject, &m_vOriginalPosition);
				pServerDE->SetObjectDims(m_hObject, &m_vDims);
				pServerDE->SetObjectFlags(m_hObject, FLAG_VISIBLE|FLAG_TOUCH_NOTIFY|FLAG_GRAVITY|FLAG_FORCECLIENTUPDATE|FLAG_SOLID|FLAG_BOXPHYSICS);
				
				VEC_SET(m_vScale, 20.0f, 20.0f, 20.0f);
				pServerDE->ScaleObject(m_hObject, &m_vScale);
				
				pServerDE->SetNextUpdate(m_hObject, 0.1f);
			}
			break;

			case MID_PRECREATE:
			{
				if(fData == PRECREATE_WORLDFILE)
				{
			
					CServerDE* pServerDE = GetServerDE();
					if (!pServerDE) return DFALSE;
				
					ObjectCreateStruct *pStruct;

					pStruct = (ObjectCreateStruct*)pData;
					pStruct->m_ObjectType = OT_MODEL;
				
					//ReadProp(pStruct);
					GenericProp prop;
					if(pServerDE->GetPropGeneric("Team", &prop) == LT_OK)
					{
						m_dwTeam = prop.m_Long;
					}
					
					SAFE_STRCPY(pStruct->m_Filename, "models\\monolith\\monolith.abc");
					
					if (m_dwTeam == 1)
					{
						SAFE_STRCPY(pStruct->m_SkinName, "skins\\monolith\\monolithr.dtx");
					}
					else
					{
						SAFE_STRCPY(pStruct->m_SkinName, "skins\\monolith\\monolithb.dtx");
					}

					SAFE_STRCPY(pStruct->m_Name, "Monolith");
					
					pStruct->m_Flags = FLAG_VISIBLE|FLAG_TOUCH_NOTIFY|FLAG_GRAVITY|FLAG_FORCECLIENTUPDATE|FLAG_SOLID|FLAG_BOXPHYSICS;
				
					CacheFiles();
				}
			}
			break;
			
			default : break;
		}
	}

	DDWORD retVal;
	retVal = Prop::EngineMessageFn(messageID, pData, fData);
	
	// DTM ----------------------------
	if (firstTime)
	{
		HMESSAGEWRITE hMessage = g_pServerDE->StartMessage(DNULL, MID_MONOLITH_UPDATE);
		g_pServerDE->WriteToMessageByte(hMessage, (DBYTE)m_dwTeam);
		g_pServerDE->WriteToMessageFloat(hMessage, m_fHitPoints);
		g_pServerDE->EndMessage(hMessage);
		
	//	VEC_SET(m_vScale, 20.0f, 20.0f, 20.0f);
	//	g_pServerDE->ScaleObject(m_hObject, &m_vScale);
		
		firstTime = DFALSE;
	}
	// --------------------------------
	
				
	return retVal;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Prop::ObjectMessageFn
//
//	PURPOSE:	Handle object-to-object messages
//
// ----------------------------------------------------------------------- //

DDWORD Monolith::ObjectMessageFn( HOBJECT hSender, DDWORD messageID, HMESSAGEREAD hRead )
{
	if (!g_pServerDE) return 0;
	
	DBOOL	bHaveWeBeenDamaged = DFALSE;

	switch(messageID)
	{
		
		case MID_DAMAGE:
		{
			bHaveWeBeenDamaged = DTRUE;		
			//g_pServerDE->CPrint("The Monolith's Team is %d", (DBYTE)m_dwTeam);
			//g_pServerDE->CPrint("The Monolith's HitPoints are %f", m_Damage.GetHitPoints());


			if (m_Damage.GetCanDamage())
			{
				//g_pServerDE->CPrint("The Monolith's Team is %d", (DBYTE)m_dwTeam);
			}
			break;
		}

		default : break;
	}
	
	DDWORD retVal;
	retVal = Prop::ObjectMessageFn(hSender, messageID, hRead);

	DFLOAT f_MonolithHitPoints = m_Damage.GetHitPoints();
	

	// If we were damaged, send a message to all clients reporting
	// the new Monolith hit points
	if (bHaveWeBeenDamaged)
	{
		HMESSAGEWRITE hMessage = g_pServerDE->StartMessage(DNULL, MID_MONOLITH_UPDATE);
		g_pServerDE->WriteToMessageByte(hMessage, (DBYTE)m_dwTeam);
		g_pServerDE->WriteToMessageFloat(hMessage, m_Damage.GetHitPoints());
		g_pServerDE->EndMessage(hMessage);
	
		bHaveWeBeenDamaged = DFALSE;
	}

		
	if (f_MonolithHitPoints <= 0)
		g_pRiotServerShellDE->GoToNextLevel();
		
	return retVal;
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::ReadProp()
//
//	PURPOSE:	Read Properties
//
// ----------------------------------------------------------------------- //

void Monolith::ReadProp(ObjectCreateStruct *pStruct)
{
	if (!g_pServerDE || !pStruct) return;

	//GenericProp genProp;

	long temp;
	g_pServerDE->GetPropLongInt("Team", &temp);
	m_dwTeam = (DDWORD)temp;
}




// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::CacheFiles
//
//	PURPOSE:	Cache resources used by the object
//
// ----------------------------------------------------------------------- //

void Monolith::CacheFiles()
{
	if (!g_pServerDE) return;

	char* pFile = DNULL;

	
}

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	Monolith::ObjectTouch
//
//	PURPOSE:	Send specific message to object that touched us
//
// ----------------------------------------------------------------------- //

void Monolith::ObjectTouch (HOBJECT hObject)
{

	CServerDE* pServerDE = GetServerDE();
	if (!pServerDE)
	{
	
		return;	
	}

	// Sanity checks...
	if (!hObject || !IsPlayer(hObject))
	{
		return;	
	}

	CPlayerObj* pPlayer = (CPlayerObj*) g_pServerDE->HandleToObject(hObject);
	if (pPlayer  && !pPlayer->IsDead())
	{
	}	
}



/*
------------
END Monolith.CPP
------------
*/
