#ifndef __WEAPONSTRINGDEFS_H
#define __WEAPONSTRINGDEFS_H

#include "WeaponDefs.h"
#include "ClientRes.h"

inline char* GetWeaponString(RiotWeaponId nWeaponId)
{
	if (!g_pClientDE) return "Error";

	DDWORD nStringID = IDS_UNUSED;

	switch (nWeaponId)
	{
		case GUN_PULSERIFLE_ID :
			nStringID = IDS_WEAPON_PULSERIFLE;
		break;

		case GUN_DEATHCHARGE_ID :
			nStringID = IDS_WEAPON_DEATHCHARGE;
		break;

		case GUN_HEALGUN_ID :
			nStringID = IDS_WEAPON_HEALGUN;
		break;
		
		case GUN_SICKGUN_ID :
			nStringID = IDS_WEAPON_SICKGUN;
		break;

		case GUN_BLINDER_ID :
			nStringID = IDS_WEAPON_BLINDER;
		break;

		case GUN_PULSELAUNCHER_ID :
			nStringID = IDS_WEAPON_PULSELAUNCHER;
		break;

		case GUN_SNIPERRIFLE_ID :
			nStringID = IDS_WEAPON_SNIPERRIFLE;
		break;

		case GUN_MASSDRIVER_ID :
			nStringID = IDS_WEAPON_MASSDRIVER;
		break;

		case GUN_RIOTCANNON_ID :
			nStringID = IDS_WEAPON_RIOTCANNON;
		break;

		case GUN_LITHKILLER_ID :
			nStringID = IDS_WEAPON_LITHKILLER;
		break;

		case GUN_BUZZSAW_ID :
			nStringID = IDS_WEAPON_BUZZSAW;
		break;

		case GUN_AXE_ID :
			nStringID = IDS_WEAPON_AXE;
		break;
		
		case GUN_SHOULDERCANNONS_ID :
			nStringID = IDS_WEAPON_SHOULDERCANNONS;
		break;

		case GUN_BIGBOOT_ID :
			nStringID = IDS_WEAPON_BIGBOOT;
		break;

		case GUN_SNIPERCLUB_ID :
			nStringID = IDS_WEAPON_SNIPERCLUB;
		break;


		// On-foot mode weapons...

		case GUN_COLT45_ID :
			nStringID = IDS_WEAPON_COLT45;
		break;

		case GUN_SHOTGUN_ID	:
			nStringID = IDS_WEAPON_SHOTGUN;
		break;

		case GUN_ASSAULTRIFLE_ID :
			nStringID = IDS_WEAPON_ASSAULTRIFLE;
		break;

		case GUN_ENERGYGRENADE_ID :
			nStringID = IDS_WEAPON_ENERGYGRENADE;
		break;

		case GUN_BOMBS_ID :
			nStringID = IDS_WEAPON_BOMBS;
		break;

		case GUN_KATOGRENADE_ID :
			nStringID = IDS_WEAPON_KATOGRENADE;
		break;

		case GUN_MAC10_ID :
			nStringID = IDS_WEAPON_MAC10;
		break;

		case GUN_TOW_ID	:
			nStringID = IDS_WEAPON_TOW;
		break;

		case GUN_AUTOCANNONS_ID :
			nStringID = IDS_WEAPON_AUTOCANNONS;
		break;

		case GUN_SQUEAKYTOY_ID :
			nStringID = IDS_WEAPON_SQUEAKYTOY;
		break;

		case GUN_RAMSET_ID :
			nStringID = IDS_WEAPON_RAMSET;
		break;

		case GUN_MACHINEGUN_ID :
			nStringID = IDS_WEAPON_MACHINEGUN;
		break;

		case GUN_ROCKETLAUNCHER_ID:
			nStringID = IDS_WEAPON_ROCKETLAUNCHER;
		break;

		default : break;
	}

	HSTRING hStr = g_pClientDE->FormatString (nStringID);
	if (!hStr) return "Error";

	static char strWeapon[128];
	SAFE_STRCPY(strWeapon, g_pClientDE->GetStringData (hStr));
	g_pClientDE->FreeString (hStr);

	return strWeapon;
}

inline char* GetAmmoString(RiotWeaponId nWeaponId)
{
	if (!g_pClientDE) return "Error";

	DDWORD nStringID = IDS_UNUSED;

	switch (nWeaponId)
	{
		// Mech mode weapons...	
	
		case GUN_PULSERIFLE_ID :
			nStringID = IDS_AMMO_PULSERIFLE;
		break;

		case GUN_DEATHCHARGE_ID :
			nStringID = IDS_AMMO_DEATHCHARGE;
		break;

		case GUN_HEALGUN_ID :
			nStringID = IDS_AMMO_HEALGUN;
		break;

		case GUN_SICKGUN_ID :
			nStringID = IDS_AMMO_SICKGUN;
		break;

		case GUN_BLINDER_ID :
			nStringID = IDS_AMMO_BLINDER;
		break;

		case GUN_PULSELAUNCHER_ID :
			nStringID = IDS_AMMO_PULSELAUNCHER;
		break;

		case GUN_SNIPERRIFLE_ID :
			nStringID = IDS_AMMO_SNIPERRIFLE;
		break;

		case GUN_MASSDRIVER_ID :
			nStringID = IDS_AMMO_MASSDRIVER;
		break;

		case GUN_RIOTCANNON_ID :
			nStringID = IDS_AMMO_RIOTCANNON;
		break;

		case GUN_LITHKILLER_ID :
			nStringID = IDS_AMMO_LITHKILLER;
		break;

		// On-foot mode weapons...

		case GUN_COLT45_ID :
			nStringID = IDS_AMMO_COLT45;
		break;

		case GUN_SHOTGUN_ID	:
			nStringID = IDS_AMMO_SHOTGUN;
		break;

		case GUN_ASSAULTRIFLE_ID :
			nStringID = IDS_AMMO_ASSAULTRIFLE;
		break;

		case GUN_ENERGYGRENADE_ID :
			nStringID = IDS_AMMO_ENERGYGRENADE;
		break;

		case GUN_BOMBS_ID :
			nStringID = IDS_AMMO_BOMBS;
		break;

		case GUN_KATOGRENADE_ID :
			nStringID = IDS_AMMO_KATOGRENADE;
		break;

		case GUN_MAC10_ID :
			nStringID = IDS_AMMO_MAC10;
		break;

		case GUN_TOW_ID	:
			nStringID = IDS_AMMO_TOW;
		break;

		case GUN_MACHINEGUN_ID :
			nStringID = IDS_AMMO_MACHINEGUN;
		break;

		case GUN_ROCKETLAUNCHER_ID :
			nStringID = IDS_AMMO_ROCKETLAUNCHER;
		break;


		case GUN_AUTOCANNONS_ID :
			nStringID = IDS_AMMO_AUTOCANNONS;
		break;

		default : break;
	}

	HSTRING hStr = g_pClientDE->FormatString (nStringID);
	if (!hStr) return "Error";

	static char strAmmo[128];
	SAFE_STRCPY(strAmmo, g_pClientDE->GetStringData (hStr));
	g_pClientDE->FreeString (hStr);

	return strAmmo;
}

inline RiotWeaponId GetWeaponId(char* pWeaponName)
{
	if (!pWeaponName || strlen(pWeaponName) < 5) return GUN_NONE;

	for(int i=GUN_FIRST_ID; i < GUN_MAX_NUMBER; i++)
	{
		if (_stricmp(pWeaponName, GetWeaponString((RiotWeaponId)i)) == 0)
		{
			return ((RiotWeaponId)i);
		}
	}

	return GUN_NONE;
}

#endif
