#include "ClientInfoMgr.h"
#include "cpp_client_de.h"
#include "TextHelper.h"
#include "font12.h"
#include "font28.h"
#include "RiotClientShell.h"
#include <stdio.h>
#include "ClientRes.h"		// DTM added 04/01/99

#define VERT_SPACING 3

extern CRiotClientShell* g_pRiotClientShell;

CClientInfoMgr::CClientInfoMgr()
{
	m_pClients = DNULL;
	m_pClientDE = DNULL;

	m_nLastFontSize = 0;
	m_bFragSurfacesUpToDate = DFALSE;

	m_hFragDisplay = DNULL;
	m_cxFragDisplay = 0;
	m_cyFragDisplay = 0;

	// DTM -----------------
	m_fBlueMonolithHP = 0;
	m_fRedMonolithHP = 0;

	m_hBlueMonolithHP = DNULL;
	m_cxBlueMonolithHP = 0;
	m_cyBlueMonolithHP = 0;

	m_hBlueLogo = DNULL;
	m_cxBlueLogo = 0;
	m_cyBlueLogo = 0;
	
	m_hRedMonolithHP = DNULL;
	m_cxRedMonolithHP = 0;
	m_cyRedMonolithHP = 0;

	m_hRedLogo = DNULL;
	m_cxRedLogo = 0;
	m_cyRedLogo = 0;
	
	m_bUpdateNow = DTRUE;
	// ---------------------

}

CClientInfoMgr::~CClientInfoMgr()
{
	if (!m_pClientDE) return;

	ClearAllFragSurfaces();

	CLIENT_INFO* ptr = DNULL;
	while (m_pClients)
	{
		ptr = m_pClients->pNext;
		m_pClientDE->FreeString (m_pClients->hstrName);
		delete m_pClients;
		m_pClients = ptr;
	}

	if (m_hFragDisplay) m_pClientDE->DeleteSurface (m_hFragDisplay);

	// DTM ----------------------
	if (m_hBlueMonolithHP) m_pClientDE->DeleteSurface (m_hBlueMonolithHP);
	if (m_hBlueLogo) m_pClientDE->DeleteSurface(m_hBlueLogo);
	if (m_hRedMonolithHP) m_pClientDE->DeleteSurface (m_hRedMonolithHP);
	if (m_hRedLogo) m_pClientDE->DeleteSurface(m_hRedLogo);
}

void CClientInfoMgr::Init (CClientDE* pClientDE)
{
	m_pClientDE = pClientDE;

	UpdateFragDisplay (0);
}

void CClientInfoMgr::AddClient (HSTRING hstrName, DDWORD nID, int nFragCount, DBYTE r, DBYTE g, DBYTE b)
{
	if (!m_pClientDE) return;

	// if we already have this client in the list, just return

	CLIENT_INFO* pDup = m_pClients;
	while (pDup)
	{
		if (pDup->nID == nID) return;
		pDup = pDup->pNext;
	}

	// create the new object

	CLIENT_INFO* pNew = new CLIENT_INFO;
	if (!pNew) return;

	pNew->nID = nID;
	pNew->hstrName = hstrName;
	pNew->nFrags = nFragCount;
	pNew->r = r;
	pNew->g = g;
	pNew->b = b;

	// if this client is us, update our frag display

	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);
	if (pNew->nID == nLocalID)
	{
		UpdateFragDisplay (0);
	}

	// if we don't have a list yet, set the list pointer to the new object

	if (!m_pClients)
	{
		m_pClients = pNew;
		return;
	}

	// we do have a list - add the new object at the end

	CLIENT_INFO* ptr = m_pClients;
	while (ptr->pNext)
	{
		ptr = ptr->pNext;
	}
	ptr->pNext = pNew;
	pNew->pPrev = ptr;

	// if we're drawing all frag surfaces, redo them since this guy may affect the font size

	if (m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
	}
}

void CClientInfoMgr::RemoveClient (DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) break;
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// remove the client from the list

	if (ptr->pNext) ptr->pNext->pPrev = ptr->pPrev;
	if (ptr->pPrev) ptr->pPrev->pNext = ptr->pNext;
	if (m_pClients == ptr) m_pClients = ptr->pNext;

	m_pClientDE->FreeString (ptr->hstrName);
	delete ptr;

	// if we're drawing all frag surfaces, redo them since this guy may affect the font size

	if (m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
	}
}

void CClientInfoMgr::RemoveAllClients()
{
	if (!m_pClientDE) return;

	ClearAllFragSurfaces();

	CLIENT_INFO* ptr = DNULL;
	while (m_pClients)
	{
		ptr = m_pClients->pNext;
		m_pClientDE->FreeString (m_pClients->hstrName);
		delete m_pClients;
		m_pClients = ptr;
	}
	
	UpdateFragDisplay (0);
}

void CClientInfoMgr::AddFrag (DDWORD nLocalID, DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID)
		{
			// add to the frag count
			ptr->nFrags++;
			
			// update the frag display
			if (nLocalID == nID) UpdateFragDisplay (ptr->nFrags);

			// if we're drawing all frag counts, update this client
			if (m_bFragSurfacesUpToDate)
			{
				UpdateSingleFragSurface (ptr);
			}
			
			break;
		}
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// put this client in the correct position in the list (most frags to least frags)

	CLIENT_INFO* pCurrent = ptr;
	while (ptr->pPrev && pCurrent->nFrags > ptr->pPrev->nFrags)	ptr = ptr->pPrev;
	if (ptr == pCurrent) return;

	// we found a new position - remove current from the list

	pCurrent->pPrev->pNext = pCurrent->pNext;
	if (pCurrent->pNext) pCurrent->pNext->pPrev = pCurrent->pPrev;

	// put us back in in the correct position

	if (!ptr->pPrev)
	{
		m_pClients = pCurrent;
	}

	pCurrent->pPrev = ptr->pPrev;
	pCurrent->pNext = ptr;
	if (ptr->pPrev) ptr->pPrev->pNext = pCurrent;
	ptr->pPrev = pCurrent;
}

void CClientInfoMgr::RemoveFrag (DDWORD nLocalID, DDWORD nID)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID)
		{
			// remove from the frag count
			ptr->nFrags--;
			
			// update the frag display
			if (nLocalID == nID) UpdateFragDisplay (ptr->nFrags);
			
			// if we're drawing all frag counts, update this client
			if (m_bFragSurfacesUpToDate)
			{
				UpdateSingleFragSurface (ptr);
			}
			
			break;
		}
		ptr = ptr->pNext;
	}
	if (!ptr) return;

	// put this client in the correct position in the list (most frags to least frags)

	CLIENT_INFO* pCurrent = ptr;
	while (ptr->pNext && pCurrent->nFrags < ptr->pNext->nFrags)	ptr = ptr->pNext;
	if (ptr == pCurrent) return;

	// we found a new position - remove current from the list

	pCurrent->pNext->pPrev = pCurrent->pPrev;
	if (pCurrent->pPrev) pCurrent->pPrev->pNext = pCurrent->pNext;
	if (m_pClients == pCurrent) m_pClients = pCurrent->pNext;

	// put us back in in the correct position

	pCurrent->pPrev = ptr;
	pCurrent->pNext = ptr->pNext;
	if (ptr->pNext) ptr->pNext->pPrev = pCurrent;
	ptr->pNext = pCurrent;
}

DDWORD CClientInfoMgr::GetNumClients()
{
	if (!m_pClientDE) return 0;

	CLIENT_INFO* ptr = m_pClients;

	DDWORD nCount = 0;
	while (ptr)
	{
		nCount++;
		ptr = ptr->pNext;
	}

	return nCount;
}

char* CClientInfoMgr::GetPlayerName (DDWORD nID)
{
	if (!m_pClientDE) return DNULL;

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) return m_pClientDE->GetStringData (ptr->hstrName);
		ptr = ptr->pNext;
	}

	return "";
}


// DTM GET TEAM
DBYTE CClientInfoMgr::GetTeam (DDWORD nID)
{
	if (!m_pClientDE) return DNULL;
	
	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) return (ptr->r);
		ptr = ptr->pNext;
	}

	return DNULL;
}

void CClientInfoMgr::SetTeamColor(DDWORD nID, DBYTE theNewColor)
{
	if (!m_pClientDE || !m_pClients) return;

	// find the client

	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID)
		{
			// update the frag display
			//if (nLocalID == nID) UpdateFragDisplay (ptr->nFrags);
			
			// if we're drawing all frag counts, update this client
			
			if ((int)theNewColor == 0)
			{
				ptr->r = 0;
				ptr->g = 0;
				ptr->b = 255;
			}
			else
			{
				ptr->r = 255;
				ptr->g = 0;
				ptr->b = 0;
			}
			UpdateSingleNameSurface (ptr);
				
			break;
		}
		ptr = ptr->pNext;
	}
	if (!ptr) return;
}


void CClientInfoMgr::UpdateFragDisplay (int nFrags)
{
	if (!m_pClientDE) return;

	if (m_hFragDisplay) m_pClientDE->DeleteSurface (m_hFragDisplay);

	char str[16];
	itoa (nFrags, str, 10);
	
	m_hFragDisplay = CTextHelper::CreateSurfaceFromString (m_pClientDE, g_pRiotClientShell->GetMenu()->GetFont28s(), str);
	m_pClientDE->GetSurfaceDims (m_hFragDisplay, &m_cxFragDisplay, &m_cyFragDisplay);

	HDECOLOR hTransColor = m_pClientDE->SetupColor2(0.0f, 0.0f, 0.0f, DTRUE);
	m_pClientDE->OptimizeSurface (m_hFragDisplay, hTransColor);
}

void CClientInfoMgr::UpdateAllFragSurfaces()
{
	if (!m_pClientDE) return;

	// get our local id
	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);
	
	// make sure all surfaces are deleted
	ClearAllFragSurfaces();

	// get the screen surface and it's dimensions
	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nWidth = 0;
	DDWORD nHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nWidth, &nHeight);

	// setup the necessary stuff
	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);
	CFont12* pFontNormal = g_pRiotClientShell->GetMenu()->GetFont12n();
	CFont12* pFontSelected = g_pRiotClientShell->GetMenu()->GetFont12s();
	
	
	
	//----------------------------------------------------------------------
	// DTM changes
	//char		nameStringMonoliths[256];
	//HSURFACE	MonolithHP;
	//CSize		szSize;

	//sprintf(nameStringMonoliths, "Blue Monolith HP : %f", m_fBlueMonolithHP);
	//pClient->hName = CTextHelper::CreateSurfaceFromString (m_pClientDE, pFontNormal, nameStringMonoliths);
	//m_pClientDE->GetSurfaceDims (MonolithHP, &(szSize.cx), &(szSize.cy));
	//m_pClientDE->OptimizeSurface (MonolithHP, hTransColor);
	//----------------------------------------------------------------------

	
	// create new surfaces
	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		char* pstrName = m_pClientDE->GetStringData(pClient->hstrName);
		char nameString[256];
		if(pstrName && pstrName[0])
		{
		}
		else
		{
			pstrName = "unnamed";
		}
		
		DRect fillRect;
				
		sprintf(nameString, "  (%d) %s", (int)(pClient->m_Ping * 1000.0f), pstrName);
		pClient->hName = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, nameString);
		
		m_pClientDE->GetSurfaceDims (pClient->hName, &pClient->szName.cx, &pClient->szName.cy);

		fillRect.left = fillRect.top = 0;
		fillRect.right = 10;
		fillRect.bottom = pClient->szName.cy;
		m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(220, 220, 220)); //220'S ALL
		
		fillRect.left++;
		fillRect.top++;
		fillRect.right--;
		fillRect.bottom--;

		// DTM
		DBYTE red = GetTeam(pClient->nID);
		if (red == 1 || pClient->r == 255)
		{
			pClient->r = 255;
			pClient->g = 0;
			pClient->b = 0;
			m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));
		}
		else
		{
			pClient->b = 255;
			pClient->g = 0;
			pClient->r = 0;
			m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));
		}

		m_pClientDE->OptimizeSurface (pClient->hName, hTransColor);

		char strFragCount[16];
		itoa (pClient->nFrags, strFragCount, 10);

		pClient->hFragCount = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, strFragCount);
		m_pClientDE->GetSurfaceDims (pClient->hFragCount, &pClient->szFragCount.cx, &pClient->szFragCount.cy);
		m_pClientDE->OptimizeSurface (pClient->hFragCount, hTransColor);

		pClient = pClient->pNext;
	}

	// set the flag
	m_bFragSurfacesUpToDate = DTRUE;
}

void CClientInfoMgr::ClearAllFragSurfaces()
{
	if (!m_pClientDE) return;

	CLIENT_INFO* pClient = m_pClients;
	while (pClient)
	{
		if (pClient->hFragCount) m_pClientDE->DeleteSurface (pClient->hFragCount);
		pClient->hFragCount = DNULL;
		pClient->szFragCount.cx = pClient->szFragCount.cy = 0;
		
		if (pClient->hName) m_pClientDE->DeleteSurface (pClient->hName);
		pClient->hName = DNULL;
		pClient->szName.cx = pClient->szName.cy = 0;

		pClient = pClient->pNext;
	}
	
	m_bFragSurfacesUpToDate = DFALSE;
}

void CClientInfoMgr::UpdateSingleFragSurface (CLIENT_INFO* pClient)
{
	if (!m_pClientDE || !pClient || !m_bFragSurfacesUpToDate) return;

	if (pClient->hFragCount) m_pClientDE->DeleteSurface (pClient->hFragCount);
	pClient->hFragCount = DNULL;

	// get our local id
	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);

	// create the font
	CFont12* pFontNormal = g_pRiotClientShell->GetMenu()->GetFont12n();
	CFont12* pFontSelected = g_pRiotClientShell->GetMenu()->GetFont12s();
	
	// create new surfaces
	if (pClient->hFragCount)
	{
		m_pClientDE->DeleteSurface (pClient->hFragCount);
		pClient->hFragCount = DNULL;
		pClient->szFragCount.cx = pClient->szFragCount.cy = 0;
	}
	
	char strFragCount[12];
	memset (strFragCount, 0, 12);
	itoa (pClient->nFrags, strFragCount, 10);

	pClient->hFragCount = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, strFragCount);
	m_pClientDE->GetSurfaceDims (pClient->hFragCount, &pClient->szFragCount.cx, &pClient->szFragCount.cy);

	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);
	m_pClientDE->OptimizeSurface (pClient->hFragCount, hTransColor);
}


void CClientInfoMgr::UpdateSingleNameSurface (CLIENT_INFO* pClient)
{
	if (!m_pClientDE || !pClient /*|| !m_bFragSurfacesUpToDate*/) return;

	if (pClient->hName) m_pClientDE->DeleteSurface (pClient->hName);
	pClient->hName = DNULL;
	
	// get our local id
	DDWORD nLocalID = 0;
	m_pClientDE->GetLocalClientID (&nLocalID);

	// create the font
	CFont12* pFontNormal = g_pRiotClientShell->GetMenu()->GetFont12n();
	CFont12* pFontSelected = g_pRiotClientShell->GetMenu()->GetFont12s();
	
	// create new surfaces
	if (pClient->hName)
	{
		m_pClientDE->DeleteSurface (pClient->hName);
		pClient->hName = DNULL;
		pClient->szFragCount.cx = pClient->szFragCount.cy = 0;
	}
	
	
	char* pstrName = m_pClientDE->GetStringData(pClient->hstrName);
	char nameString[256];
	if(pstrName && pstrName[0])
	{
	}
	else
	{
		pstrName = "unnamed";
	}
	
	DRect fillRect;
			
	sprintf(nameString, "  (%d) %s", (int)(pClient->m_Ping * 1000.0f), pstrName);
	pClient->hName = CTextHelper::CreateSurfaceFromString (m_pClientDE, (pClient->nID == nLocalID) ? pFontSelected : pFontNormal, nameString);
	
	m_pClientDE->GetSurfaceDims (pClient->hName, &pClient->szName.cx, &pClient->szName.cy);

	fillRect.left = fillRect.top = 0;
	fillRect.right = 10;
	fillRect.bottom = pClient->szName.cy;
	m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(220, 220, 220)); //220'S ALL
	
	fillRect.left++;
	fillRect.top++;
	fillRect.right--;
	fillRect.bottom--;

	// DTM
	//DBYTE red = GetTeam(pClient->nID);
	if (/*red == 1 ||*/ pClient->r == 255)
	{
		pClient->r = 255;
		pClient->g = 0;
		pClient->b = 0;
		//m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));
		m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(255, 0, 0));
	}
	else
	{
		pClient->b = 255;
		pClient->g = 0;
		pClient->r = 0;
		//m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(pClient->r, pClient->g, pClient->b));
		m_pClientDE->FillRect(pClient->hName, &fillRect, SETRGB(0, 0, 255));
	}

	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE);
	m_pClientDE->OptimizeSurface (pClient->hName, hTransColor);
}



void CClientInfoMgr::Draw (DBOOL bDrawSingleFragCount, DBOOL bDrawAllFragCounts)
{
	if (!m_pClientDE || (!bDrawSingleFragCount && !bDrawAllFragCounts)) return;

	// make sure we're in a network game

	int nGameMode = 0;
	m_pClientDE->GetGameMode(&nGameMode);
	if (nGameMode == STARTGAME_NORMAL || nGameMode == GAMEMODE_NONE) return;

	// see if we need to update all the surfaces

	if (m_bUpdateNow) UpdateMonolithHPSurfaces();
	
	if (bDrawAllFragCounts && !m_bFragSurfacesUpToDate)
	{
		UpdateAllFragSurfaces();
		//UpdateMonolithHPSurfaces();
	}
	else if (!bDrawAllFragCounts && m_bFragSurfacesUpToDate)
	{
		ClearAllFragSurfaces();
	}

	HSURFACE hScreen = m_pClientDE->GetScreenSurface();
	DDWORD nScreenWidth = 0;
	DDWORD nScreenHeight = 0;
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight);
	int nHalfWidth = (int)nScreenWidth / 2;

	// should we draw our frag count?
	if (bDrawSingleFragCount)
	{
		m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hFragDisplay, DNULL, nScreenWidth - m_cxFragDisplay, 0, DNULL);
		DrawMonolithHPSurfaces();	// DTM
	}

	// should we draw all the frag counts?
	
	

	if (bDrawAllFragCounts && m_bFragSurfacesUpToDate)
	{
	
		int nTotalHeight = 0;			// DTM we'll use this for total height of the red players
		int nTotalHeightBlue = 0;		// DTM total height for the blue players
		int nClients = 0;
		CLIENT_INFO* pClient = m_pClients;
		while (pClient)
		{
			if (pClient->r == 0)
			{
				nTotalHeight += __max (pClient->szName.cy, pClient->szFragCount.cy);
				nTotalHeight += VERT_SPACING;
			}
			else
			{
				nTotalHeightBlue += __max (pClient->szName.cy, pClient->szFragCount.cy);
				nTotalHeightBlue += VERT_SPACING;
			}
							
			++nClients;
			pClient = pClient->pNext;
		}
		
		
		if (nTotalHeightBlue > nTotalHeight)
			nTotalHeight = nTotalHeightBlue;

		
		int nY = ((int)nScreenHeight - nTotalHeight) / 2;
		if (nY < 0) nY = 0;

		
		int nYBlue = nY;


		int i, nSorted;
		CLIENT_INFO *sorted[128], *pClosest;
		if(nClients > 128)
			nClients = 128;

		// Sort them..
		pClosest = DNULL;
		nSorted = 0;
		pClient = m_pClients;
		while(nSorted < nClients)
		{
			sorted[nSorted++] = pClient;
			pClient = pClient->pNext;
		}

		DBOOL bHappy = DFALSE;
		while(!bHappy)
		{
			bHappy = DTRUE;
			for(i=0; i < (nSorted-1); i++)
			{
				if(sorted[i]->nFrags < sorted[i+1]->nFrags)
				{
					CLIENT_INFO *pTemp = sorted[i];
					sorted[i] = sorted[i+1];
					sorted[i+1] = pTemp;
					bHappy = DFALSE;
				}
			}
		}
	
		for(i=0; i < nSorted; i++)
		{
			pClient = sorted[i];

			// Ok.. draw.
			//m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hName, DNULL, nHalfWidth - pClient->szName.cx - 5, nY, DNULL);
			//m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hFragCount, DNULL, nHalfWidth + 5, nY, DNULL);

			// DTM we're going to seperate the teams into two columns... red on the left
			// and blue on the right
			if (pClient->r == 0)
			{
				m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hName, DNULL, nHalfWidth, nYBlue, DNULL);
				m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hFragCount, DNULL, nHalfWidth + pClient->szName.cx + 20, nYBlue, DNULL);
			
				nYBlue += __max (pClient->szName.cy, pClient->szFragCount.cy) + VERT_SPACING;
			}
			else
			{
				m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hName, DNULL, 15, nY, DNULL);
				m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, pClient->hFragCount, DNULL, pClient->szName.cx + 20, nY, DNULL);
			
				nY += __max (pClient->szName.cy, pClient->szFragCount.cy) + VERT_SPACING;
			}
		
			if (nY + __max (pClient->szName.cy, pClient->szFragCount.cy) > (int)nScreenHeight) break;
			if (nYBlue + __max (pClient->szName.cy, pClient->szFragCount.cy) > (int)nScreenHeight) break;
		}
	}
	m_bUpdateNow = DFALSE;		// DTM
}

CLIENT_INFO* CClientInfoMgr::GetClientByID(DDWORD nID)
{
	CLIENT_INFO* ptr = m_pClients;
	while (ptr)
	{
		if (ptr->nID == nID) 
			return ptr;

		ptr = ptr->pNext;
	}
	return DNULL;
}

// DTM -------------------------------------------------
void CClientInfoMgr::SetMonolithHP(DBYTE theTeam, DFLOAT value)
{
	if (theTeam == 0)
		m_fBlueMonolithHP = value;
	else
		m_fRedMonolithHP = value;

	m_bUpdateNow = DTRUE;
}

DBYTE CClientInfoMgr::GetWinningMonolith()
{
	if (m_fBlueMonolithHP < m_fRedMonolithHP)	// Red Wins
		return 1;
	else if (m_fRedMonolithHP < m_fBlueMonolithHP)	// Blue Wins
		return 2;
	else			// either a tie or something went wrong
		return 0;
}

void CClientInfoMgr::UpdateMonolithHPSurfaces()
{
	//Clear all stuff 
	if (m_hBlueMonolithHP) m_pClientDE->DeleteSurface (m_hBlueMonolithHP);
	m_hBlueMonolithHP  = DNULL; 
	m_cxBlueMonolithHP = 0; 
	m_cyBlueMonolithHP = 0; 
	if (m_hRedMonolithHP) m_pClientDE->DeleteSurface (m_hRedMonolithHP);
	m_hRedMonolithHP  = DNULL; 
	m_cxRedMonolithHP = 0; 
	m_cyRedMonolithHP = 0; 
	if (m_hBlueLogo) m_pClientDE->DeleteSurface (m_hBlueLogo);
	m_hBlueLogo = DNULL; 
	m_cxBlueLogo = 0; 
	m_cyBlueLogo = 0; 
	if (m_hRedLogo) m_pClientDE->DeleteSurface (m_hRedLogo);
	m_hRedLogo  = DNULL; 
	m_cxRedLogo = 0; 
	m_cyRedLogo = 0; 

	
		
	char nameStringBlueMonolith[256];
	char nameStringRedMonolith[256];
	HDECOLOR hTransColor = m_pClientDE->SetupColor1(0.0f, 0.0f, 0.0f, DTRUE); 
	CFont08*	pFontNormal = g_pRiotClientShell->GetMenu()->GetFont08s();

	
	// Do the blue
	sprintf(nameStringBlueMonolith, "%d", (int)m_fBlueMonolithHP);
	m_hBlueMonolithHP = CTextHelper::CreateSurfaceFromString (m_pClientDE, pFontNormal, nameStringBlueMonolith);
	m_pClientDE->GetSurfaceDims (m_hBlueMonolithHP, &m_cxBlueMonolithHP, &m_cyBlueMonolithHP); 
	m_pClientDE->OptimizeSurface (m_hBlueMonolithHP, hTransColor);

	m_hBlueLogo = m_pClientDE->CreateSurfaceFromBitmap("interface\\Bear.PCX"); 
	m_pClientDE->GetSurfaceDims (m_hBlueLogo, &m_cxBlueLogo, &m_cyBlueLogo); 
	m_pClientDE->OptimizeSurface(m_hBlueLogo, hTransColor); 


	// Do the red
	sprintf(nameStringRedMonolith, "%d", (int)m_fRedMonolithHP);
	m_hRedMonolithHP = CTextHelper::CreateSurfaceFromString (m_pClientDE, pFontNormal, nameStringRedMonolith);
	m_pClientDE->GetSurfaceDims (m_hRedMonolithHP, &m_cxRedMonolithHP, &m_cyRedMonolithHP); 
	m_pClientDE->OptimizeSurface (m_hRedMonolithHP, hTransColor);

	m_hRedLogo = m_pClientDE->CreateSurfaceFromBitmap("interface\\Fox.PCX"); 
	m_pClientDE->GetSurfaceDims (m_hRedLogo, &m_cxRedLogo, &m_cyRedLogo); 
	m_pClientDE->OptimizeSurface(m_hRedLogo, hTransColor); 

	
	//m_bUpdateNow = DFALSE;
} 


void CClientInfoMgr::DrawMonolithHPSurfaces()
{
	HSURFACE hScreen = m_pClientDE->GetScreenSurface(); 
	DDWORD nScreenWidth = 0; 
	DDWORD nScreenHeight = 0; 
	m_pClientDE->GetSurfaceDims (hScreen, &nScreenWidth, &nScreenHeight); 

	//m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hBlueMonolithHP, DNULL, (int)(nScreenWidth/2.0f-m_cxBlueMonolithHP/2.0f), (int)(nScreenHeight/2.0f-m_cyBlueMonolithHP/2.0f), DNULL); 
	DDWORD nDrawX = 0;
	DDWORD nDrawY = 0;

	
	// Draw the Blue logo
	nDrawX = nScreenWidth - m_cxBlueLogo - 5;
	nDrawY = (nScreenHeight / 2) - m_cyBlueLogo;
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hBlueLogo, DNULL, nDrawX, nDrawY, DNULL);
	
	// Draw the Blue Monolith HP
	nDrawX = nDrawX + (m_cxBlueLogo / 2) - (m_cxBlueMonolithHP / 2);
	nDrawY = nDrawY + (m_cyBlueLogo / 2) - (m_cyBlueMonolithHP / 2);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hBlueMonolithHP, DNULL, nDrawX, nDrawY, DNULL); 
	
	
	// Draw the Red Logo
	nDrawX = nScreenWidth - m_cxRedLogo - 5;
	nDrawY = (nScreenHeight /2);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hRedLogo, DNULL, nDrawX, nDrawY, DNULL); 
	
	// Draw the Red Monolith HP
	nDrawX = nDrawX + (m_cxRedLogo / 2) - (m_cxRedMonolithHP / 2);
	nDrawY = nDrawY + (m_cyRedLogo / 2) - (m_cyRedMonolithHP / 2);
	m_pClientDE->DrawSurfaceToSurfaceTransparent (hScreen, m_hRedMonolithHP, DNULL, nDrawX, nDrawY, DNULL); 
} 


