// ----------------------------------------------------------------------- //
//
// MODULE  : CharacterAttributes.h
//
// PURPOSE : Definitions for default character attributes
//
// CREATED : 12/9/97
//
// ----------------------------------------------------------------------- //

#ifndef __CHARACTER_ATTRIBUTES_H__
#define __CHARACTER_ATTRIBUTES_H__

#include "basetypes_de.h"
#include "ModelIds.h"
#include "ModelFuncs.h"

DFLOAT GetDefaultMass(DBYTE nId, ModelSize size);
DFLOAT GetDefaultHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxHitPts(DBYTE nId, ModelSize size);
DFLOAT GetDefaultArmor(DBYTE nId, ModelSize size);
DFLOAT GetDefaultMaxArmor(DBYTE nId, ModelSize size);


// Defines....

#define INFINITE_MASS						100000.0f

// Player attributes...

#define	CA_PLAYER_ONFOOT_MASS				2000.0f
#define	CA_PLAYER_MECHA_MASS				100.0f //DTM MASS

#define	CA_PLAYER_ONFOOT_HITPTS				100.0f
#define	CA_PLAYER_ONFOOT_MAX_HITPTS			CA_PLAYER_ONFOOT_HITPTS
#define	CA_PLAYER_ONFOOT_ARMOR				50.0f
#define	CA_PLAYER_ONFOOT_MAX_ARMOR			(CA_PLAYER_ONFOOT_ARMOR*4.0f)

#define	CA_PLAYER_KID_HITPTS				50.0f
#define	CA_PLAYER_KID_MAX_HITPTS			CA_PLAYER_KID_HITPTS
#define	CA_PLAYER_KID_ARMOR					0.0f
#define	CA_PLAYER_KID_MAX_ARMOR				CA_PLAYER_KID_ARMOR

#define	CA_PLAYER_SNIPER_HITPTS				90.0f
#define	CA_PLAYER_HEAVYW_HITPTS		    	200.0f
#define	CA_PLAYER_DEMOMAN_HITPTS			150.0f
#define	CA_PLAYER_ROCKETEER_HITPTS			100.0f

#define	CA_PLAYER_SNIPER_MAX_HITPTS			CA_PLAYER_SNIPER_HITPTS
#define	CA_PLAYER_HEAVYW_MAX_HITPTS	    	CA_PLAYER_HEAVYW_HITPTS
#define	CA_PLAYER_DEMOMAN_MAX_HITPTS		CA_PLAYER_DEMOMAN_HITPTS
#define	CA_PLAYER_ROCKETEER_MAX_HITPTS		CA_PLAYER_ROCKETEER_HITPTS

#define	CA_PLAYER_SNIPER_ARMOR				45.0f
#define	CA_PLAYER_HEAVYW_ARMOR			    200.0f
#define	CA_PLAYER_DEMOMAN_ARMOR				150.0f
#define	CA_PLAYER_ROCKETEER_ARMOR			90.0f

#define	CA_PLAYER_SNIPER_MAX_ARMOR			(CA_PLAYER_SNIPER_ARMOR*2.0f)
#define	CA_PLAYER_HEAVYW_MAX_ARMOR	      	(CA_PLAYER_HEAVYW_ARMOR*2.0f)
#define	CA_PLAYER_DEMOMAN_MAX_ARMOR			(CA_PLAYER_DEMOMAN_ARMOR*2.0f)
#define	CA_PLAYER_ROCKETEER_MAX_ARMOR		(CA_PLAYER_ROCKETEER_ARMOR*2.0f)
#define	CA_PLAYER_CONSTRUCTOR_MAX_ARMOR		(CA_PLAYER_CONSTRUCTOR_ARMOR*2.0f)

#endif // __CHARACTER_ATTRIBUTES_H__
