// ----------------------------------------------------------------------- //
//
// MODULE  : CharacterAttributes.cpp
//
// PURPOSE : Implementation of character attributes
//
// CREATED : 12/9/97
//
// ----------------------------------------------------------------------- //

#include "CharacterAttributes.h"


DFLOAT s_fCharacterMasses[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MASS,	// Sanjuro
	CA_PLAYER_ONFOOT_MASS,	// Kid
	CA_PLAYER_MECHA_MASS,	// Player Sniper
	CA_PLAYER_MECHA_MASS,	// Player Heavyw
	CA_PLAYER_MECHA_MASS,	// Player Demoman
	CA_PLAYER_MECHA_MASS,	// Player Rocketeer
};

DFLOAT s_fCharacterHitPts[MI_LAST] =
{
	CA_PLAYER_ONFOOT_HITPTS,	// Sanjuro
	CA_PLAYER_KID_HITPTS,		// Kid
	CA_PLAYER_SNIPER_HITPTS,		// Player Sniper
	CA_PLAYER_HEAVYW_HITPTS,	// Player Heavyw
	CA_PLAYER_DEMOMAN_HITPTS,		// Player Demoman
	CA_PLAYER_ROCKETEER_HITPTS,	// Player Rocketeer
};

DFLOAT s_fCharacterMaxHitPts[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MAX_HITPTS,	// Sanjuro
	CA_PLAYER_KID_MAX_HITPTS,		// Kid
	CA_PLAYER_SNIPER_MAX_HITPTS,		// Player Sniper
	CA_PLAYER_HEAVYW_MAX_HITPTS,	// Player Heavyw
	CA_PLAYER_DEMOMAN_MAX_HITPTS,		// Player Demoman
	CA_PLAYER_ROCKETEER_MAX_HITPTS,	// Player Rocketeer
};

DFLOAT s_fCharacterArmor[MI_LAST] =
{
	CA_PLAYER_ONFOOT_ARMOR,		// Sanjuro
	CA_PLAYER_KID_ARMOR,		// Kid
	CA_PLAYER_SNIPER_ARMOR,		// Player Sniper
	CA_PLAYER_HEAVYW_ARMOR,	// Player Heavyw
	CA_PLAYER_DEMOMAN_ARMOR,		// Player Demoman
	CA_PLAYER_ROCKETEER_ARMOR,	// Player Rocketeer
};

DFLOAT s_fCharacterMaxArmor[MI_LAST] =
{
	CA_PLAYER_ONFOOT_MAX_ARMOR,		// Sanjuro
	CA_PLAYER_KID_MAX_ARMOR,		// Kid
	CA_PLAYER_SNIPER_MAX_ARMOR,		// Player Sniper
	CA_PLAYER_HEAVYW_MAX_ARMOR,	// Player Heavyw
	CA_PLAYER_DEMOMAN_MAX_ARMOR,		// Player Demoman
	CA_PLAYER_ROCKETEER_MAX_ARMOR,	// Player Rocketeer
};

// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMass
//
//	PURPOSE:	Return the mass associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMass(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MASS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMasses[nId];

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultHitPts
//
//	PURPOSE:	Return the hit pts associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultHitPts(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_HITPTS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterHitPts[nId];

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMaxHitPts
//
//	PURPOSE:	Return the max hit pts associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMaxHitPts(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MAX_HITPTS;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMaxHitPts[nId];

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultArmor
//
//	PURPOSE:	Return the armor associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultArmor(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_ARMOR;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterArmor[nId];

	return fRet;
}


// ----------------------------------------------------------------------- //
//
//	ROUTINE:	GetDefaultMaxArmor
//
//	PURPOSE:	Return the max armor associated with a particular id
//
// ----------------------------------------------------------------------- //

DFLOAT GetDefaultMaxArmor(DBYTE nId, ModelSize size)
{
	DFLOAT fRet = CA_PLAYER_ONFOOT_MAX_ARMOR;

	if (nId < MI_FIRST || nId >= MI_LAST) return fRet;

	fRet = s_fCharacterMaxArmor[nId];

	return fRet;
}
