/*****************************************************
Copyright Notice & Disclaimer

Copyright  Ascent, Dark Yoda and Otis

Permission to use, copy, modify, and distribute this software
and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice, author statement
appear in all copies of this software and related documentation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF
ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT
LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A
PARTICULAR PURPOSE.

IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE,
AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION
WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
******************************************************/
//////////////////////////////////////////////////////////////////////
// FILE: Mdlv2Doc.cpp
// PURPOSE: Implementation of the Mdlv2Doc class. 
//////////////////////////////////////////////////////////////////////
// SHORT DESCRIPTION:
// This class implements the document object that is used hold 1 modelobject. (in a mdlview object)
// Per loaded model is 1 document object created
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 01-april-1999
// [OTIS] Fixed memleak when closing application.
// [OTIS] Fixed file not closed bug when saving model.
//
// 31-mar-1999
// [OTIS] Fixed resize bug
// [OTIS] Included reinit cycle system for texture refresh
// [OTIS] Implemented texture import/export
//
// 25-mar-1999
// [OTIS] Added texture selection, chromeflag toggle
// [OTIS] Added modelsave
// [OTIS] Improved initialize/loading scheme. Now bogus files are not loaded and no view is displayed
//
// 20-mar-1999
// [OTIS] Rewritten code for new naming schedule. Like hungarian.
// [OTIS] Move of iD and Valve c-lib files into the code dir.
// [OTIS] Cleaned up code by removing not used code and definitions.
//
// 16-mar-1999.
//		First public release.
//
// 08-feb-1999. 
//		First Internal Version 
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "mdlv2.h"
#include "mdlview.h"
#include "mdlv2Doc.h"
#include "ControlCntr.h"

// define pointer to the MCC dialog that is defined only once in the application object
extern	CControlCntr *dlgCntrlCenter;

// TODO: recode this to a sizable buffer. Although windows cannot handle paths longer than 254 chars, there is still
// a bad limit in this code.
char		cMdlFilename[1024];
CMdlView	*m_pModel;

IMPLEMENT_DYNCREATE(CMdlv2Doc, CDocument)

BEGIN_MESSAGE_MAP(CMdlv2Doc, CDocument)
	//{{AFX_MSG_MAP(CMdlv2Doc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// Purpose: Constructor
CMdlv2Doc::CMdlv2Doc()
{
	m_pModel = new CMdlView();
	strcpy(cMdlFilename,"");

	if(dlgCntrlCenter==NULL)
	{
		// create contrlcenter dialog...
		dlgCntrlCenter = new CControlCntr();
		(void)dlgCntrlCenter->Create(IDD_MENU,NULL);
		(void)dlgCntrlCenter->ShowWindow(SW_SHOW);
	}
}


// Purpose: Destructor
CMdlv2Doc::~CMdlv2Doc()
{
	// the document is being removed from memory. Remove modelviewer object and tell the MCC that this document
	// is no longer valid. (everything will be disabled)
	delete m_pModel;
	dlgCntrlCenter->SetNotValid(this);
}


// Purpose: new document event handler
BOOL 
CMdlv2Doc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
	{
		return FALSE;
	}
	return TRUE;
}


// Purpose: save the data inside the document
// Additional info: not used now.
void 
CMdlv2Doc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


#ifdef _DEBUG
void CMdlv2Doc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMdlv2Doc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// Purpose: Open Document event handler
BOOL 
CMdlv2Doc::OnOpenDocument(LPCTSTR lpszPathName)
{
	bool	bResult;

	if (!CDocument::OnOpenDocument(lpszPathName))
	{
		return FALSE;	
	}

	// store the filename. The initialisation is done from the viewwindow. This is due to the
	// fact that there is rendercode inside the mdlview_obj object.
	// strcpy will always succeed, because filename is shorter than cMdlFilename length
	strcpy(cMdlFilename,lpszPathName);
	bResult = m_pModel->LoadModel(cMdlFilename);
	if(!bResult)
	{
		// modelload failed
		AfxMessageBox("Could not initialize model in file. Perhaps not a modelfile?",MB_OK+MB_ICONEXCLAMATION+MB_APPLMODAL);
		return FALSE;
	}
	return true;
}


// Purpose: returns the filename of the model currently in core of this document
char
*CMdlv2Doc::GetFileName()
{
	// return the filename to the object
	return cMdlFilename;
}


// Purpose: returns a pointer to the modelobject currently in core of this document
CMdlView
*CMdlv2Doc::GetMdlView()
{
	// return the object
	return m_pModel;
}


// Purpose: marks THIS document as the active document at the MCC.
void
CMdlv2Doc::SetActive()
{
	// will set this model the current active model in modelcontrol center.
	// the dialog is global, we have just 1, and now call some functions to show info...
	dlgCntrlCenter->ActiveDoc(this);
}


// Purpose: activates an update cycle inside the MCC to reset all data shown
void
CMdlv2Doc::UpdateMCC()
{
	dlgCntrlCenter->UpdateAll();
}


// Purpose: saves the current loaded model. 
void
CMdlv2Doc::SaveModel()
{
	int				iResult;
	CFileDialog		*cfFileDlg;
 
	cfFileDlg = new CFileDialog(FALSE,"mdl",NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,"Half-life Models (*.mdl)|*.mdl|",NULL);

	iResult = cfFileDlg->DoModal();

	if(iResult==IDOK)
	{
		// user pressed OK.
		// call save function in model.
		m_pModel->SaveModel(cfFileDlg->GetPathName(),cfFileDlg->GetFileTitle());
	}
	delete cfFileDlg;
}


