//////////////////////////////////////////////////////////////////////
// FILE: StudioModel.h
// PURPOSE: Headerfile, belonging to Studio_render.cpp, studiomodel.cpp and studio_utils.cpp
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
// Note: Based on Valve Software's modelviewer 1.0 code. Some code licensed from iD software.
// (c)1996-1999 by the owners of the codeparts.
//
//-----[Valve header]------------
//	Copyright (c) 1998, Valve LLC. All rights reserved.
//	
//	This product contains software technology licensed from Id 
//	Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
//	All Rights Reserved.
//-----[End Valve header]--------
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 20-mar-1999
// [OTIS] added RM_ADDITIVE rendermode: bones AND transparent textures.
//
// 16-mar-1999.
//		First public release.
//
// 08-feb-1999. 
//		First Internal Version 
//
//////////////////////////////////////////////////////////////////////
#ifndef _STUDIOMODEL_H
#define _STUDIOMODEL_H

#include "mathlib.h"
#include "studio.h"

#define RM_LINEDRAW 0
#define RM_TEXTURED 1
#define RM_SHADED   2
#define RM_ADDITIVE 3

class StudioModel
{
public:
	// FUNCTIONS
							StudioModel();
	virtual					~StudioModel();
	bool					LoadModel( char *modelname );
	void					Init(void);
	void					DrawModel( void );
	void					AdvanceFrame( float dt );
	void					ExtractBbox( float *mins, float *maxs );
	int						SetSequence( int iSequence );
	int						GetSequence( void );
	void					GetSequenceInfo( float *pflFrameRate, float *pflGroundSpeed );
	float					SetController( int iController, float flValue );
	float					SetMouth( float flValue );
	float					SetBlending( int iBlender, float flValue );
	int						SetBodygroup( int iGroup, int iValue );
	void					SetSkin( int iValue );
	char					*GetSequenceLabel(void);
	long					GetSequenceLength(void);
	int						GetCurrentBodyNumber(void);
	void					SetBodyNr(int nr);
	int						GetBodyAmount(void);
	int						GetSeqAmount(void);
	void					SetRenderMode(int mode);
	void					SetFog(bool fogyn, float fogstrt, float fogstop);
	void					SetFogColor(float r, float g, float b);
	void					Clear(void);
	void					SetLightColor(float r, float g, float b);
	void					DelTextures(void);
	int						GetCurrentTextureNr(void);
	void					SetTextureNr(int iNr);
	int						GetMaxTextureNr(void);
	bool					GetCurTextChromeFlag(void);
	void					ToggleCurTextChromeFlag(void);
	void					SaveModel(CString sPathFilename, CString sFileTitle);
	void					ExportCurrentTexture(void);
	void					ImportCurrentTexture(void);
	bool					CheckDoInit(void);
	int						GetMaxSkinNr(void);
	int						GetSkinNr(void);

	// VARS
	// NO PUBLIC VARS ALLOWED

private:
	// VARS
	float					m_fDstAlpha;

	bool					m_bTexSelectFlickerFlag;
	bool					m_bDoInit;						// flag to signal the upper layer we want a new initialisation cycle done.
	int						m_iCurrentTexture;				// current selected texture. if 0, nothing selected
	bool					m_bCurrentTextureOn;			// true if current selected texture is visible (for blinking)
	int						*pSavedTIndexes;				// pointer to buffer where saved textureindexes are put for modelsave...
	vec3_t					g_xformverts[MAXSTUDIOVERTS];	// transformed vertices
	vec3_t					g_lightvalues[MAXSTUDIOVERTS];	// light surface normals
	vec3_t					*g_pxformverts;
	vec3_t					*g_pvlightvalues;
	vec3_t					g_lightvec;						// light vector in model reference frame
	vec3_t					g_blightvec[MAXSTUDIOBONES];	// light vectors in bone reference frames
	int						g_ambientlight;					// ambient world light
	float					g_shadelight;					// direct world light
	vec3_t					g_lightcolor;
	int						g_smodels_total;				// cookie
	float					g_bonetransform[MAXSTUDIOBONES][3][4];	// bone transformation matrix
	int						g_chrome[MAXSTUDIOVERTS][2];	// texture coords for surface normals
	int						g_chromeage[MAXSTUDIOBONES];	// last time chrome vectors were updated
	vec3_t					g_chromeup[MAXSTUDIOBONES];		// chrome vector "up" in bone reference frames
	vec3_t					g_chromeright[MAXSTUDIOBONES];	// chrome vector "right" in bone reference frames
	// memory anchers.
	byte					*CoreFile;
	byte					*TextureFile;
	byte					*SequenceFiles[32];
	BOOL					ModelLoaded;
	int						CoreFileLength;
	int						TextureFileLength;
	int						SequenceFilesLength[32];
	vec3_t					g_vright;
	float					g_lambert;
	float					fg_r, fg_g, fg_b;
	bool					fog_enabled;
	float					fog_start;
	float					fog_end;
	int						maxnummodels;
	int						rendermode;
	int						m_iNumOfTextures;
	int						m_iSkinAmount;
	// entity settings
	vec3_t					m_origin;
	vec3_t					m_angles;	
	int						m_sequence;			// sequence index
	float					m_frame;			// frame
	int						m_bodynum;			// bodypart selection	
	int						m_skinnum;			// skin group selection
	byte					m_controller[4];	// bone controllers
	byte					m_blending[2];		// animation blending
	byte					m_mouth;			// mouth position
	// internal data
	studiohdr_t				*m_pstudiohdr;
	mstudiomodel_t			*m_pmodel;
	studiohdr_t				*m_ptexturehdr;
	studioseqhdr_t			*m_panimhdr[32];
	vec4_t					m_adj;				// FIX: non persistant, make static
	float					m_lightb, m_lightg, m_lightr;

	// FUNCTIONS
	void					CalcBoneAdj( void );
	void					CalcBoneQuaternion( int frame, float s, mstudiobone_t *pbone, mstudioanim_t *panim, float *q );
	void					CalcBonePosition( int frame, float s, mstudiobone_t *pbone, mstudioanim_t *panim, float *pos );
	void					CalcRotations ( vec3_t *pos, vec4_t *q, mstudioseqdesc_t *pseqdesc, mstudioanim_t *panim, float f );
	mstudioanim_t			*GetAnim( mstudioseqdesc_t *pseqdesc );
	void					SlerpBones( vec4_t q1[], vec3_t pos1[], vec4_t q2[], vec3_t pos2[], float s );
	void					SetUpBones ( void );
	void					DrawPoints( int mode );
	void					Lighting (float *lv, int bone, int flags, vec3_t normal);
	void					Chrome (int *chrome, int bone, vec3_t normal);
	void					SetupLighting( void );
	void					SetupModel ( int bodypart );
	void					UploadTexture( mstudiotexture_t *ptexture, byte *data, byte *pal, int g_texnum );
	void					DrawBones( void );
	void					DrawIcosahedron(float x,float y,float z,float size);
	void					DoExportBMP(byte *pBitData, byte *pColorData, CString sFilename, mstudiotexture_t *pTexture);
	bool					DoImportBMP(byte *pBitData, byte *pColorData, CString sFilename, mstudiotexture_t *pTexture);
};

#endif