//////////////////////////////////////////////////////////////////////
// FILE: StudioModel.cpp
// PURPOSE: Implementation of the initcode for the StudioModel class
//////////////////////////////////////////////////////////////////////
// SHORT DESCRIPTION:
// Here is the construction/destruction code of the StudioModel class
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
// Note: Based on Valve Software's modelviewer 1.0 code. Some code licensed from iD software.
// (c)1996-1999 by the owners of the codeparts.
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 16-mar-1999.
//		First public release.
//
// 15-mar-1999. 
// [OTIS] Moved global valve initialization code inside classbody. (IEK! why do people always use GLOBAL STATICS!)
//
// 08-feb-1999. 
//		First Internal Version 
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "StudioModel.h"

StudioModel::StudioModel()
{
	int i;

	// constructorcode.
	g_lambert = 1.5;

	CoreFile = NULL;
	CoreFileLength = 0;

	TextureFile =  NULL;
	TextureFileLength=0;

	for(i=0;i<32;i++)
	{
		SequenceFilesLength[i] = 0;
		SequenceFiles[i] = NULL;
	}

	g_vright[0]=g_vright[1]=g_vright[2]=0.f;
	fg_r=fg_g=fg_b=0;
	maxnummodels=0;
	rendermode=0;
	m_origin[0]=m_origin[1]=m_origin[2]=0.f;
	m_angles[0]=m_angles[1]=m_angles[2]=0.f;
	m_sequence=0;
	m_frame = 0.f;
	m_bodynum=0;
	m_skinnum=0;
	m_controller[0]=m_controller[1]=m_controller[2]=m_controller[3]=0;
	m_blending[0]=m_blending[1]=m_blending[2]=0;
	m_mouth=0;

	fog_enabled = false;
	fog_start = 1.7f;
	fog_end = 2.0f;

	m_lightr = 1.0f;
	m_lightg = 1.0f;
	m_lightb = 1.0f;

	m_adj[0]=m_adj[1]=m_adj[2]=m_adj[3]=0.f;
	ModelLoaded = false;

	m_iCurrentTexture = 0;
	m_bCurrentTextureOn = false;
	m_iNumOfTextures = 0;
	pSavedTIndexes=NULL;
	m_bDoInit=false;
	m_iSkinAmount=0;
	m_bTexSelectFlickerFlag=false;
}

StudioModel::~StudioModel()
{
	Clear();
}

void
StudioModel::Clear()
{
	int i;

	if(pSavedTIndexes!=NULL)
	{
		free(pSavedTIndexes);
	}
	if(CoreFileLength>0)
	{
		free(CoreFile);
	}
	if(TextureFileLength>0)
	{
		free(TextureFile);
	}
	for(i=0;i<32;i++)
	{
		if(SequenceFilesLength[i]>0)
		{
			free(SequenceFiles[i]);
		}
	}
}

