/*****************************************************
Copyright Notice & Disclaimer

Copyright  Ascent, Dark Yoda and Otis

Permission to use, copy, modify, and distribute this software
and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice, author statement
appear in all copies of this software and related documentation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF
ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT
LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A
PARTICULAR PURPOSE.

IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE,
AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION
WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
******************************************************/
//////////////////////////////////////////////////////////////////////
// FILE: mdlview.h
// PURPOSE: headerfile, belonging to mdlview.cpp
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 25-mar-1999
// [OTIS] Added texture selection, chromeflag toggle
// [OTIS] Added modelsave
// [OTIS] Improved initialize/loading scheme. Now bogus files are not loaded and no view is displayed
//
// 20-mar-1999
// [OTIS] Rewritten code for new naming schedule. Like hungarian.
// [OTIS] Move of iD and Valve c-lib files into the code dir.
// [OTIS] Cleaned up code by removing not used code and definitions.
// [OTIS] added RM_ADDITIVE rendermode: bones AND transparent textures.
//
// 16-mar-1999.
//		First public release.
//
// 08-feb-1999. 
//		First Internal Version 
//
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_MDLVIEW_H__ECDB1EF1_BDEA_11D2_BCBD_006008E81F34__INCLUDED_)
#define AFX_MDLVIEW_H__ECDB1EF1_BDEA_11D2_BCBD_006008E81F34__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "StudioModel.h"

typedef unsigned char	byte;

// Increase this define if more rendermodes are added, otherwise these won't be shown.
#define MAXRENDERMODES 4

class CMdlView  
{
private:
	// VARS
	float		m_fGlDepthMin;
	float		m_fGlDepthMax;
	int			m_iRenderMode;
	float		m_fBgColorRed,m_fBgColorGreen,m_fBgColorBlue;
	float		m_fLightColorRed,m_fLightColorGreen,m_fLightColorBlue;
	float		m_fTransX,m_fTransY,m_fTransZ,m_fRotX,m_fRotY;
	int			m_iBodyGrp;
	bool		m_bFogEnabled;
	float		m_fFogStart;
	float		m_fFogStop;
	float		m_fCurrentFrame;
	float		m_fPrevFrame;
	StudioModel m_smCurrentModel;
	bool		m_bModelLoaded;
	bool		m_bModelInitialized;
	// FUNCTIONS
	void		DoRenderModelFrame(void);

public:
	// FUNCTIONS
				CMdlView();
	virtual		~CMdlView();
	bool		LoadModel(char *cpFilename);
	void		InitModel(void);
	void		SetupRenderer(void);
	void		RenderFrame(void);
	void		Rotate(int iXDelta, int iYDelta);
	void		Pan(int iXDelta, int iYDelta);
	void		Zoom(short sZDelta);
	void		NextSequence(void);
	void		PrevSequence(void);
	void		ToggleFog(bool FogOn);
	bool		GetFogToggleStatus(void);
	void		IncFogDistance(void);
	void		DecFogDistance(void);
	void		NextBody(void);
	void		ToggleRenderMode(void);
	int			GetCurrentSequenceNr(void);
	char		*GetCurrentSequenceName(void);
	long		GetCurrentSequenceLength(void);
	int			GetMaxSequenceNr(void);
	int			GetCurrentBodyNr(void);
	int			GetSequenceAmount(void);
	int			GetBodyAmount(void);
	void		SetBGColor(int iRed, int iGreen, int iBlue);
	void		SetLightColor(int iRed, int iGreen, int iBlue);
	void		DelTextures(void);
	int			GetCurrentTextureNr(void);
	void		SetTextureNr(int iNr);
	int			GetMaxTextureNr(void);
	bool		GetCurTextChromeFlag(void);
	void		ToggleCurTextChromeFlag(void);
	bool		IsModelLoaded(void);
	bool		IsModelInitialized(void);
	void		SaveModel(CString sPathFilename, CString sFileTitle);
	void		ExportCurrentTexture(void);
	void		ImportCurrentTexture(void);
	bool		CheckDoInit(void);
	int			GetCurrentSkinNr(void);
	int			GetMaxSkinNr(void);
	void		SetCurrentSkinNr(int iNr);

	// VARS
	// NO PUBLIC VARS ALLOWED.
};

#endif // !defined(AFX_MDLVIEW_H__ECDB1EF1_BDEA_11D2_BCBD_006008E81F34__INCLUDED_)
