/*****************************************************
Copyright Notice & Disclaimer

Copyright  Ascent, Dark Yoda and Otis

Permission to use, copy, modify, and distribute this software
and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice, author statement
appear in all copies of this software and related documentation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF
ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT
LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A
PARTICULAR PURPOSE.

IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE,
AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION
WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
******************************************************/
//////////////////////////////////////////////////////////////////////
// FILE: ControlCntr.h
// PURPOSE: headerfile, belonging to ControlCntr.cpp
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 31-mar-1999
// [OTIS] Fixed resize bug
// [OTIS] Included reinit cycle system for texture refresh
// [OTIS] Implemented texture import/export
//
// 25-mar-1999
// [OTIS] Added texture selection, chromeflag toggle
// [OTIS] Added modelsave
// [OTIS] Improved initialize/loading scheme. Now bogus files are not loaded and no view is displayed
//
// 20-mar-1999
// [OTIS] Rewritten code for new naming schedule. Like hungarian.
// [OTIS] Move of iD and Valve c-lib files into the code dir.
// [OTIS] Cleaned up code by removing not used code and definitions.
//
// 16-mar-1999.
//		First public release.
//
// 15-mar-1999. 
//		First Internal Version 
//
//////////////////////////////////////////////////////////////////////


#if !defined(AFX_CONTROLCNTR_H__A7046251_DA1E_11D2_BCFD_006008E81F34__INCLUDED_)
#define AFX_CONTROLCNTR_H__A7046251_DA1E_11D2_BCFD_006008E81F34__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// ControlCntr.h : header file
//
#include	"mdlview.h"
#include	"mdlv2Doc.h"

/////////////////////////////////////////////////////////////////////////////
// CControlCntr dialog

class CControlCntr : public CDialog
{
// Construction
public:
	CControlCntr(CWnd* pParent = NULL);   // standard constructor

	void		ActiveDoc(CMdlv2Doc *pDoc);
	void		SetNotValid(CMdlv2Doc *pDoc);
	void		UpdateAll(void);
	void		OnCancel(void);

// Dialog Data
	//{{AFX_DATA(CControlCntr)
	enum { IDD = IDD_MENU };
	CString	m_CurrentSequenceTxt;
	BOOL	m_FogEnabled;
	int		m_CurrentSequenceNr;
	long	m_SequenceLength;
	int		m_MaxNrSequence;
	short	m_ZoomFactor;
	int		m_MaxNrBodies;
	int		m_CurrentBodyNr;
	CString	m_sCurrentTexture;
	int		m_iMaxTexture;
	BOOL	m_ChromeEnabled;
	int		m_iCurrentSkinNr;
	int		m_iMaxSkinNr;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CControlCntr)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	CMdlv2Doc	*m_pCurrentDoc;

	void		InitDialog(void);
	void		ClearAll(void);
	void		UpdateViewInfo(CMdlView *pModel);
	void		UpdateSequenceInfo(CMdlView *pModel);
	void		UpdateBodyInfo(CMdlView *pModel);
	void		UpdateTextureInfo(CMdlView *pModel);
	void		ChangeControlState(BOOL bState,int iID);

	// Generated message map functions
	//{{AFX_MSG(CControlCntr)
	afx_msg void OnPrevsequence();
	afx_msg void OnSetbgcolor();
	afx_msg void OnFog();
	afx_msg void OnNextsequence();
	afx_msg void OnNextBody();
	afx_msg void OnRendermode();
	afx_msg void OnDeltaposZoominout(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeltaposFogdistance(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSetlightcolor();
	afx_msg void OnPrevtxt();
	afx_msg void OnNexttxt();
	afx_msg void OnTxtchrome();
	afx_msg void OnExptxt();
	afx_msg void OnImptxt();
	afx_msg void OnNxtskin();
	afx_msg void OnTxtnone();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CONTROLCNTR_H__A7046251_DA1E_11D2_BCFD_006008E81F34__INCLUDED_)
